/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.ProductFile;
import org.eclipse.pde.internal.build.XMLWriter;
import org.eclipse.pde.internal.build.site.PDEState;
import org.eclipse.update.core.IFeature;
import org.osgi.framework.Version;

public class FeatureGenerator
extends AbstractScriptGenerator {
    private static final String FEATURE_PLATFORM_LAUNCHERS = "org.eclipse.platform.launchers";
    private static final String FEATURE_EXECUTABLE = "org.eclipse.equinox.executable";
    private static final String BUNDLE_OSGI = "org.eclipse.osgi";
    private static final String BUNDLE_LAUNCHER = "org.eclipse.equinox.launcher";
    private String featureId = null;
    private String productFile = null;
    private String[] pluginList = null;
    private String[] fragmentList = null;
    private String[] featureList = null;
    private boolean includeLaunchers = true;
    private ProductFile product = null;
    private boolean verify = false;
    private Properties antProperties;

    private static Set createSet(String[] contents) {
        if (contents == null) {
            return new LinkedHashSet(0);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(contents.length);
        int i = 0;
        while (i < contents.length) {
            if (contents[i] != null) {
                result.add(contents[i]);
            }
            ++i;
        }
        return result;
    }

    public void generate() throws CoreException {
        AbstractScriptGenerator.setStaticAntProperties(this.antProperties);
        try {
            this.initialize();
            Set plugins = FeatureGenerator.createSet(this.pluginList);
            Set features = FeatureGenerator.createSet(this.featureList);
            Set fragments = FeatureGenerator.createSet(this.fragmentList);
            if (this.product != null) {
                if (this.product.useFeatures()) {
                    features.addAll(this.product.getFeatures());
                } else {
                    plugins.addAll(this.product.getPlugins(false));
                    fragments.addAll(this.product.getFragments());
                }
            }
            try {
                this.createFeature(this.featureId, plugins, fragments, features);
            }
            catch (FileNotFoundException e) {
                Status status = new Status(4, "org.eclipse.pde.build", 23, NLS.bind((String)Messages.error_creatingFeature, (Object)e.getLocalizedMessage()), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            AbstractScriptGenerator.setStaticAntProperties(null);
        }
    }

    public void setProductFile(String productFile) {
        this.productFile = productFile;
    }

    public void setPluginList(String[] pluginList) {
        this.pluginList = pluginList;
    }

    public void setFeatureList(String[] featureList) {
        this.featureList = featureList;
    }

    public void setFragmentList(String[] fragmentList) {
        this.fragmentList = fragmentList;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public void setIncludeLaunchers(boolean includeLaunchers) {
        this.includeLaunchers = includeLaunchers;
    }

    private void initialize() throws CoreException {
        File dir = new File(FeatureGenerator.getWorkingDirectory(), "features/" + this.featureId);
        File xml = new File(dir, "feature.xml");
        if (xml.exists()) {
            xml.delete();
        }
        if (this.productFile != null && !this.productFile.startsWith("${") && this.productFile.length() > 0) {
            String productPath = this.findFile(this.productFile, false);
            File f = null;
            if (productPath != null) {
                f = new File(productPath);
            } else {
                f = new File(this.productFile);
                if (!(f.exists() && f.isFile() || (f = new File(FeatureGenerator.getWorkingDirectory(), this.productFile)).exists() && f.isFile())) {
                    f = new File(String.valueOf(FeatureGenerator.getWorkingDirectory()) + "/" + "plugins", this.productFile);
                }
            }
            if (f.exists() && f.isFile()) {
                this.product = new ProductFile(f.getAbsolutePath(), null);
            } else {
                Status error = new Status(4, "org.eclipse.pde.build", 24, NLS.bind((String)Messages.exception_missingElement, (Object)this.productFile), null);
                throw new CoreException((IStatus)error);
            }
        }
    }

    private void addLauncher(PDEState state, Set plugins, Set fragments, Set features) {
        BundleDescription bundle = state.getResolvedBundle(BUNDLE_OSGI);
        if (bundle == null) {
            return;
        }
        Version version = bundle.getVersion();
        if (version.compareTo((Object)new Version("3.3")) < 0) {
            features.add(FEATURE_PLATFORM_LAUNCHERS);
        } else {
            IFeature executableFeature = null;
            try {
                executableFeature = this.getSite(false).findFeature(FEATURE_EXECUTABLE, null, false);
            }
            catch (CoreException coreException) {}
            if (executableFeature != null) {
                features.add(FEATURE_EXECUTABLE);
            } else {
                plugins.add(BUNDLE_LAUNCHER);
                List configs = FeatureGenerator.getConfigInfos();
                Iterator iterator = configs.iterator();
                while (iterator.hasNext()) {
                    Config config = (Config)iterator.next();
                    String fragment = "org.eclipse.equinox.launcher." + config.getWs() + '.' + config.getOs();
                    if (config.getOs().compareToIgnoreCase("macosx") != 0) {
                        fragment = String.valueOf(fragment) + '.' + config.getArch();
                    }
                    fragments.add(fragment);
                }
            }
        }
    }

    protected void createFeature(String feature, Set plugins, Set fragments, Set features) throws CoreException, FileNotFoundException {
        block41: {
            String location = "features/" + feature;
            File directory = new File(FeatureGenerator.getWorkingDirectory(), location);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            PDEState state = this.verify ? this.getSite(false).getRegistry() : null;
            BundleHelper helper = BundleHelper.getDefault();
            if (this.verify && this.includeLaunchers) {
                this.addLauncher(state, plugins, fragments, features);
            }
            File file = new File(directory, "feature.xml");
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
            XMLWriter writer = null;
            try {
                writer = new XMLWriter(output);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return;
            }
            try {
                String name;
                HashMap<String, String> parameters = new HashMap<String, String>();
                Hashtable<String, String> environment = new Hashtable<String, String>(3);
                parameters.put("id", feature);
                parameters.put("version", "1.0.0");
                writer.startTag("feature", parameters, true);
                boolean fragment = false;
                List configs = FeatureGenerator.getConfigInfos();
                configs.remove(Config.genericConfig());
                Iterator configIterator = configs.iterator();
                Iterator listIter = plugins.iterator();
                if (!listIter.hasNext()) {
                    fragment = true;
                    listIter = fragments.iterator();
                }
                Config currentConfig = Config.genericConfig();
                while (currentConfig != null) {
                    ((Dictionary)environment).put("osgi.os", currentConfig.getOs());
                    ((Dictionary)environment).put("osgi.ws", currentConfig.getWs());
                    ((Dictionary)environment).put("osgi.arch", currentConfig.getArch());
                    while (listIter.hasNext()) {
                        boolean writeBundle;
                        name = (String)listIter.next();
                        boolean unpack = true;
                        boolean bl = writeBundle = !this.verify;
                        if (this.verify) {
                            BundleDescription bundle = state.getResolvedBundle(name);
                            if (bundle != null) {
                                String filterSpec = bundle.getPlatformFilter();
                                if (filterSpec == null || helper.createFilter(filterSpec).match(environment)) {
                                    writeBundle = true;
                                    unpack = this.guessUnpack(bundle, (String[])state.getExtraData().get(new Long(bundle.getBundleId())));
                                    if (currentConfig.equals(Config.genericConfig())) {
                                        listIter.remove();
                                    }
                                }
                            } else {
                                BundleDescription[] bundles = state.getState().getBundles(name);
                                boolean error = true;
                                if (bundles != null && bundles.length > 0) {
                                    ResolverError[] errors = state.getState().getResolverErrors(bundles[0]);
                                    int i = 0;
                                    while (i < errors.length) {
                                        if ((errors[i].getType() & 0x2000) != 0) {
                                            error = false;
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                                if (error) {
                                    String message = NLS.bind((String)Messages.exception_missingPlugin, (Object)name);
                                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, message, null));
                                }
                            }
                        }
                        if (writeBundle) {
                            parameters.clear();
                            parameters.put("id", name);
                            parameters.put("version", "0.0.0");
                            parameters.put("unpack", unpack ? "true" : "false");
                            if (!currentConfig.equals(Config.genericConfig())) {
                                parameters.put("os", currentConfig.getOs());
                                parameters.put("ws", currentConfig.getWs());
                                parameters.put("arch", currentConfig.getArch());
                            }
                            if (fragment) {
                                parameters.put("fragment", "true");
                            }
                            writer.printTag("plugin", parameters, true, true, true);
                        }
                        if (fragment || listIter.hasNext() || fragments.size() <= 0) continue;
                        fragment = true;
                        listIter = fragments.iterator();
                    }
                    if (!this.verify || !configIterator.hasNext()) break;
                    if (plugins.size() > 0) {
                        fragment = false;
                        listIter = plugins.iterator();
                    } else {
                        listIter = fragments.iterator();
                    }
                    currentConfig = (Config)configIterator.next();
                }
                Iterator iter = features.iterator();
                while (iter.hasNext()) {
                    name = (String)iter.next();
                    if (this.verify) {
                        this.getSite(false).findFeature(name, null, true);
                    }
                    parameters.clear();
                    parameters.put("id", name);
                    parameters.put("version", "0.0.0");
                    writer.printTag("includes", parameters, true, true, true);
                }
                writer.endTag("feature");
            }
            finally {
                writer.close();
            }
            file = new File(directory, "build.properties");
            Properties prop = new Properties();
            prop.put("pde", "marker");
            OutputStream stream = null;
            try {
                try {
                    stream = new BufferedOutputStream(new FileOutputStream(file));
                    prop.store(stream, "Marker File so that the file gets written");
                    stream.flush();
                }
                catch (IOException iOException) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block41;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
        this.reportResolutionErrors = verify;
    }

    public boolean guessUnpack(BundleDescription bundle, String[] classpath) {
        if (bundle == null) {
            return true;
        }
        if (bundle.getHost() != null && bundle.getName().startsWith(BUNDLE_LAUNCHER)) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        if (classpath.length == 0) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            if (classpath[i].equals(".")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setImmutableAntProperties(Properties properties) {
        this.antProperties = properties;
    }
}

