/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.CatchAllValue;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Messages;
import org.eclipse.pde.internal.build.PDEUIStateWrapper;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class PDEState
implements IPDEBuildConstants,
IBuildPropertiesConstants {
    private static final String PROFILE_EXTENSION = ".profile";
    private static final String SYSTEM_PACKAGES = "org.osgi.framework.system.packages";
    private StateObjectFactory factory = Platform.getPlatformAdmin().getFactory();
    protected State state = this.factory.createState();
    private long id;
    private Properties repositoryVersions;
    private HashMap bundleClasspaths;
    private Map patchBundles;
    private List addedBundle;
    private List unqualifiedBundles;
    private Dictionary platformProperties;
    private List sortedBundles = null;
    private long lastSortingDate = 0L;
    private String javaProfile;
    private String[] javaProfiles;
    static /* synthetic */ Class class$0;

    protected long getNextId() {
        return ++this.id;
    }

    public PDEState(PDEUIStateWrapper initialState) {
        this();
        this.state = initialState.getState();
        this.factory = this.state.getFactory();
        this.id = initialState.getNextId();
        this.bundleClasspaths = initialState.getClasspaths();
        this.patchBundles = initialState.getPatchData();
        this.addedBundle = new ArrayList();
        this.unqualifiedBundles = new ArrayList();
        this.forceQualifiers();
    }

    public PDEState() {
        this.state.setResolver(Platform.getPlatformAdmin().getResolver());
        this.id = 0L;
        this.bundleClasspaths = new HashMap();
        this.patchBundles = new HashMap();
        this.loadPluginTagFile();
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public boolean addBundleDescription(BundleDescription toAdd) {
        return this.state.addBundle(toAdd);
    }

    private PluginConverter acquirePluginConverter() throws Exception {
        BundleHelper bundleHelper = BundleHelper.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PluginConverter)bundleHelper.acquireService(clazz.getName());
    }

    public boolean addBundle(Dictionary enhancedManifest, File bundleLocation) {
        this.updateVersionNumber(enhancedManifest);
        try {
            BundleDescription descriptor = this.factory.createBundleDescription(this.state, enhancedManifest, bundleLocation.getAbsolutePath(), this.getNextId());
            this.bundleClasspaths.put(new Long(descriptor.getBundleId()), this.getClasspath(enhancedManifest));
            String patchValue = this.fillPatchData(enhancedManifest);
            if (patchValue != null) {
                this.patchBundles.put(new Long(descriptor.getBundleId()), patchValue);
            }
            this.rememberQualifierTagPresence(descriptor);
            if (this.addBundleDescription(descriptor) && this.addedBundle != null) {
                this.addedBundle.add(descriptor);
            }
        }
        catch (BundleException e) {
            Status status = new Status(2, "org.eclipse.pde.build", 15, NLS.bind((String)Messages.exception_stateAddition, enhancedManifest.get("Bundle-Name")), (Throwable)e);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }

    private void rememberQualifierTagPresence(BundleDescription descriptor) {
        Properties bundleProperties = null;
        bundleProperties = (Properties)descriptor.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            descriptor.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("qualifier", "marker");
    }

    private void mapVersionReplacedBundle(BundleDescription oldBundle, BundleDescription newBundle) {
        Properties bundleProperties = null;
        bundleProperties = (Properties)oldBundle.getUserObject();
        if (bundleProperties == null) {
            bundleProperties = new Properties();
            oldBundle.setUserObject((Object)bundleProperties);
        }
        bundleProperties.setProperty("versionReplacement", String.valueOf(newBundle.getBundleId()));
    }

    private String[] getClasspath(Dictionary manifest) {
        String fullClasspath = (String)manifest.get("Bundle-ClassPath");
        String[] result = new String[]{};
        try {
            if (fullClasspath != null) {
                ManifestElement[] classpathEntries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)fullClasspath);
                result = new String[classpathEntries.length];
                int i = 0;
                while (i < classpathEntries.length) {
                    result[i] = classpathEntries[i].getValue();
                    ++i;
                }
            }
        }
        catch (BundleException bundleException) {}
        return result;
    }

    private String fillPatchData(Dictionary manifest) {
        if (manifest.get("Eclipse-ExtensibleAPI") != null) {
            return "Eclipse-ExtensibleAPI: true";
        }
        if (manifest.get("Eclipse-PatchFragment") != null) {
            return "Eclipse-PatchFragment: true";
        }
        return null;
    }

    private void loadPluginTagFile() {
        this.repositoryVersions = new Properties();
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(String.valueOf(AbstractScriptGenerator.getWorkingDirectory()) + '/' + "pluginVersions.properties"));
            try {
                this.repositoryVersions.load(input);
            }
            finally {
                ((InputStream)input).close();
            }
        }
        catch (IOException iOException) {}
    }

    public boolean addBundle(File bundleLocation) {
        Dictionary manifest = this.loadManifest(bundleLocation);
        if (manifest == null) {
            return false;
        }
        try {
            this.hasQualifier(bundleLocation, manifest);
        }
        catch (BundleException bundleException) {}
        return this.addBundle(manifest, bundleLocation);
    }

    private void updateVersionNumber(Dictionary manifest) {
        String newVersion = null;
        try {
            String symbolicName = (String)manifest.get("Bundle-SymbolicName");
            if (symbolicName == null) {
                return;
            }
            symbolicName = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName)[0].getValue();
            newVersion = QualifierReplacer.replaceQualifierInVersion((String)manifest.get("Bundle-Version"), symbolicName, (String)manifest.get("qualifier"), this.repositoryVersions);
        }
        catch (BundleException bundleException) {}
        if (newVersion != null) {
            manifest.put("Bundle-Version", newVersion);
        }
    }

    private void hasQualifier(File bundleLocation, Dictionary manifest) throws BundleException {
        ManifestElement[] versionInfo = ManifestElement.parseHeader((String)"Bundle-Version", (String)((String)manifest.get("Bundle-Version")));
        if (versionInfo != null && versionInfo[0].getValue().endsWith("qualifier")) {
            manifest.put("qualifier", this.getQualifierPropery(bundleLocation.getAbsolutePath()));
        }
    }

    private String getQualifierPropery(String bundleLocation) {
        String qualifierInfo = null;
        try {
            qualifierInfo = AbstractScriptGenerator.readProperties(bundleLocation, "build.properties", 1).getProperty("qualifier");
        }
        catch (CoreException coreException) {}
        if (qualifierInfo == null) {
            qualifierInfo = "context";
        }
        return qualifierInfo;
    }

    /*
     * Unable to fully structure code
     */
    private Dictionary basicLoadManifest(File bundleLocation) {
        manifestStream = null;
        jarFile = null;
        try {
            if ("jar".equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                manifestStream = new BufferedInputStream(new FileInputStream(new File(bundleLocation, "META-INF/MANIFEST.MF")));
            }
        }
        catch (IOException v0) {}
        if (manifestStream == null) {
            return this.convertPluginManifest(bundleLocation, true);
        }
        result = new Hashtable<K, V>();
        result.putAll(ManifestElement.parseBundleManifest((InputStream)manifestStream, null));
        var6_5 = result;
        try {
            manifestStream.close();
        }
        catch (IOException v1) {}
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException v2) {}
        return var6_5;
        catch (IOException v3) {
            ** try [egrp 4[TRYBLOCK] [8 : 155->156)] { 
lbl31:
            // 2 sources

            while (true) {
                try {
                    manifestStream.close();
                }
                catch (IOException v4) {}
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException v5) {}
                return null;
            }
        }
        catch (BundleException v6) {
            ** continue;
lbl-1000:
            // 3 sources

            {
                catch (Throwable var5_6) {
                    try {
                        manifestStream.close();
                    }
                    catch (IOException v7) {}
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException v8) {}
                    throw var5_6;
                }
            }
        }
    }

    private void enforceSymbolicName(File bundleLocation, Dictionary initialManifest) {
        if (initialManifest.get("Bundle-SymbolicName") != null) {
            return;
        }
        Dictionary generatedManifest = this.convertPluginManifest(bundleLocation, false);
        if (generatedManifest == null) {
            return;
        }
        Enumeration enumeration = generatedManifest.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (initialManifest.get(key) != null) continue;
            initialManifest.put(key, generatedManifest.get(key));
        }
    }

    private void enforceClasspath(Dictionary manifest) {
        String classpath = (String)manifest.get("Bundle-ClassPath");
        if (classpath == null) {
            manifest.put("Bundle-ClassPath", ".");
        }
    }

    private Dictionary loadManifest(File bundleLocation) {
        Dictionary manifest = this.basicLoadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        this.enforceSymbolicName(bundleLocation, manifest);
        this.enforceClasspath(manifest);
        return manifest;
    }

    private Dictionary convertPluginManifest(File bundleLocation, boolean logConversionException) {
        try {
            PluginConverter converter = this.acquirePluginConverter();
            return converter.convertManifest(bundleLocation, false, AbstractScriptGenerator.isBuildingOSGi() ? null : "2.1", false, null);
        }
        catch (PluginConversionException convertException) {
            if (bundleLocation.getName().equals("feature.xml")) {
                return null;
            }
            if (!new File(bundleLocation, "plugin.xml").exists() && !new File(bundleLocation, "fragment.xml").exists()) {
                return null;
            }
            if (logConversionException) {
                Status status = new Status(2, "org.eclipse.pde.build", 0, NLS.bind((String)Messages.exception_errorConverting, (Object)bundleLocation.getAbsolutePath()), (Throwable)convertException);
                BundleHelper.getDefault().getLog().log((IStatus)status);
            }
            return null;
        }
        catch (Exception serviceException) {
            Status status = new Status(2, "org.eclipse.pde.build", 0, NLS.bind((String)Messages.exception_cannotAcquireService, (Object)"Plugin converter"), (Throwable)serviceException);
            BundleHelper.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public void addBundles(Collection bundles) {
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            File bundle = (File)iter.next();
            this.addBundle(bundle);
        }
    }

    public void resolveState() {
        Properties profileProps;
        List configs = AbstractScriptGenerator.getConfigInfos();
        Dictionary[] properties = new Dictionary[configs.size()];
        String systemPackages = null;
        String ee = null;
        if (this.javaProfile == null) {
            this.javaProfile = this.getDefaultJavaProfile();
        }
        if ((profileProps = this.getJavaProfileProperties()) != null) {
            systemPackages = profileProps.getProperty(SYSTEM_PACKAGES);
            ee = profileProps.getProperty("org.osgi.framework.executionenvironment");
        }
        int i = 0;
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            Config aConfig = (Config)iter.next();
            Hashtable<String, Object> prop = new Hashtable<String, Object>();
            if (AbstractScriptGenerator.getPropertyAsBoolean("resolution.devMode")) {
                ((Dictionary)prop).put("osgi.resolverMode", "development");
            }
            String os = aConfig.getOs();
            String ws = aConfig.getWs();
            String arch = aConfig.getArch();
            if (Config.ANY.equalsIgnoreCase(os)) {
                ((Dictionary)prop).put("osgi.os", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.os", os);
            }
            if (Config.ANY.equalsIgnoreCase(ws)) {
                ((Dictionary)prop).put("osgi.ws", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.ws", ws);
            }
            if (Config.ANY.equalsIgnoreCase(arch)) {
                ((Dictionary)prop).put("osgi.arch", CatchAllValue.singleton);
            } else {
                ((Dictionary)prop).put("osgi.arch", arch);
            }
            if (systemPackages != null) {
                ((Dictionary)prop).put(SYSTEM_PACKAGES, systemPackages);
            }
            if (ee != null) {
                ((Dictionary)prop).put("org.osgi.framework.executionenvironment", ee);
            }
            if (this.platformProperties != null) {
                Enumeration e = this.platformProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    ((Dictionary)prop).put(key, this.platformProperties.get(key));
                }
            }
            properties[i] = prop;
            ++i;
        }
        this.state.setPlatformProperties(properties);
        this.state.resolve(false);
    }

    private String getDefaultJavaProfile() {
        if (this.javaProfiles == null) {
            this.setJavaProfiles(this.getOSGiLocation());
        }
        if (this.javaProfiles != null && this.javaProfiles.length > 0) {
            return this.javaProfiles[0];
        }
        return null;
    }

    public State getState() {
        return this.state;
    }

    public BundleDescription[] getDependentBundles(String bundleId, Version version) {
        BundleDescription root = this.state.getBundle(bundleId, version);
        return PDEState.getDependentBundles(root);
    }

    public static BundleDescription[] getImportedBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        ExportPackageDescription[] packages = root.getResolvedImports();
        ArrayList<BundleDescription> resolvedImports = new ArrayList<BundleDescription>(packages.length);
        int i = 0;
        while (i < packages.length) {
            if (!root.getLocation().equals(packages[i].getExporter().getLocation()) && !resolvedImports.contains(packages[i].getExporter())) {
                resolvedImports.add(packages[i].getExporter());
            }
            ++i;
        }
        return resolvedImports.toArray(new BundleDescription[resolvedImports.size()]);
    }

    public static BundleDescription[] getRequiredBundles(BundleDescription root) {
        if (root == null) {
            return new BundleDescription[0];
        }
        return root.getResolvedRequires();
    }

    public BundleDescription getResolvedBundle(String bundleId, String version) {
        return this.getBundle(bundleId, version, true);
    }

    public BundleDescription getBundle(String bundleId, String version, boolean resolved) {
        if ("0.0.0".equals(version) || version == null) {
            BundleDescription bundle = this.getResolvedBundle(bundleId);
            if (bundle == null && !resolved) {
                bundle = this.getState().getBundle(bundleId, null);
            }
            return bundle;
        }
        Version parsedVersion = Version.parseVersion((String)version);
        BundleDescription description = this.getState().getBundle(bundleId, parsedVersion);
        if (description != null && (!resolved || description.isResolved())) {
            return description;
        }
        int qualifierIdx = -1;
        qualifierIdx = parsedVersion.getQualifier().indexOf("qualifier");
        if (qualifierIdx != -1) {
            BundleDescription[] bundles = this.getState().getBundles(bundleId);
            String qualifierPrefix = qualifierIdx > 0 ? parsedVersion.getQualifier().substring(0, qualifierIdx - 1) : "";
            int i = 0;
            while (i < bundles.length) {
                Version bundleVersion = bundles[i].getVersion();
                if (bundleVersion.getMajor() == parsedVersion.getMajor() && bundleVersion.getMinor() == parsedVersion.getMinor() && bundleVersion.getMicro() >= parsedVersion.getMicro() && bundleVersion.getQualifier().compareTo(qualifierPrefix) >= 0) {
                    return bundles[i];
                }
                ++i;
            }
        }
        return null;
    }

    public BundleDescription getResolvedBundle(String bundleId) {
        BundleDescription[] description = this.getState().getBundles(bundleId);
        if (description == null) {
            return null;
        }
        int i = 0;
        while (i < description.length) {
            if (description[i].isResolved()) {
                return description[i];
            }
            ++i;
        }
        return null;
    }

    public static BundleDescription[] getDependentBundles(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    public static BundleDescription[] getDependentBundlesWithFragments(BundleDescription root) {
        BundleDescription[] imported = PDEState.getImportedBundles(root);
        BundleDescription[] importedByFragments = PDEState.getImportedByFragments(root);
        BundleDescription[] required = PDEState.getRequiredBundles(root);
        BundleDescription[] requiredByFragments = PDEState.getRequiredByFragments(root);
        BundleDescription[] dependents = new BundleDescription[imported.length + importedByFragments.length + required.length + requiredByFragments.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(importedByFragments, 0, dependents, imported.length, importedByFragments.length);
        System.arraycopy(required, 0, dependents, imported.length + importedByFragments.length, required.length);
        System.arraycopy(requiredByFragments, 0, dependents, imported.length + importedByFragments.length + required.length, requiredByFragments.length);
        return dependents;
    }

    public static BundleDescription[] getImportedByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                PDEState.merge(importedByFragments, PDEState.getImportedBundles(fragments[i]));
            }
            ++i;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static BundleDescription[] getRequiredByFragments(BundleDescription root) {
        BundleDescription[] fragments = root.getFragments();
        ArrayList importedByFragments = new ArrayList();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved()) {
                PDEState.merge(importedByFragments, PDEState.getRequiredBundles(fragments[i]));
            }
            ++i;
        }
        BundleDescription[] result = new BundleDescription[importedByFragments.size()];
        return importedByFragments.toArray(result);
    }

    public static void merge(List source, BundleDescription[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            if (!source.contains(toAdd[i])) {
                source.add(toAdd[i]);
            }
            ++i;
        }
    }

    public Properties loadPropertyFileIn(Map toMerge, File location) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)toMerge);
        try {
            BufferedInputStream propertyStream = new BufferedInputStream(new FileInputStream(new File(location, "build.properties")));
            try {
                result.load(propertyStream);
            }
            finally {
                ((InputStream)propertyStream).close();
            }
        }
        catch (Exception exception) {}
        return result;
    }

    public HashMap getExtraData() {
        return this.bundleClasspaths;
    }

    public Map getPatchData() {
        return this.patchBundles;
    }

    public List getSortedBundles() {
        if (this.lastSortingDate != this.getState().getTimeStamp()) {
            this.lastSortingDate = this.getState().getTimeStamp();
            BundleDescription[] toSort = this.getState().getResolvedBundles();
            Platform.getPlatformAdmin().getStateHelper().sortBundles(toSort);
            this.sortedBundles = Arrays.asList(toSort);
        }
        return this.sortedBundles;
    }

    public void cleanupOriginalState() {
        if (this.addedBundle == null && this.unqualifiedBundles == null) {
            return;
        }
        Iterator iter = this.addedBundle.iterator();
        while (iter.hasNext()) {
            BundleDescription added = (BundleDescription)iter.next();
            this.state.removeBundle(added);
        }
        iter = this.unqualifiedBundles.iterator();
        while (iter.hasNext()) {
            BundleDescription toAddBack = (BundleDescription)iter.next();
            this.state.removeBundle(toAddBack.getBundleId());
            this.addBundleDescription(toAddBack);
        }
        BundleDescription[] allBundles = this.state.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            allBundles[i].setUserObject(null);
            ++i;
        }
        this.state.resolve();
    }

    private File getOSGiLocation() {
        BundleDescription osgiBundle = this.state.getBundle("org.eclipse.osgi", null);
        if (osgiBundle == null) {
            return null;
        }
        return new File(osgiBundle.getLocation());
    }

    private void setJavaProfiles(File bundleLocation) {
        String[] foundProfiles = null;
        foundProfiles = bundleLocation == null ? this.getRuntimeJavaProfiles() : (bundleLocation.isDirectory() ? this.getDirJavaProfiles(bundleLocation) : this.getJarJavaProfiles(bundleLocation));
        this.javaProfiles = foundProfiles;
    }

    private String[] getRuntimeJavaProfiles() {
        BundleContext context = BundleHelper.getDefault().getBundle().getBundleContext();
        Bundle systemBundle = context.getBundle(0L);
        URL url = systemBundle.getEntry("profile.list");
        if (url != null) {
            try {
                return this.getJavaProfiles(new BufferedInputStream(url.openStream()));
            }
            catch (IOException iOException) {}
        }
        ArrayList<String> results = new ArrayList<String>(6);
        Enumeration entries = systemBundle.findEntries("/", "*.profile", false);
        while (entries.hasMoreElements()) {
            URL entryUrl = (URL)entries.nextElement();
            results.add(entryUrl.getFile().substring(1));
        }
        return this.sortProfiles(results.toArray(new String[results.size()]));
    }

    private String[] getDirJavaProfiles(File bundleLocation) {
        File profileList = new File(bundleLocation, "profile.list");
        if (profileList.exists()) {
            try {
                return this.getJavaProfiles(new BufferedInputStream(new FileInputStream(profileList)));
            }
            catch (IOException iOException) {}
        }
        String[] profiles = bundleLocation.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(PDEState.PROFILE_EXTENSION);
            }
        });
        return this.sortProfiles(profiles);
    }

    /*
     * Unable to fully structure code
     */
    private String[] getJarJavaProfiles(File bundleLocation) {
        block20: {
            block19: {
                zipFile = null;
                results = new ArrayList<String>(6);
                zipFile = new ZipFile(bundleLocation, 1);
                profileList = zipFile.getEntry("profile.list");
                if (profileList == null) ** GOTO lbl-1000
                var8_5 = this.getJavaProfiles(zipFile.getInputStream(profileList));
                if (zipFile == null) break block19;
                try {
                    zipFile.close();
                }
                catch (IOException v0) {}
            }
            return var8_5;
            {
                catch (IOException v1) {
                    try {
                        try lbl-1000:
                        // 2 sources

                        {
                            entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                entryName = entries.nextElement().getName();
                                if (entryName.indexOf(47) >= 0 || !entryName.endsWith(".profile")) continue;
                                results.add(entryName);
                            }
                        }
                        catch (IOException v2) {
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException v3) {}
                            }
                            break block20;
                        }
                    }
                    catch (Throwable var7_8) {
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException v4) {}
                        }
                        throw var7_8;
                    }
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException v5) {}
            }
        }
        return this.sortProfiles(results.toArray(new String[results.size()]));
    }

    private String[] getJavaProfiles(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return ManifestElement.getArrayFromList((String)props.getProperty("java.profiles"), (String)",");
    }

    private String[] sortProfiles(String[] profiles) {
        Arrays.sort(profiles, new Comparator(){

            public int compare(Object profile1, Object profile2) {
                String p1 = (String)profile1;
                String p2 = (String)profile2;
                if (p1.startsWith("JavaSE") && !p2.startsWith("JavaSE")) {
                    return -1;
                }
                if (!p1.startsWith("JavaSE") && p2.startsWith("JavaSE")) {
                    return 1;
                }
                if (p1.startsWith("J2SE") && !p2.startsWith("J2SE")) {
                    return -1;
                }
                if (!p1.startsWith("J2SE") && p2.startsWith("J2SE")) {
                    return 1;
                }
                return -p1.compareTo(p2);
            }
        });
        return profiles;
    }

    /*
     * Loose catch block
     */
    private Properties getJavaProfileProperties() {
        Properties properties;
        ZipFile zipFile;
        InputStream is;
        block28: {
            if (this.javaProfile == null) {
                return null;
            }
            File location = this.getOSGiLocation();
            is = null;
            zipFile = null;
            if (location == null) {
                BundleContext context = BundleHelper.getDefault().getBundle().getBundleContext();
                Bundle systemBundle = context.getBundle(0L);
                URL url = systemBundle.getEntry(this.javaProfile);
                is = new BufferedInputStream(url.openStream());
            } else if (location.isDirectory()) {
                is = new BufferedInputStream(new FileInputStream(new File(location, this.javaProfile)));
            } else {
                zipFile = null;
                try {
                    zipFile = new ZipFile(location, 1);
                    ZipEntry entry = zipFile.getEntry(this.javaProfile);
                    if (entry != null) {
                        is = zipFile.getInputStream(entry);
                    }
                }
                catch (IOException iOException) {}
            }
            Properties profile = new Properties();
            profile.load(is);
            properties = profile;
            if (is == null) break block28;
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
        catch (IOException iOException) {
            block29: {
                try {
                    if (is == null) break block29;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException3) {}
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException iOException4) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException5) {}
            }
        }
        return null;
    }

    private void forceQualifiers() {
        BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
        int i = 0;
        while (i < resolvedBundles.length) {
            if (resolvedBundles[i].getVersion().getQualifier().endsWith("qualifier")) {
                BundleDescription b = resolvedBundles[i];
                this.unqualifiedBundles.add(this.state.removeBundle(b.getBundleId()));
                String newVersion = QualifierReplacer.replaceQualifierInVersion(b.getVersion().toString(), b.getSymbolicName(), this.getQualifierPropery(b.getLocation()), null);
                BundleDescription newBundle = this.state.getFactory().createBundleDescription(b.getBundleId(), b.getSymbolicName(), new Version(newVersion), b.getLocation(), b.getRequiredBundles(), b.getHost(), b.getImportPackages(), b.getExportPackages(), b.isSingleton(), b.attachFragments(), b.dynamicFragments(), b.getPlatformFilter(), b.getExecutionEnvironments(), b.getGenericRequires(), b.getGenericCapabilities());
                this.addBundleDescription(newBundle);
                this.rememberQualifierTagPresence(newBundle);
                this.mapVersionReplacedBundle(b, newBundle);
            }
            ++i;
        }
        this.state.resolve();
    }

    public BundleDescription getVersionReplacement(BundleDescription bundle) {
        Properties props = (Properties)bundle.getUserObject();
        if (props == null) {
            return bundle;
        }
        String idString = props.getProperty("versionReplacement");
        if (idString == null) {
            return bundle;
        }
        try {
            long newId = Long.parseLong(idString);
            BundleDescription newBundle = this.state.getBundle(newId);
            if (newBundle != null) {
                return newBundle;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return bundle;
    }

    public void setPlatformProperties(Dictionary platformProperties) {
        this.platformProperties = platformProperties;
    }
}

