/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeContribution;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class MultiLaunchGroupFilter
extends ViewerFilter {
    private LaunchGroupExtension[] fGroups;

    public MultiLaunchGroupFilter(LaunchGroupExtension[] groups) {
        this.fGroups = groups;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ILaunchConfigurationType type = null;
        ILaunchConfiguration config = null;
        boolean priv = false;
        if (parentElement instanceof ILaunchConfigurationType) {
            type = (ILaunchConfigurationType)parentElement;
        }
        if (element instanceof ILaunchConfigurationType) {
            type = (ILaunchConfigurationType)element;
            boolean bl = priv = !type.isPublic();
        }
        if (element instanceof ILaunchConfiguration) {
            config = (ILaunchConfiguration)element;
            try {
                type = config.getType();
                priv = config.getAttribute("org.eclipse.debug.ui.private", false);
            }
            catch (CoreException coreException) {}
        }
        if (type != null) {
            return !priv && this.equalModes(type) && this.equalCategories(type.getCategory()) && !WorkbenchActivityHelper.filterItem((Object)new LaunchConfigurationTypeContribution(type));
        }
        return false;
    }

    private boolean equalModes(ILaunchConfigurationType type) {
        int i = 0;
        while (i < this.fGroups.length) {
            if (type.supportsMode(this.fGroups[i].getMode())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean equalCategories(String category) {
        String lcat = null;
        int i = 0;
        while (i < this.fGroups.length) {
            lcat = this.fGroups[i].getCategory();
            if (category == null || lcat == null ? category == lcat : category.equals(lcat)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

