/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.pde.internal.build.tasks.Version;

public class IdReplaceTask
extends Task {
    private static final String UTF_8 = "UTF-8";
    private static final String FEATURE_START_TAG = "<feature";
    private static final String ID = "id";
    private static final String VERSION = "version";
    private static final String COMMA = ",";
    private static final String BACKSLASH = "\"";
    private static final String EMPTY = "";
    private static final String PLUGIN_START_TAG = "<plugin";
    private static final String INCLUDES_START_TAG = "<includes";
    private static final String COMMENT_START_TAG = "<!--";
    private static final String COMMENT_END_TAG = "-->";
    private String featureFilePath;
    private Map pluginIds = new HashMap(10);
    private Map featureIds = new HashMap(4);
    private String selfVersion;
    private boolean contentChanged = false;
    private static final String GENERIC_VERSION_NUMBER = "0.0.0";
    private static final String QUALIFIER = "qualifier";

    public void setFeatureFilePath(String path) {
        this.featureFilePath = path;
    }

    public void setSelfVersion(String version) {
        this.selfVersion = version;
    }

    public void setPluginIds(String values) {
        this.pluginIds = new HashMap(10);
        StringTokenizer tokens = new StringTokenizer(values, COMMA);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            String id = EMPTY;
            if (!token.equals(EMPTY)) {
                id = token;
            }
            String version = EMPTY;
            token = tokens.nextToken().trim();
            if (!token.equals(EMPTY)) {
                version = token;
            }
            this.pluginIds.put(id, version);
        }
    }

    public void setFeatureIds(String values) {
        this.featureIds = new HashMap(10);
        StringTokenizer tokens = new StringTokenizer(values, COMMA);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            String id = EMPTY;
            if (!token.equals(EMPTY)) {
                id = token;
            }
            String version = EMPTY;
            token = tokens.nextToken().trim();
            if (!token.equals(EMPTY)) {
                version = token;
            }
            this.featureIds.put(id, version);
        }
    }

    public void execute() {
        StringBuffer buffer = null;
        try {
            buffer = this.readFile(new File(this.featureFilePath));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        int startComment = this.scan(buffer, 0, COMMENT_START_TAG);
        int endComment = startComment > -1 ? this.scan(buffer, startComment, COMMENT_END_TAG) : -1;
        int startFeature = this.scan(buffer, 0, FEATURE_START_TAG);
        while (startComment != -1 && startFeature > startComment && startFeature < endComment) {
            startFeature = this.scan(buffer, endComment, FEATURE_START_TAG);
            startComment = this.scan(buffer, endComment, COMMENT_START_TAG);
            int n = endComment = startComment > -1 ? this.scan(buffer, startComment, COMMENT_END_TAG) : -1;
        }
        if (startFeature == -1) {
            return;
        }
        int endFeature = this.scan(buffer, startFeature, ">");
        if (this.selfVersion != null) {
            boolean versionFound = false;
            while (!versionFound) {
                int startVersionWord = this.scan(buffer, startFeature, VERSION);
                if (startVersionWord == -1 || startVersionWord > endFeature) {
                    return;
                }
                if (!Character.isWhitespace(buffer.charAt(startVersionWord - 1))) {
                    startFeature = startVersionWord + VERSION.length();
                    continue;
                }
                int endVersionWord = startVersionWord + VERSION.length();
                while (Character.isWhitespace(buffer.charAt(endVersionWord)) && endVersionWord < endFeature) {
                    ++endVersionWord;
                }
                if (endVersionWord > endFeature) {
                    System.err.println("Could not find the tag 'version' in the feature header, file: " + this.featureFilePath);
                    return;
                }
                if (buffer.charAt(endVersionWord) != '=') {
                    startFeature = endVersionWord;
                    continue;
                }
                int startVersionId = this.scan(buffer, startVersionWord + 1, BACKSLASH);
                int endVersionId = this.scan(buffer, startVersionId + 1, BACKSLASH);
                buffer.replace(startVersionId + 1, endVersionId, this.selfVersion);
                endFeature += this.selfVersion.length() - (endVersionId - startVersionId);
                this.contentChanged = true;
                versionFound = true;
            }
        }
        int startElement = endFeature;
        int startId = 0;
        while (true) {
            int startPlugin = this.scan(buffer, startElement + 1, PLUGIN_START_TAG);
            int startInclude = this.scan(buffer, startElement + 1, INCLUDES_START_TAG);
            if (startPlugin == -1 && startInclude == -1) break;
            startComment = this.scan(buffer, startElement + 1, COMMENT_START_TAG);
            endComment = startComment > -1 ? this.scan(buffer, startComment, COMMENT_END_TAG) : -1;
            int foundElement = -1;
            boolean isPlugin = false;
            if (startPlugin == -1 || startInclude == -1) {
                foundElement = startPlugin != -1 ? startPlugin : startInclude;
                isPlugin = startPlugin != -1;
            } else if (startPlugin < startInclude) {
                foundElement = startPlugin;
                isPlugin = true;
            } else {
                foundElement = startInclude;
                isPlugin = false;
            }
            if (startComment != -1 && foundElement > startComment && foundElement < endComment) {
                startElement = endComment;
                continue;
            }
            startId = this.scan(buffer, foundElement, ID);
            if (startId == -1) break;
            int startElementId = this.scan(buffer, startId + 1, BACKSLASH);
            int endElementId = this.scan(buffer, startElementId + 1, BACKSLASH);
            char[] elementId = new char[endElementId - startElementId - 1];
            buffer.getChars(startElementId + 1, endElementId, elementId, 0);
            int startVersionWord = this.scan(buffer, endElementId + 1, VERSION);
            int startVersionId = this.scan(buffer, startVersionWord + 1, BACKSLASH);
            int endVersionId = this.scan(buffer, startVersionId + 1, BACKSLASH);
            char[] versionId = new char[endVersionId - startVersionId - 1];
            buffer.getChars(startVersionId + 1, endVersionId, versionId, 0);
            if (!new String(versionId).equals(GENERIC_VERSION_NUMBER) && !new String(versionId).endsWith(QUALIFIER)) {
                startElement = startVersionId;
                continue;
            }
            ++startVersionId;
            String replacementVersion = null;
            Version v = new Version(new String(versionId));
            String lookupKey = String.valueOf(new String(elementId)) + ':' + v.getMajor() + '.' + v.getMinor() + '.' + v.getMicro();
            replacementVersion = isPlugin ? (String)this.pluginIds.get(lookupKey) : (String)this.featureIds.get(lookupKey);
            if (replacementVersion == null) {
                System.err.println("Could not find " + new String(elementId));
            } else {
                buffer.replace(startVersionId, endVersionId, replacementVersion);
                this.contentChanged = true;
            }
            startElement = startVersionId;
        }
        if (!this.contentChanged) {
            return;
        }
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.featureFilePath)), UTF_8);
            w.write(buffer.toString());
            w.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private int scan(StringBuffer buf, int start, String targetName) {
        return this.scan(buf, start, new String[]{targetName});
    }

    private int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            int j = 0;
            while (j < targets.length) {
                String match;
                if (i < buf.length() - targets[j].length() && targets[j].equalsIgnoreCase(match = buf.substring(i, i + targets[j].length()))) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    private StringBuffer readFile(File targetName) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(targetName)), UTF_8);
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return result;
    }
}

