/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.help.AbstractIndexProvider;
import org.eclipse.help.IIndexContribution;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteIndexParser;
import org.eclipse.help.internal.index.IndexContribution;

public class RemoteIndexProvider
extends AbstractIndexProvider {
    private static final String PATH_INDEX = "/index";
    private static final String PARAM_LANG = "lang";

    public RemoteIndexProvider() {
        RemoteHelp.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                RemoteIndexProvider.this.contentChanged();
            }
        });
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IIndexContribution[] getIndexContributions(String locale) {
        if (!RemoteHelp.isEnabled()) return new IIndexContribution[0];
        InputStream in = null;
        URL url = RemoteHelp.getURL("/index?lang=" + locale);
        in = url.openStream();
        RemoteIndexParser parser = new RemoteIndexParser();
        IndexContribution[] indexContributionArray = parser.parse(in);
        if (in == null) return indexContributionArray;
        try {
            in.close();
            return indexContributionArray;
        }
        catch (IOException iOException) {}
        return indexContributionArray;
        catch (IOException e) {
            String msg = "I/O error while trying to contact the remote help server";
            HelpBasePlugin.logError(msg, e);
            if (in == null) return new IIndexContribution[0];
            try {
                in.close();
                return new IIndexContribution[0];
            }
            catch (IOException iOException) {}
            return new IIndexContribution[0];
        }
        catch (Throwable t) {
            String msg = "Internal error while reading index contents from remote server";
            HelpBasePlugin.logError(msg, t);
            if (in == null) return new IIndexContribution[0];
            {
                catch (Throwable throwable) {
                    if (in == null) throw throwable;
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                in.close();
                return new IIndexContribution[0];
            }
            catch (IOException iOException) {}
            return new IIndexContribution[0];
        }
    }
}

