/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import com.ibm.icu.text.MessageFormat;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.datatransfer.BuildFileCreator;
import org.eclipse.ant.internal.ui.datatransfer.DataTransferMessages;
import org.eclipse.ant.internal.ui.datatransfer.ExportUtil;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AntBuildfileExportPage
extends WizardPage {
    private CheckboxTableViewer fTableViewer;
    private List fSelectedJavaProjects = new ArrayList();
    private Button compatibilityCheckbox;
    private Button compilerCheckbox;
    private Text buildfilenameText;
    private Text junitdirText;

    public AntBuildfileExportPage() {
        super("AntBuildfileExportWizardPage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.AntBuildfileExportPage_0);
        this.setDescription(DataTransferMessages.AntBuildfileExportPage_1);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        Label titel = new Label(workArea, 0);
        titel.setText(DataTransferMessages.AntBuildfileExportPage_2);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        Table table = new Table(listComposite, 2848);
        this.fTableViewer = new CheckboxTableViewer(table);
        table.setLayout((Layout)new TableLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        table.setLayoutData((Object)data);
        this.fTableViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof IJavaProject[]) {
                    return (IJavaProject[])element;
                }
                return null;
            }
        });
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    AntBuildfileExportPage.this.fSelectedJavaProjects.add(event.getElement());
                } else {
                    AntBuildfileExportPage.this.fSelectedJavaProjects.remove(event.getElement());
                }
                AntBuildfileExportPage.this.updateEnablement();
            }
        });
        this.initializeProjects();
        this.createSelectionButtons(listComposite);
        this.createCheckboxes(workArea);
        this.createTextFields(workArea);
        this.setControl((Control)workArea);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSelectionButtons(Composite composite) {
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.AntBuildfileExportPage_11);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < AntBuildfileExportPage.this.fTableViewer.getTable().getItemCount()) {
                    AntBuildfileExportPage.this.fSelectedJavaProjects.add(AntBuildfileExportPage.this.fTableViewer.getElementAt(i));
                    ++i;
                }
                AntBuildfileExportPage.this.fTableViewer.setAllChecked(true);
                AntBuildfileExportPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.AntBuildfileExportPage_12);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntBuildfileExportPage.this.fSelectedJavaProjects.clear();
                AntBuildfileExportPage.this.fTableViewer.setAllChecked(false);
                AntBuildfileExportPage.this.updateEnablement();
            }
        });
        this.setButtonLayoutData(deselectAll);
    }

    private void createCheckboxes(Composite composite) {
        this.compatibilityCheckbox = new Button(composite, 32);
        this.compatibilityCheckbox.setSelection(true);
        this.compatibilityCheckbox.setText(DataTransferMessages.AntBuildfileExportPage_13);
        this.compatibilityCheckbox.setToolTipText(DataTransferMessages.AntBuildfileExportPage_14);
        this.compilerCheckbox = new Button(composite, 32);
        this.compilerCheckbox.setSelection(true);
        this.compilerCheckbox.setText(DataTransferMessages.AntBuildfileExportPage_15);
    }

    private void createTextFields(Composite composite) {
        Composite containerGroup = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        containerGroup.setLayout((Layout)layout);
        containerGroup.setLayoutData((Object)new GridData(768));
        Label buildfilenameLabel = new Label(containerGroup, 0);
        buildfilenameLabel.setText(DataTransferMessages.AntBuildfileExportPage_16);
        this.buildfilenameText = new Text(containerGroup, 2052);
        this.buildfilenameText.setText("build.xml");
        GridData data = new GridData(768);
        this.buildfilenameText.setLayoutData((Object)data);
        Label junitdirLabel = new Label(containerGroup, 0);
        junitdirLabel.setText(DataTransferMessages.AntBuildfileExportPage_17);
        this.junitdirText = new Text(containerGroup, 2052);
        this.junitdirText.setText("junit");
        this.junitdirText.setLayoutData((Object)data);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AntBuildfileExportPage.this.updateEnablement();
            }
        };
        this.buildfilenameText.addModifyListener(listener);
        this.junitdirText.addModifyListener(listener);
    }

    private void initializeProjects() {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            javaProjects = new IJavaProject[]{};
        }
        this.fTableViewer.setInput((Object)javaProjects);
        if (this.fSelectedJavaProjects != null) {
            this.fTableViewer.setCheckedElements((Object[])this.fSelectedJavaProjects.toArray(new IJavaProject[this.fSelectedJavaProjects.size()]));
        }
    }

    private void updateEnablement() {
        boolean complete = true;
        if (this.fSelectedJavaProjects.size() == 0) {
            this.setErrorMessage(DataTransferMessages.AntBuildfileExportPage_18);
            complete = false;
        }
        if (this.buildfilenameText.getText().length() == 0) {
            this.setErrorMessage(DataTransferMessages.AntBuildfileExportPage_19);
            complete = false;
        }
        if (this.junitdirText.getText().length() == 0) {
            this.setErrorMessage(DataTransferMessages.AntBuildfileExportPage_20);
            complete = false;
        }
        if (complete) {
            this.setErrorMessage(null);
        }
        this.setPageComplete(complete);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fTableViewer.getTable().setFocus();
        }
    }

    protected void setSelectedProjects(List selectedJavaProjects) {
        this.fSelectedJavaProjects.addAll(selectedJavaProjects);
    }

    public boolean generateBuildfiles() {
        Set projects;
        this.setErrorMessage(null);
        final ArrayList projectNames = new ArrayList();
        try {
            projects = this.getProjects();
        }
        catch (JavaModelException e) {
            AntUIPlugin.log(e);
            this.setErrorMessage(MessageFormat.format((String)DataTransferMessages.AntBuildfileExportPage_10, (Object[])new String[]{e.toString()}));
            return false;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InterruptedException {
                Throwable problem = null;
                try {
                    BuildFileCreator.setOptions(AntBuildfileExportPage.this.buildfilenameText.getText(), AntBuildfileExportPage.this.junitdirText.getText(), AntBuildfileExportPage.this.compatibilityCheckbox.getSelection(), AntBuildfileExportPage.this.compilerCheckbox.getSelection());
                    projectNames.addAll(BuildFileCreator.createBuildFiles(projects, AntBuildfileExportPage.this.getShell(), pm));
                }
                catch (JavaModelException e) {
                    problem = e;
                }
                catch (TransformerConfigurationException e) {
                    problem = e;
                }
                catch (ParserConfigurationException e) {
                    problem = e;
                }
                catch (TransformerException e) {
                    problem = e;
                }
                catch (IOException e) {
                    problem = e;
                }
                catch (CoreException e) {
                    problem = e;
                }
                if (problem != null) {
                    AntUIPlugin.log(problem);
                    AntBuildfileExportPage.this.setErrorMessage(MessageFormat.format((String)DataTransferMessages.AntBuildfileExportPage_10, (Object[])new String[]{problem.toString()}));
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            AntUIPlugin.log(e);
            return false;
        }
        catch (InterruptedException e) {
            AntUIPlugin.log(e);
            return false;
        }
        if (this.getErrorMessage() != null) {
            return false;
        }
        if (projectNames.size() > 0) {
            List cyclicProjects;
            String message = MessageFormat.format((String)(String.valueOf(DataTransferMessages.AntBuildfileExportPage_5) + ExportUtil.NEWLINE), (Object[])new String[]{String.valueOf(ExportUtil.NEWLINE) + ExportUtil.toString(projectNames, ExportUtil.NEWLINE)});
            MessageDialog.openInformation((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_0, (String)message);
            if (!this.compatibilityCheckbox.getSelection()) {
                return true;
            }
            try {
                cyclicProjects = this.getCyclicProjects(projects);
            }
            catch (CoreException e) {
                AntUIPlugin.log(e);
                this.setErrorMessage(MessageFormat.format((String)DataTransferMessages.AntBuildfileExportPage_10, (Object[])new String[]{e.toString()}));
                return false;
            }
            if (cyclicProjects.size() > 0) {
                String warningMessage = MessageFormat.format((String)(String.valueOf(DataTransferMessages.AntBuildfileExportPage_6) + ExportUtil.NEWLINE + ExportUtil.NEWLINE + DataTransferMessages.AntBuildfileExportPage_7 + " " + DataTransferMessages.AntBuildfileExportPage_8), (Object[])new String[]{String.valueOf(ExportUtil.NEWLINE) + ExportUtil.toString(cyclicProjects, ExportUtil.NEWLINE)});
                MessageDialog.openWarning((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_9, (String)warningMessage);
            }
        }
        return true;
    }

    private Set getProjects() throws JavaModelException {
        TreeSet<IJavaProject> projects = new TreeSet<IJavaProject>(ExportUtil.getJavaProjectComparator());
        Iterator javaProjects = this.fSelectedJavaProjects.iterator();
        while (javaProjects.hasNext()) {
            IJavaProject javaProject = (IJavaProject)javaProjects.next();
            projects.addAll(ExportUtil.getClasspathProjectsRecursive(javaProject));
            projects.add(javaProject);
        }
        List confirmOverwrite = this.getConfirmOverwriteSet(projects);
        if (confirmOverwrite.size() > 0) {
            String message = String.valueOf(DataTransferMessages.AntBuildfileExportPage_3) + ExportUtil.NEWLINE + ExportUtil.toString(confirmOverwrite, ExportUtil.NEWLINE);
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)DataTransferMessages.AntBuildfileExportPage_4, (String)message)) {
                return new TreeSet(ExportUtil.getJavaProjectComparator());
            }
        }
        return projects;
    }

    private List getCyclicProjects(Set projects) throws CoreException {
        ArrayList<String> cyclicProjects = new ArrayList<String>();
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IJavaProject javaProject = (IJavaProject)iter.next();
            if (!ExportUtil.hasCyclicDependency(javaProject)) continue;
            cyclicProjects.add(javaProject.getProject().getName());
        }
        return cyclicProjects;
    }

    private List getConfirmOverwriteSet(Set javaProjects) {
        ArrayList<String> result = new ArrayList<String>(javaProjects.size());
        Iterator iter = javaProjects.iterator();
        while (iter.hasNext()) {
            IJavaProject project = (IJavaProject)iter.next();
            String projectRoot = ExportUtil.getProjectRoot(project);
            if (!ExportUtil.existsUserFile(String.valueOf(projectRoot) + '/' + this.buildfilenameText.getText())) continue;
            result.add(project.getProject().getName());
        }
        return result;
    }
}

