/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.internal.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.internal.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.internal.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.internal.beans.JavaBeanObservableList;
import org.eclipse.core.internal.databinding.internal.beans.JavaBeanObservableMap;
import org.eclipse.core.internal.databinding.internal.beans.JavaBeanObservableSet;
import org.eclipse.core.internal.databinding.internal.beans.JavaBeanObservableValue;

public final class BeansObservables {
    public static final boolean DEBUG = true;
    static /* synthetic */ Class class$0;

    public static IObservableValue observeValue(Object bean, String propertyName) {
        return BeansObservables.observeValue(Realm.getDefault(), bean, propertyName);
    }

    public static IObservableValue observeValue(Realm realm, Object bean, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(bean.getClass(), propertyName);
        return new JavaBeanObservableValue(realm, bean, descriptor, null);
    }

    public static IObservableMap observeMap(IObservableSet domain, Class beanClass, String propertyName) {
        PropertyDescriptor descriptor = BeansObservables.getPropertyDescriptor(beanClass, propertyName);
        return new JavaBeanObservableMap(domain, descriptor);
    }

    private static PropertyDescriptor getPropertyDescriptor(Class beanClass, String propertyName) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < propertyDescriptors.length) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            if (descriptor.getName().equals(propertyName)) {
                return descriptor;
            }
            ++i;
        }
        throw new BindingException("Could not find property with name " + propertyName + " in class " + beanClass);
    }

    public static IObservableMap[] observeMaps(IObservableSet domain, Class beanClass, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = BeansObservables.observeMap(domain, beanClass, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static IObservableList observeList(Realm realm, Object bean, String propertyName) {
        return BeansObservables.observeList(realm, bean, propertyName, null);
    }

    public static IObservableList observeList(Realm realm, Object bean, String propertyName, Class elementType) {
        PropertyDescriptor propertyDescriptor = BeansObservables.getPropertyDescriptor(bean.getClass(), propertyName);
        elementType = BeansObservables.getCollectionElementType(elementType, propertyDescriptor);
        return new JavaBeanObservableList(realm, bean, propertyDescriptor, elementType);
    }

    public static IObservableSet observeSet(Realm realm, Object bean, String propertyName) {
        return BeansObservables.observeSet(realm, bean, propertyName, null);
    }

    public static IObservableFactory valueFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeValue(realm, target, propertyName);
            }
        };
    }

    public static IObservableFactory listFactory(final Realm realm, final String propertyName, final Class elementType) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeList(realm, target, propertyName, elementType);
            }
        };
    }

    public static IObservableFactory setFactory(final Realm realm, final String propertyName) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeSet(realm, target, propertyName);
            }
        };
    }

    public static IObservableValue observeDetailValue(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableValue value = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)BeansObservables.valueFactory(realm, propertyName), (Object)propertyType);
        BeanObservableValueDecorator decorator = new BeanObservableValueDecorator(value, master, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableList observeDetailList(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableList observableList = MasterDetailObservables.detailList((IObservableValue)master, (IObservableFactory)BeansObservables.listFactory(realm, propertyName, propertyType), (Object)propertyType);
        BeanObservableListDecorator decorator = new BeanObservableListDecorator(observableList, master, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableSet observeDetailSet(Realm realm, IObservableValue master, String propertyName, Class propertyType) {
        IObservableSet observableSet = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)BeansObservables.setFactory(realm, propertyName, propertyType), (Object)propertyType);
        BeanObservableSetDecorator decorator = new BeanObservableSetDecorator(observableSet, master, BeansObservables.getValueTypePropertyDescriptor(master, propertyName));
        return decorator;
    }

    public static IObservableSet observeSet(Realm realm, Object bean, String propertyName, Class elementType) {
        PropertyDescriptor propertyDescriptor = BeansObservables.getPropertyDescriptor(bean.getClass(), propertyName);
        elementType = BeansObservables.getCollectionElementType(elementType, propertyDescriptor);
        return new JavaBeanObservableSet(realm, bean, propertyDescriptor, elementType);
    }

    public static IObservableFactory setFactory(final Realm realm, final String propertyName, final Class elementType) {
        return new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return BeansObservables.observeSet(realm, target, propertyName, elementType);
            }
        };
    }

    private static Class getCollectionElementType(Class elementType, PropertyDescriptor propertyDescriptor) {
        if (elementType == null) {
            Class<?> clazz;
            Class<?> propertyType = propertyDescriptor.getPropertyType();
            if (propertyType.isArray()) {
                clazz = propertyType.getComponentType();
            } else {
                clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }
            elementType = clazz;
        }
        return elementType;
    }

    private static PropertyDescriptor getValueTypePropertyDescriptor(IObservableValue observable, String propertyName) {
        return observable.getValueType() != null ? BeansObservables.getPropertyDescriptor((Class)observable.getValueType(), propertyName) : null;
    }
}

