/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;

public class ContributionContextTypeRegistry
extends ContextTypeRegistry {
    private static final String TEMPLATES_EXTENSION_POINT = "org.eclipse.ui.editors.templates";
    private static final String CONTEXT_TYPE = "contextType";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String RESOLVER = "resolver";
    private static final String CONTEXT_TYPE_ID = "contextTypeId";
    private static final String DESCRIPTION = "description";
    private static final String TYPE = "type";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void addContextType(String id) {
        Assert.isNotNull((Object)id);
        if (this.getContextType(id) != null) {
            return;
        }
        TemplateContextType type = ContributionContextTypeRegistry.createContextType(id);
        if (type != null) {
            this.addContextType(type);
        }
    }

    public static TemplateContextType createContextType(String id) {
        TemplateContextType type;
        Assert.isNotNull((Object)id);
        IConfigurationElement[] extensions = ContributionContextTypeRegistry.getTemplateExtensions();
        try {
            type = ContributionContextTypeRegistry.createContextType(extensions, id);
            if (type != null) {
                TemplateVariableResolver[] resolvers = ContributionContextTypeRegistry.createResolvers(extensions, id);
                int i = 0;
                while (i < resolvers.length) {
                    type.addResolver(resolvers[i]);
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            EditorsPlugin.log(e);
            type = null;
        }
        return type;
    }

    private static TemplateContextType createContextType(IConfigurationElement[] extensions, String contextTypeId) throws CoreException {
        int i = 0;
        while (i < extensions.length) {
            String id;
            if (extensions[i].getName().equals(CONTEXT_TYPE) && contextTypeId.equals(id = extensions[i].getAttribute(ID))) {
                return ContributionContextTypeRegistry.createContextType(extensions[i]);
            }
            ++i;
        }
        return null;
    }

    private static TemplateVariableResolver[] createResolvers(IConfigurationElement[] extensions, String contextTypeId) {
        ArrayList<TemplateVariableResolver> resolvers = new ArrayList<TemplateVariableResolver>();
        int i = 0;
        while (i < extensions.length) {
            String declaredId;
            if (extensions[i].getName().equals(RESOLVER) && contextTypeId.equals(declaredId = extensions[i].getAttribute(CONTEXT_TYPE_ID))) {
                try {
                    TemplateVariableResolver resolver = ContributionContextTypeRegistry.createResolver(extensions[i]);
                    if (resolver != null) {
                        resolvers.add(resolver);
                    }
                }
                catch (CoreException e) {
                    EditorsPlugin.log(e);
                }
            }
            ++i;
        }
        return resolvers.toArray(new TemplateVariableResolver[resolvers.size()]);
    }

    private static IConfigurationElement[] getTemplateExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATES_EXTENSION_POINT);
    }

    private static TemplateContextType createContextType(IConfigurationElement element) throws CoreException {
        String id = element.getAttribute(ID);
        try {
            TemplateContextType contextType = (TemplateContextType)element.createExecutableExtension(CLASS);
            String name = element.getAttribute(NAME);
            if (name == null) {
                name = id;
            }
            if (contextType.getId() == null) {
                contextType.setId(id);
            }
            if (contextType.getName() == null) {
                contextType.setName(name);
            }
            return contextType;
        }
        catch (ClassCastException e) {
            StringBuffer stringBuffer = new StringBuffer("extension does not implement ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.templates.TemplateContextType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, stringBuffer.append(clazz.getName()).toString(), (Throwable)e));
        }
    }

    private static TemplateVariableResolver createResolver(IConfigurationElement element) throws CoreException {
        try {
            String type = element.getAttribute(TYPE);
            if (type != null) {
                TemplateVariableResolver resolver = (TemplateVariableResolver)element.createExecutableExtension(CLASS);
                resolver.setType(type);
                String desc = element.getAttribute(DESCRIPTION);
                resolver.setDescription(desc == null ? "" : desc);
                return resolver;
            }
        }
        catch (ClassCastException e) {
            StringBuffer stringBuffer = new StringBuffer("extension does not implement ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.text.templates.TemplateVariableResolver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, stringBuffer.append(clazz.getName()).toString(), (Throwable)e));
        }
        return null;
    }
}

