/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyProjectAction;
import org.eclipse.ui.dialogs.ProjectLocationMoveDialog;
import org.eclipse.ui.ide.undo.MoveProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class MoveProjectAction
extends CopyProjectAction {
    private static String MOVE_TOOL_TIP = IDEWorkbenchMessages.MoveProjectAction_toolTip;
    private static String MOVE_TITLE = IDEWorkbenchMessages.MoveProjectAction_text;
    private static String PROBLEMS_TITLE = IDEWorkbenchMessages.MoveProjectAction_dialogTitle;
    public static final String ID = "org.eclipse.ui.MoveProjectAction";

    public MoveProjectAction(Shell shell) {
        super(shell, MOVE_TITLE);
        this.setToolTipText(MOVE_TOOL_TIP);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.move_project_action_context");
    }

    protected String getErrorsTitle() {
        return PROBLEMS_TITLE;
    }

    boolean performMove(final IProject project, final URI newLocation) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                MoveProjectOperation op = new MoveProjectOperation(project, newLocation, IDEWorkbenchMessages.MoveProjectAction_moveTitle);
                op.setModelProviderIds(MoveProjectAction.this.getModelProviderIds());
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(MoveProjectAction.this.shell));
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof CoreException) {
                        MoveProjectAction.this.recordError((CoreException)e.getCause());
                    }
                    IDEWorkbenchPlugin.log(e.getMessage(), e);
                    MoveProjectAction.this.displayError(e.getMessage());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shell).run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "performMove()", e.getTargetException());
            this.displayError(NLS.bind((String)IDEWorkbenchMessages.MoveProjectAction_internalError, (Object)e.getTargetException().getMessage()));
            return false;
        }
        return true;
    }

    protected Object[] queryDestinationParameters(IProject project) {
        ProjectLocationMoveDialog dialog = new ProjectLocationMoveDialog(this.shell, project);
        dialog.setTitle(IDEWorkbenchMessages.MoveProjectAction_moveTitle);
        dialog.open();
        return dialog.getResult();
    }

    public void run() {
        this.errorStatus = null;
        IProject project = (IProject)this.getSelectedResources().get(0);
        Object[] destinationPaths = this.queryDestinationParameters(project);
        if (destinationPaths == null) {
            return;
        }
        URI newLocation = URIUtil.toURI((String)((String)destinationPaths[1]));
        boolean completed = this.performMove(project, newLocation);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shell, (String)PROBLEMS_TITLE, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }
}

