/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.ltk.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusDialog;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RefactoringWizardDialog2
extends Dialog
implements IWizardContainer {
    private RefactoringWizard fWizard;
    private IWizardPage fCurrentPage;
    private IWizardPage fVisiblePage;
    private boolean fMakeNextButtonDefault;
    private PageBook fPageContainer;
    private PageBook fStatusContainer;
    private MessageBox fMessageBox;
    private ProgressMonitorPart fProgressMonitorPart;
    private int fActiveRunningOperations;
    private Cursor fWaitCursor;
    private Cursor fArrowCursor;
    private static final int PREVIEW_ID = 1025;
    private int fPreviewWidth;
    private int fPreviewHeight;
    private IDialogSettings fSettings;
    private boolean fHasAdditionalPages;
    private Rectangle fInitialSize;
    private static final String DIALOG_SETTINGS = "RefactoringWizard.preview";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";

    public RefactoringWizardDialog2(Shell shell, RefactoringWizard wizard) {
        super(shell);
        Assert.isNotNull((Object)((Object)wizard));
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        IDialogSettings settings = wizard.getDialogSettings();
        if (settings == null) {
            settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            wizard.setDialogSettings(settings);
        }
        this.fWizard = wizard;
        this.fWizard.setContainer(this);
        this.fWizard.addPages();
        this.initSize(settings);
        this.fHasAdditionalPages = wizard.getPageCount() > 3;
    }

    private void initSize(IDialogSettings settings) {
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 600);
            this.fSettings.put(HEIGHT, 400);
        }
        this.fPreviewWidth = 600;
        this.fPreviewHeight = 400;
        try {
            this.fPreviewWidth = this.fSettings.getInt(WIDTH);
            this.fPreviewHeight = this.fSettings.getInt(HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void saveSize() {
        if (this.fCurrentPage instanceof PreviewWizardPage) {
            Composite control = this.fCurrentPage.getControl().getParent();
            Point size = control.getSize();
            this.fSettings.put(WIDTH, size.x);
            this.fSettings.put(HEIGHT, size.y);
        }
    }

    public Button getCancelButton() {
        return this.getButton(1);
    }

    public void makeNextButtonDefault() {
        this.fMakeNextButtonDefault = true;
    }

    public void showPage(IWizardPage page) {
        this.fCurrentPage = page;
    }

    public void updateButtons() {
        Button okButton;
        Button backButton;
        Button nextButton;
        boolean previewPage = this.isPreviewPageActive();
        boolean ok = this.fWizard.canFinish();
        boolean canFlip = this.fCurrentPage.canFlipToNextPage();
        Button previewButton = this.getButton(1025);
        Button defaultButton = null;
        if (previewButton != null && !previewButton.isDisposed()) {
            previewButton.setEnabled(!previewPage);
            if (!previewPage) {
                previewButton.setEnabled(canFlip);
            }
            if (previewButton.isEnabled()) {
                defaultButton = previewButton;
            }
        }
        if ((nextButton = this.getButton(15)) != null && !nextButton.isDisposed()) {
            nextButton.setEnabled(!previewPage);
            if (!previewPage) {
                nextButton.setEnabled(canFlip);
            }
            if (nextButton.isEnabled()) {
                defaultButton = nextButton;
            }
        }
        if ((backButton = this.getButton(14)) != null && !backButton.isDisposed()) {
            backButton.setEnabled(!this.isFirstPage());
        }
        if ((okButton = this.getButton(0)) != null && !okButton.isDisposed()) {
            okButton.setEnabled(ok);
            if (ok) {
                defaultButton = okButton;
            }
        }
        if (defaultButton != null) {
            defaultButton.getShell().setDefaultButton(defaultButton);
        }
    }

    public void updateMessage() {
        if (this.fStatusContainer == null || this.fStatusContainer.isDisposed()) {
            return;
        }
        this.fStatusContainer.showPage((Control)this.fMessageBox);
        this.fMessageBox.setMessage(this.fCurrentPage);
    }

    public void updateTitleBar() {
    }

    public void updateWindowTitle() {
        String title = this.fWizard.getWindowTitle();
        if (title == null) {
            title = "";
        }
        this.getShell().setText(title);
    }

    public IWizardPage getCurrentPage() {
        return this.fCurrentPage;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.fProgressMonitorPart == null) {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (Display)this.getShell().getDisplay());
        } else {
            Object state = null;
            if (this.fActiveRunningOperations == 0) {
                state = this.aboutToStart(fork && cancelable);
            }
            ++this.fActiveRunningOperations;
            try {
                ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
            }
            finally {
                --this.fActiveRunningOperations;
                if (state != null) {
                    this.stopped(state);
                }
            }
        }
    }

    private Object aboutToStart(boolean cancelable) {
        Map savedState = null;
        Shell shell = this.getShell();
        if (shell != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            Button cancelButton = this.getButton(1);
            Display d = this.getShell().getDisplay();
            this.fWaitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(d, this.fWaitCursor);
            this.fArrowCursor = new Cursor((Device)d, 0);
            cancelButton.setCursor(this.fArrowCursor);
            boolean hasProgressMonitor = this.fProgressMonitorPart != null;
            savedState = this.saveUIState(hasProgressMonitor && cancelable);
            if (focusControl != null) {
                savedState.put("focus", focusControl);
            }
            if (hasProgressMonitor) {
                this.fProgressMonitorPart.attachToCancelComponent((Control)cancelButton);
                this.fStatusContainer.showPage((Control)this.fProgressMonitorPart);
            }
            this.fStatusContainer.update();
        }
        return savedState;
    }

    private Map saveUIState(boolean keepCancelEnabled) {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>(10);
        this.saveEnableStateAndSet((Control)this.getButton(1025), savedState, "preview", false);
        this.saveEnableStateAndSet((Control)this.getButton(0), savedState, "ok", false);
        this.saveEnableStateAndSet((Control)this.getButton(14), savedState, "back", false);
        this.saveEnableStateAndSet((Control)this.getButton(15), savedState, "next", false);
        this.saveEnableStateAndSet((Control)this.getButton(1), savedState, "cancel", keepCancelEnabled);
        savedState.put("page", ControlEnableState.disable((Control)this.fVisiblePage.getControl()));
        return savedState;
    }

    private void saveEnableStateAndSet(Control w, Map h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, w.getEnabled());
            w.setEnabled(enabled);
        }
    }

    private void setDisplayCursor(Display d, Cursor c) {
        Shell[] shells = d.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    private void stopped(Object savedState) {
        Shell shell = this.getShell();
        if (shell != null) {
            Button cancelButton = this.getButton(1);
            if (this.fProgressMonitorPart != null) {
                this.fProgressMonitorPart.removeFromCancelComponent((Control)cancelButton);
            }
            this.fStatusContainer.showPage((Control)this.fMessageBox);
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.setDisplayCursor(shell.getDisplay(), null);
            cancelButton.setCursor(null);
            this.fWaitCursor.dispose();
            this.fWaitCursor = null;
            this.fArrowCursor.dispose();
            this.fArrowCursor = null;
            Control focusControl = (Control)state.get("focus");
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    private void restoreUIState(Map state) {
        this.restoreEnableState((Control)this.getButton(1025), state, "preview");
        this.restoreEnableState((Control)this.getButton(0), state, "ok");
        this.restoreEnableState((Control)this.getButton(14), state, "back");
        this.restoreEnableState((Control)this.getButton(15), state, "next");
        this.restoreEnableState((Control)this.getButton(1), state, "cancel");
        ControlEnableState pageState = (ControlEnableState)state.get("page");
        pageState.restore();
    }

    private void restoreEnableState(Control w, Map h, String key) {
        Boolean b;
        if (w != null && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    public boolean close() {
        this.fWizard.dispose();
        return super.close();
    }

    protected void cancelPressed() {
        if (this.fActiveRunningOperations == 0 && this.fWizard.performCancel()) {
            super.cancelPressed();
        }
    }

    protected void okPressed() {
        IWizardPage current = this.fCurrentPage;
        this.saveInitialSize();
        if (this.fWizard.performFinish()) {
            this.saveSize();
            super.okPressed();
            return;
        }
        if (this.fCurrentPage == current) {
            return;
        }
        Assert.isTrue((boolean)"ErrorPage".equals(this.fCurrentPage.getName()));
        if (this.fHasAdditionalPages) {
            this.showCurrentPage();
        } else if (this.showErrorDialog((ErrorWizardPage)this.fCurrentPage) && this.fWizard.performFinish()) {
            super.okPressed();
            return;
        }
    }

    private void showCurrentPage() {
        if (this.fCurrentPage.getControl() == null) {
            this.fCurrentPage.createControl((Composite)this.fPageContainer);
        }
        this.resize();
        this.makeVisible(this.fCurrentPage);
        this.updateButtons();
    }

    protected void handleShellCloseEvent() {
        if (this.fActiveRunningOperations == 0 && this.fWizard.performCancel()) {
            super.handleShellCloseEvent();
        }
    }

    private boolean isPreviewPageActive() {
        return "PreviewPage".equals(this.fCurrentPage.getName());
    }

    private void nextOrPreviewPressed() {
        IWizardPage current = this.fCurrentPage;
        this.saveInitialSize();
        this.fCurrentPage = this.fCurrentPage.getNextPage();
        if (current == this.fCurrentPage) {
            return;
        }
        if (!this.fHasAdditionalPages && "ErrorPage".equals(this.fCurrentPage.getName())) {
            if (this.showErrorDialog((ErrorWizardPage)this.fCurrentPage)) {
                this.fCurrentPage = this.fCurrentPage.getNextPage();
            } else {
                return;
            }
        }
        this.showCurrentPage();
    }

    private void saveInitialSize() {
        if (this.isFirstPage()) {
            this.fInitialSize = this.getShell().getBounds();
        }
    }

    private boolean isFirstPage() {
        IWizardPage[] pages = this.fWizard.getPages();
        return this.fCurrentPage.equals(pages[0]);
    }

    private void backPressed() {
        IWizardPage current = this.fCurrentPage;
        this.fCurrentPage = this.fCurrentPage.getPreviousPage();
        if (current == this.fCurrentPage) {
            return;
        }
        this.showCurrentPage();
    }

    private boolean showErrorDialog(ErrorWizardPage page) {
        RefactoringStatusDialog dialog = new RefactoringStatusDialog(this.getShell(), page, this.fWizard.internalShowBackButtonOnStatusDialog(InternalAPI.INSTANCE));
        switch (dialog.open()) {
            case 0: {
                return true;
            }
            case 14: {
                this.fCurrentPage = this.fCurrentPage.getPreviousPage();
                break;
            }
            case 1: {
                this.cancelPressed();
            }
        }
        return false;
    }

    private void resize() {
        int ye;
        if (this.isFirstPage()) {
            this.getShell().setBounds(this.fInitialSize);
            return;
        }
        Control control = this.fPageContainer.getTopPage();
        Point size = control.getSize();
        int dw = Math.max(0, this.fPreviewWidth - size.x);
        int dh = Math.max(0, this.fPreviewHeight - size.y);
        int dx = dw / 2;
        int dy = dh / 2;
        Shell shell = this.getShell();
        Rectangle rect = shell.getBounds();
        Rectangle clientRect = shell.getMonitor().getClientArea();
        rect.x = Math.max(clientRect.x, rect.x - dx);
        rect.y = Math.max(clientRect.y, rect.y - dy);
        rect.width = Math.min(rect.width + dw, clientRect.width);
        rect.height = Math.min(rect.height + dh, clientRect.height);
        int xe = rect.x - clientRect.x + rect.width;
        if (xe > clientRect.width) {
            rect.x -= xe - clientRect.width;
        }
        if ((ye = rect.y - clientRect.y + rect.height) > clientRect.height) {
            rect.y -= ye - clientRect.height;
        }
        shell.setBounds(rect);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String title = this.fWizard.getDefaultPageTitle();
        if (title == null) {
            title = "";
        }
        newShell.setText(title);
        this.fWizard.getRefactoring().setValidationContext((Object)newShell);
    }

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)result);
        this.fPageContainer = new PageBook(result, 0);
        GridData gd = new GridData(1808);
        this.fPageContainer.setLayoutData(gd);
        this.fCurrentPage = this.fWizard.getStartingPage();
        this.dialogArea = this.fPageContainer;
        if (this.fCurrentPage instanceof PreviewWizardPage) {
            gd.widthHint = this.fPreviewWidth;
            gd.heightHint = this.fPreviewHeight;
        }
        this.fStatusContainer = new PageBook(result, 0);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWizard.getMessageLineWidthInChars());
        this.fStatusContainer.setLayoutData(gd);
        if (this.fWizard.needsProgressMonitor()) {
            this.createProgressMonitorPart();
        }
        this.createMessageBox();
        this.fStatusContainer.showPage((Control)this.fMessageBox);
        this.buttonBar = this.createButtonBar(result);
        if (this.fCurrentPage != null) {
            this.fCurrentPage.createControl((Composite)this.fPageContainer);
            this.makeVisible(this.fCurrentPage);
            this.updateMessage();
            this.updateButtons();
        }
        RefactoringWizardDialog2.applyDialogFont((Control)result);
        return result;
    }

    private void createProgressMonitorPart() {
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        pmlayout.marginHeight = 0;
        this.fProgressMonitorPart = new ProgressMonitorPart((Composite)this.fStatusContainer, (Layout)pmlayout);
    }

    private void createMessageBox() {
        this.fMessageBox = new MessageBox(this.fStatusContainer, 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.fHasAdditionalPages) {
            this.createPreviousAndNextButtons(parent);
        } else {
            this.createPreviewButton(parent);
        }
        String OK_LABEL = this.fHasAdditionalPages ? IDialogConstants.FINISH_LABEL : IDialogConstants.OK_LABEL;
        String CANCEL_LABEL = IDialogConstants.CANCEL_LABEL;
        if (this.fWizard.internalIsYesNoStyle(InternalAPI.INSTANCE)) {
            OK_LABEL = IDialogConstants.YES_LABEL;
            CANCEL_LABEL = IDialogConstants.NO_LABEL;
        }
        this.createButton(parent, 0, OK_LABEL, true);
        this.createButton(parent, 1, CANCEL_LABEL, false);
        Button okButton = this.getButton(0);
        okButton.setFocus();
    }

    private void createPreviewButton(Composite parent) {
        if (!(this.fCurrentPage instanceof PreviewWizardPage) && this.fWizard.internalHasPreviewPage(InternalAPI.INSTANCE)) {
            Button preview = this.createButton(parent, 1025, RefactoringUIMessages.RefactoringWizardDialog2_buttons_preview_label, false);
            if (this.fMakeNextButtonDefault) {
                preview.getShell().setDefaultButton(preview);
            }
            preview.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RefactoringWizardDialog2.this.nextOrPreviewPressed();
                }
            });
        }
    }

    private Composite createPreviousAndNextButtons(Composite parent) {
        ((GridLayout)parent.getLayout()).numColumns += 2;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setFont(parent.getFont());
        Button backButton = this.createButton(composite, 14, IDialogConstants.BACK_LABEL, false);
        backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringWizardDialog2.this.backPressed();
            }
        });
        Button nextButton = this.createButton(composite, 15, IDialogConstants.NEXT_LABEL, false);
        nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RefactoringWizardDialog2.this.nextOrPreviewPressed();
            }
        });
        GridData data = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize1 = backButton.computeSize(-1, -1, true);
        Point minSize2 = nextButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint * 2, minSize1.x + minSize2.x);
        data.horizontalAlignment = 0x1000008;
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void makeVisible(IWizardPage page) {
        if (this.fVisiblePage == page) {
            return;
        }
        if (this.fVisiblePage != null) {
            this.fVisiblePage.setVisible(false);
        }
        this.fVisiblePage = page;
        this.fPageContainer.showPage(page.getControl());
        this.fVisiblePage.setVisible(true);
    }

    private static class MessageBox
    extends Composite {
        private Label fImage;
        private Label fText;

        public MessageBox(Composite parent, int style) {
            super(parent, style);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.setLayout((Layout)layout);
            this.fImage = new Label((Composite)this, 0);
            this.fImage.setImage(RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringinfo_obj.gif"));
            Point size = this.fImage.computeSize(-1, -1);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.widthHint = size.x;
            gd.heightHint = size.y;
            this.fImage.setLayoutData((Object)gd);
            this.fImage.setImage(null);
            this.fText = new Label((Composite)this, 64);
            this.fText.setText(" \n ");
            size = this.fText.computeSize(-1, -1);
            gd = new GridData(768);
            gd.heightHint = size.y;
            gd.verticalAlignment = 128;
            this.fText.setLayoutData((Object)gd);
        }

        public void setMessage(IWizardPage page) {
            String msg = page.getErrorMessage();
            int type = 3;
            if (msg == null || msg.length() == 0) {
                msg = page.getMessage();
                type = 0;
                if (msg != null && page instanceof IMessageProvider) {
                    type = ((IMessageProvider)page).getMessageType();
                }
            }
            Image image = null;
            switch (type) {
                case 1: {
                    image = RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringinfo_obj.gif");
                    break;
                }
                case 2: {
                    image = RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringwarning_obj.gif");
                    break;
                }
                case 3: {
                    image = RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringerror_obj.gif");
                }
            }
            if (msg == null) {
                msg = "";
            }
            this.fText.setText(this.escapeAmpersands(msg));
            if (image == null && msg.length() > 0) {
                image = RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringinfo_obj.gif");
            }
            this.fImage.setImage(image);
        }

        private String escapeAmpersands(String message) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < message.length()) {
                char ch = message.charAt(i);
                if (ch == '&') {
                    result.append('&');
                }
                result.append(ch);
                ++i;
            }
            return result.toString();
        }
    }

    private static class PageBook
    extends Composite {
        private StackLayout fLayout = new StackLayout();

        public PageBook(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)this.fLayout);
            this.fLayout.marginWidth = 5;
            this.fLayout.marginHeight = 5;
        }

        public void showPage(Control page) {
            this.fLayout.topControl = page;
            this.layout();
        }

        public Control getTopPage() {
            return this.fLayout.topControl;
        }
    }
}

