/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;

public final class ExpressionVariable
extends ConstraintVariable {
    private final CompilationUnitRange fRange;
    private final String fSource;
    private final IBinding fExpressionBinding;
    private final int fExpressionType;

    public ExpressionVariable(Expression expression) {
        super(expression.resolveTypeBinding());
        this.fSource = expression.toString();
        ICompilationUnit cu = ASTCreator.getCu((ASTNode)expression);
        Assert.isNotNull((Object)cu);
        this.fRange = new CompilationUnitRange(cu, (ASTNode)expression);
        this.fExpressionBinding = ExpressionVariable.resolveBinding(expression);
        this.fExpressionType = expression.getNodeType();
    }

    public String toString() {
        return "[" + this.fSource + "]";
    }

    public CompilationUnitRange getCompilationUnitRange() {
        return this.fRange;
    }

    public int getExpressionType() {
        return this.fExpressionType;
    }

    public IBinding getExpressionBinding() {
        return this.fExpressionBinding;
    }

    public static IBinding resolveBinding(Expression expression) {
        if (expression instanceof Name) {
            return ((Name)expression).resolveBinding();
        }
        if (expression instanceof ParenthesizedExpression) {
            return ExpressionVariable.resolveBinding(((ParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof Assignment) {
            return ExpressionVariable.resolveBinding(((Assignment)expression).getLeftHandSide());
        }
        if (expression instanceof MethodInvocation) {
            return ((MethodInvocation)expression).resolveMethodBinding();
        }
        if (expression instanceof SuperMethodInvocation) {
            return ((SuperMethodInvocation)expression).resolveMethodBinding();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).resolveFieldBinding();
        }
        if (expression instanceof SuperFieldAccess) {
            return ((SuperFieldAccess)expression).resolveFieldBinding();
        }
        if (expression instanceof ConditionalExpression) {
            return ExpressionVariable.resolveBinding(((ConditionalExpression)expression).getThenExpression());
        }
        return null;
    }
}

