/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.osgi.service.prefs.BackingStoreException;
import org.xml.sax.InputSource;

public class FormatterProfileStore
extends ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.jdt.ui.formatterprofiles";
    private final IProfileVersioner fProfileVersioner;

    public FormatterProfileStore(IProfileVersioner profileVersioner) {
        super(PREF_FORMATTER_PROFILES, profileVersioner);
        this.fProfileVersioner = profileVersioner;
    }

    public List readProfiles(IScopeContext scope) throws CoreException {
        List profiles = super.readProfiles(scope);
        if (profiles == null) {
            profiles = this.readOldForCompatibility(scope);
        }
        return profiles;
    }

    private List readOldForCompatibility(IScopeContext instanceScope) {
        block9: {
            List list;
            File file = JavaPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
            if (!file.exists()) {
                return null;
            }
            FileReader reader = new FileReader(file);
            try {
                List res = FormatterProfileStore.readProfilesFromStream(new InputSource(reader));
                if (res != null) {
                    int i = 0;
                    while (i < res.size()) {
                        this.fProfileVersioner.update((ProfileManager.CustomProfile)res.get(i));
                        ++i;
                    }
                    this.writeProfiles(res, instanceScope);
                }
                file.delete();
                list = res;
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    break block9;
                }
                catch (IOException e) {
                    JavaPlugin.log(e);
                }
            }
            reader.close();
            return list;
        }
        return null;
    }

    public static void checkCurrentOptionsVersion() {
        PreferencesAccess access = PreferencesAccess.getOriginalPreferences();
        ProfileVersioner profileVersioner = new ProfileVersioner();
        IScopeContext instanceScope = access.getInstanceScope();
        IEclipsePreferences uiPreferences = instanceScope.getNode("org.eclipse.jdt.ui");
        int version = uiPreferences.getInt("org.eclipse.jdt.ui.formatterprofiles.version", 0);
        if (version >= profileVersioner.getCurrentVersion()) {
            return;
        }
        try {
            FormatterProfileManager manager;
            ArrayList profiles = new FormatterProfileStore(profileVersioner).readProfiles(instanceScope);
            if (profiles == null) {
                profiles = new ArrayList();
            }
            if ((manager = new FormatterProfileManager(profiles, instanceScope, access, profileVersioner)).getSelected() instanceof ProfileManager.CustomProfile) {
                manager.commitChanges(instanceScope);
            }
            uiPreferences.putInt("org.eclipse.jdt.ui.formatterprofiles.version", profileVersioner.getCurrentVersion());
            FormatterProfileStore.savePreferences(instanceScope);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IScopeContext scope = access.getProjectScope(projects[i]);
                if (manager.hasProjectSpecificSettings(scope)) {
                    manager = new FormatterProfileManager(profiles, scope, access, profileVersioner);
                    manager.commitChanges(scope);
                    FormatterProfileStore.savePreferences(scope);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BackingStoreException e) {
            JavaPlugin.log(e);
        }
    }

    private static void savePreferences(IScopeContext context) throws BackingStoreException {
        try {
            context.getNode("org.eclipse.jdt.ui").flush();
        }
        finally {
            context.getNode("org.eclipse.jdt.core").flush();
        }
    }
}

