/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.AbstractVMRunner;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public final class SerialVersionLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final int FAILING_ID = 0;
    private static final char fgSeparator = File.separatorChar;
    private static final String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + fgSeparator, "jre" + fgSeparator + "bin" + fgSeparator};
    private String fErrorMessage = null;
    private long[] fSerialVersionID = new long[0];

    public static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (javaFile.isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public long[] getSerialVersionIDs() {
        return this.fSerialVersionID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)configuration);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask(Messages.format("{0}...", new String[]{configuration.getName()}), 100);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_verifying_launch_attributes);
            String type = this.verifyMainTypeName(configuration);
            IVMInstall install = this.verifyVMInstall(configuration);
            SerialVersionRunner runner = new SerialVersionRunner(install);
            monitor.worked(10);
            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_setting_up);
            String[] environment = DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
            String programArguments = this.getProgramArguments(configuration);
            String vmArguments = this.getVMArguments(configuration);
            ExecutionArguments execArguments = new ExecutionArguments(vmArguments, programArguments);
            Map attributes = this.getVMSpecificAttributesMap(configuration);
            String[] classpath = this.getClasspath(configuration);
            monitor.worked(5);
            VMRunnerConfiguration vmConfiguration = new VMRunnerConfiguration(type, classpath);
            vmConfiguration.setProgramArguments(execArguments.getProgramArgumentsArray());
            vmConfiguration.setEnvironment(environment);
            vmConfiguration.setVMArguments(execArguments.getVMArgumentsArray());
            vmConfiguration.setVMSpecificAttributesMap(attributes);
            vmConfiguration.setBootClassPath(this.getBootpath(configuration));
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_launching_computation);
            monitor.worked(5);
            runner.run(vmConfiguration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
            if (!monitor.isCanceled()) return;
            return;
        }
        finally {
            monitor.done();
        }
    }

    static /* synthetic */ void access$0(SerialVersionLaunchConfigurationDelegate serialVersionLaunchConfigurationDelegate, String string) {
        serialVersionLaunchConfigurationDelegate.fErrorMessage = string;
    }

    static /* synthetic */ void access$1(SerialVersionLaunchConfigurationDelegate serialVersionLaunchConfigurationDelegate, long[] lArray) {
        serialVersionLaunchConfigurationDelegate.fSerialVersionID = lArray;
    }

    static /* synthetic */ long[] access$2(SerialVersionLaunchConfigurationDelegate serialVersionLaunchConfigurationDelegate) {
        return serialVersionLaunchConfigurationDelegate.fSerialVersionID;
    }

    final class SerialVersionRunner
    extends AbstractVMRunner {
        private static final String TEMP_FILE_ENCODING = "utf-8";
        private static final String TEMP_FILE_NAME = "serials.tmp";
        private final IVMInstall fInstall;

        SerialVersionRunner(IVMInstall install) {
            Assert.isNotNull((Object)install);
            this.fInstall = install;
        }

        private String flattenClassPath(String[] path) {
            Assert.isNotNull((Object)path);
            int count = 0;
            if (path.length == 0) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (index < path.length) {
                if (count > 0) {
                    buffer.append(File.pathSeparator);
                }
                buffer.append(path[index]);
                ++count;
                ++index;
            }
            return buffer.toString();
        }

        private String getJavaExecutable(VMRunnerConfiguration configuration) throws CoreException {
            Assert.isNotNull((Object)configuration);
            String command = null;
            Map map = configuration.getVMSpecificAttributesMap();
            if (map != null) {
                command = (String)map.get(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND);
            }
            if (command == null) {
                File executable = SerialVersionLaunchConfigurationDelegate.findJavaExecutable(this.fInstall.getInstallLocation());
                if (executable == null) {
                    this.abort(Messages.format(CorrectionMessages.SerialVersionHashProposal_unable_locate_executable, new String[]{this.fInstall.getName()}), null, 150);
                }
                return executable.getAbsolutePath();
            }
            String location = String.valueOf(this.fInstall.getInstallLocation().getAbsolutePath()) + File.separatorChar;
            File executable = new File(String.valueOf(location) + "bin" + File.separatorChar + command);
            if (executable.exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            if ((executable = new File(String.valueOf(executable.getAbsolutePath()) + ".exe")).exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            executable = new File(String.valueOf(location) + "jre" + File.separatorChar + "bin" + File.separatorChar + command);
            if (executable.exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            if ((executable = new File(String.valueOf(executable.getAbsolutePath()) + ".exe")).exists() && executable.isFile()) {
                return executable.getAbsolutePath();
            }
            this.abort(Messages.format(CorrectionMessages.SerialVersionHashProposal_wrong_executable, new String[]{command, this.fInstall.getName()}), null, 150);
            return null;
        }

        protected String getPluginIdentifier() {
            return JavaPlugin.getPluginId();
        }

        /*
         * Unable to fully structure code
         */
        public void run(VMRunnerConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            block39: {
                Assert.isNotNull((Object)configuration);
                Assert.isNotNull((Object)launch);
                Assert.isNotNull((Object)monitor);
                SerialVersionLaunchConfigurationDelegate.access$0(SerialVersionLaunchConfigurationDelegate.this, null);
                SerialVersionLaunchConfigurationDelegate.access$1(SerialVersionLaunchConfigurationDelegate.this, null);
                monitor.beginTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_launching_vm, 40);
                try {
                    monitor.worked(10);
                    monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_constructing_command_line);
                    arguments = new ArrayList<String>();
                    arguments.add(this.getJavaExecutable(configuration));
                    vmArguments = this.combineVmArgs(configuration, this.fInstall);
                    index = 0;
                    while (index < vmArguments.length) {
                        arguments.add(vmArguments[index]);
                        ++index;
                    }
                    bootClassPath = configuration.getBootClassPath();
                    classPath = configuration.getClassPath();
                    combinedClassPath = null;
                    locations = null;
                    if (bootClassPath == null) {
                        locations = JavaRuntime.getLibraryLocations((IVMInstall)this.fInstall);
                        bootClassPath = new String[locations.length];
                        index = 0;
                        while (index < locations.length) {
                            bootClassPath[index] = locations[index].getSystemLibraryPath().toOSString();
                            ++index;
                        }
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    combinedClassPath = new String[bootClassPath.length + classPath.length];
                    offset = 0;
                    index = 0;
                    while (index < bootClassPath.length) {
                        combinedClassPath[offset] = bootClassPath[index];
                        ++offset;
                        ++index;
                    }
                    index = 0;
                    while (index < classPath.length) {
                        combinedClassPath[offset] = classPath[index];
                        ++offset;
                        ++index;
                    }
                    if (combinedClassPath.length > 0) {
                        arguments.add("-classpath");
                        arguments.add(this.flattenClassPath(combinedClassPath));
                    }
                    arguments.add(configuration.getClassToLaunch());
                    programArguments = configuration.getProgramArguments();
                    index = 0;
                    while (index < programArguments.length) {
                        arguments.add(programArguments[index]);
                        ++index;
                    }
                    commandLine = new String[arguments.size()];
                    arguments.toArray(commandLine);
                    if (monitor.isCanceled()) ** continue;
                    monitor.worked(10);
                    monitor.subTask(CorrectionMessages.SerialVersionLaunchConfigurationDelegate_starting_vm);
                    process = this.exec(commandLine, null);
                    if (process == null) break block39;
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException v0) {}
                    monitor.worked(10);
                    directory = System.getProperty("java.io.tmpdir");
                    if (directory != null && !"".equals(directory)) {
                        separator = System.getProperty("file.separator");
                        if (separator != null && !"".equals(separator)) {
                            file = new File(String.valueOf(directory) + separator + "serials.tmp");
                            if (file.exists()) {
                                block41: {
                                    monitor.worked(40);
                                    file.deleteOnExit();
                                    reader = null;
                                    lines = new ArrayList<String>();
                                    try {
                                        try {
                                            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                                            while (reader.ready()) {
                                                line = reader.readLine();
                                                if (line == null || "".equals(line)) continue;
                                                lines.add(line);
                                            }
                                        }
                                        catch (IOException exception) {
                                            SerialVersionLaunchConfigurationDelegate.access$0(SerialVersionLaunchConfigurationDelegate.this, exception.getLocalizedMessage());
                                            if (reader != null) {
                                                try {
                                                    reader.close();
                                                }
                                                catch (IOException v1) {}
                                            }
                                            break block41;
                                        }
                                    }
                                    catch (Throwable var20_25) {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (IOException v2) {}
                                        }
                                        throw var20_25;
                                    }
                                    if (reader != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (IOException v3) {}
                                    }
                                }
                                SerialVersionLaunchConfigurationDelegate.access$1(SerialVersionLaunchConfigurationDelegate.this, new long[lines.size()]);
                                index = 0;
                                while (index < SerialVersionLaunchConfigurationDelegate.access$2(SerialVersionLaunchConfigurationDelegate.this).length) {
                                    line = (String)lines.get(index);
                                    try {
                                        SerialVersionLaunchConfigurationDelegate.access$2((SerialVersionLaunchConfigurationDelegate)SerialVersionLaunchConfigurationDelegate.this)[index] = Long.parseLong(line);
                                    }
                                    catch (NumberFormatException v4) {
                                        SerialVersionLaunchConfigurationDelegate.access$2((SerialVersionLaunchConfigurationDelegate)SerialVersionLaunchConfigurationDelegate.this)[index] = 0L;
                                    }
                                    ++index;
                                }
                            } else {
                                SerialVersionLaunchConfigurationDelegate.access$0(SerialVersionLaunchConfigurationDelegate.this, CorrectionMessages.SerialVersionLaunchConfigurationDelegate_temp_file_not_exists);
                            }
                        } else {
                            SerialVersionLaunchConfigurationDelegate.access$0(SerialVersionLaunchConfigurationDelegate.this, CorrectionMessages.SerialVersionLaunchConfigurationDelegate_error_getting_separator_property);
                        }
                    } else {
                        SerialVersionLaunchConfigurationDelegate.access$0(SerialVersionLaunchConfigurationDelegate.this, CorrectionMessages.SerialVersionLaunchConfigurationDelegate_error_getting_temp_dir_property);
                    }
                    if (monitor.isCanceled()) {
                        process.destroy();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
    }
}

