/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindAction;
import org.eclipse.jdt.ui.actions.FindWriteReferencesAction;
import org.eclipse.jdt.ui.actions.FindWriteReferencesInHierarchyAction;
import org.eclipse.jdt.ui.actions.FindWriteReferencesInProjectAction;
import org.eclipse.jdt.ui.actions.FindWriteReferencesInWorkingSetAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class WriteReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_writeReferences;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindWriteReferencesAction fFindWriteReferencesAction;
    private FindWriteReferencesInProjectAction fFindWriteReferencesInProjectAction;
    private FindWriteReferencesInHierarchyAction fFindWriteReferencesInHierarchyAction;
    private FindWriteReferencesInWorkingSetAction fFindWriteReferencesInWorkingSetAction;

    public WriteReferencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fFindWriteReferencesAction = new FindWriteReferencesAction(site);
        this.fFindWriteReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fFindWriteReferencesInProjectAction = new FindWriteReferencesInProjectAction(site);
        this.fFindWriteReferencesInProjectAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.project");
        this.fFindWriteReferencesInHierarchyAction = new FindWriteReferencesInHierarchyAction(site);
        this.fFindWriteReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fFindWriteReferencesInWorkingSetAction = new FindWriteReferencesInWorkingSetAction(site);
        this.fFindWriteReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.working.set");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindWriteReferencesAction, provider, selection);
        this.registerAction(this.fFindWriteReferencesInProjectAction, provider, selection);
        this.registerAction(this.fFindWriteReferencesInHierarchyAction, provider, selection);
        this.registerAction(this.fFindWriteReferencesInWorkingSetAction, provider, selection);
    }

    public WriteReferencesSearchGroup(JavaEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindWriteReferencesAction = new FindWriteReferencesAction(this.fEditor);
        this.fFindWriteReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.workspace");
        this.fEditor.setAction("SearchWriteAccessInWorkspace", (IAction)this.fFindWriteReferencesAction);
        this.fFindWriteReferencesInProjectAction = new FindWriteReferencesInProjectAction(this.fEditor);
        this.fFindWriteReferencesInProjectAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.project");
        this.fEditor.setAction("SearchWriteAccessInProject", (IAction)this.fFindWriteReferencesInProjectAction);
        this.fFindWriteReferencesInHierarchyAction = new FindWriteReferencesInHierarchyAction(this.fEditor);
        this.fFindWriteReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.hierarchy");
        this.fEditor.setAction("SearchWriteAccessInHierarchy", (IAction)this.fFindWriteReferencesInHierarchyAction);
        this.fFindWriteReferencesInWorkingSetAction = new FindWriteReferencesInWorkingSetAction(this.fEditor);
        this.fFindWriteReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.write.access.in.working.set");
        this.fEditor.setAction("SearchWriteAccessInWorkingSet", (IAction)this.fFindWriteReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindWriteReferencesInWorkingSetAction(this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindWriteReferencesInWorkingSetAction(this.fSite, workingSets), SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(MENU_TEXT, "group.search");
        this.addAction((IAction)this.fFindWriteReferencesAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindWriteReferencesInProjectAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindWriteReferencesInHierarchyAction, (IMenuManager)javaSearchMM);
        javaSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)javaSearchMM);
        }
        this.addAction((IAction)this.fFindWriteReferencesInWorkingSetAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindWriteReferencesAction, provider);
            this.disposeAction(this.fFindWriteReferencesInProjectAction, provider);
            this.disposeAction(this.fFindWriteReferencesInHierarchyAction, provider);
            this.disposeAction(this.fFindWriteReferencesInWorkingSetAction, provider);
        }
        this.fFindWriteReferencesAction = null;
        this.fFindWriteReferencesInProjectAction = null;
        this.fFindWriteReferencesInHierarchyAction = null;
        this.fFindWriteReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.WriteAccessInWorkspace", (IAction)this.fFindWriteReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.WriteAccessInProject", (IAction)this.fFindWriteReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.WriteAccessInHierarchy", (IAction)this.fFindWriteReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.WriteAccessInWorkingSet", (IAction)this.fFindWriteReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

