/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.BaseCompareAction;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CompareWithPatchAction
extends BaseCompareAction
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;

    protected boolean isEnabled(ISelection selection) {
        return Utilities.getResources(selection).length == 1;
    }

    protected void run(ISelection selection) {
        IResource firstResource = Utilities.getFirstResource(selection);
        boolean isPatch = false;
        if (firstResource instanceof IFile) {
            try {
                isPatch = ApplyPatchOperation.isPatch((IStorage)((IFile)firstResource));
            }
            catch (CoreException e) {
                CompareUIPlugin.log(e);
            }
        }
        final ApplyPatchOperation patchOp = isPatch ? new ApplyPatchOperation(this.targetPart, (IStorage)((IFile)firstResource), null, new CompareConfiguration()) : new ApplyPatchOperation(this.targetPart, firstResource);
        this.targetPart.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                BusyIndicator.showWhile((Display)CompareWithPatchAction.this.targetPart.getSite().getShell().getDisplay(), (Runnable)patchOp);
            }
        });
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

