/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import java.io.InputStream;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DiffImage;
import org.eclipse.compare.internal.patch.HunkResult;
import org.eclipse.compare.internal.patch.PatchCompareEditorInput;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;

public class HunkTypedElement
implements ITypedElement,
IEncodedStreamContentAccessor,
IAdaptable {
    private final HunkResult fHunkResult;
    private final boolean fIsAfterState;
    private final boolean fFullContext;
    static /* synthetic */ Class class$0;

    public HunkTypedElement(HunkResult result, boolean isAfterState, boolean fullContext) {
        this.fHunkResult = result;
        this.fIsAfterState = isAfterState;
        this.fFullContext = fullContext;
    }

    public Image getImage() {
        if (!this.fHunkResult.isOK()) {
            LocalResourceManager imageCache = PatchCompareEditorInput.getImageCache(this.fHunkResult.getDiffResult().getConfiguration());
            return HunkTypedElement.getHunkErrorImage(null, imageCache, false);
        }
        return null;
    }

    public static Image getHunkErrorImage(Image baseImage, LocalResourceManager imageCache, boolean onLeft) {
        DiffImage desc = new DiffImage(baseImage, CompareUIPlugin.getImageDescriptor("ovr16/error_ov.gif"), 22, onLeft);
        Image image = imageCache.createImage((ImageDescriptor)desc);
        return image;
    }

    public boolean isManuallyMerged() {
        return this.getPatcher().isManuallyMerged(this.getHunkResult().getHunk());
    }

    private Patcher getPatcher() {
        return Patcher.getPatcher(this.fHunkResult.getDiffResult().getConfiguration());
    }

    public String getName() {
        return this.fHunkResult.getLabel();
    }

    public String getType() {
        return this.fHunkResult.getDiffResult().getDiff().getTargetPath(this.fHunkResult.getDiffResult().getConfiguration()).getFileExtension();
    }

    public InputStream getContents() throws CoreException {
        String contents = this.fHunkResult.getContents(this.fIsAfterState, this.fFullContext);
        return this.fHunkResult.asInputStream(contents);
    }

    public String getCharset() throws CoreException {
        return this.fHunkResult.getCharset();
    }

    public HunkResult getHunkResult() {
        return this.fHunkResult;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.compare.patch.IHunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.fHunkResult;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

