/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.internal.base.HelpEvaluationContext;

public class EnabledTopicUtils {
    public static boolean isEnabled(ITopic topic) {
        return topic.isEnabled((IEvaluationContext)HelpEvaluationContext.getContext());
    }

    public static boolean isEnabled(IIndexEntry entry) {
        if (UAContentFilter.isFiltered((Object)entry, (IEvaluationContext)HelpEvaluationContext.getContext())) {
            return false;
        }
        ITopic[] topics = entry.getTopics();
        int i = 0;
        while (i < topics.length) {
            if (EnabledTopicUtils.isEnabled(topics[i])) {
                return true;
            }
            ++i;
        }
        IIndexEntry[] subentries = entry.getSubentries();
        int i2 = 0;
        while (i2 < subentries.length) {
            if (EnabledTopicUtils.isEnabled(subentries[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static IIndexEntry[] getEnabled(IIndexEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            if (!EnabledTopicUtils.isEnabled(entries[i])) {
                ArrayList<IIndexEntry> list = new ArrayList<IIndexEntry>(entries.length);
                int j = 0;
                while (j < entries.length) {
                    if (j < i || EnabledTopicUtils.isEnabled(entries[j])) {
                        list.add(entries[j]);
                    }
                    ++j;
                }
                return list.toArray(new IIndexEntry[list.size()]);
            }
            ++i;
        }
        return entries;
    }

    public static ITopic[] getEnabled(ITopic[] topics) {
        int i = 0;
        while (i < topics.length) {
            if (!EnabledTopicUtils.isEnabled(topics[i])) {
                ArrayList<ITopic> list = new ArrayList<ITopic>(topics.length);
                int j = 0;
                while (j < topics.length) {
                    if (j < i || EnabledTopicUtils.isEnabled(topics[j])) {
                        list.add(topics[j]);
                    }
                    ++j;
                }
                return list.toArray(new ITopic[list.size()]);
            }
            ++i;
        }
        return topics;
    }
}

