/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;

final class BooleanScorer
extends Scorer {
    private SubScorer scorers = null;
    private BucketTable bucketTable = new BucketTable(this);
    private int maxCoord = 1;
    private float[] coordFactors = null;
    private int requiredMask = 0;
    private int prohibitedMask = 0;
    private int nextMask = 1;
    private int end;
    private Bucket current;

    BooleanScorer(Similarity similarity) {
        super(similarity);
    }

    final void add(Scorer scorer, boolean required, boolean prohibited) throws IOException {
        int mask = 0;
        if (required || prohibited) {
            if (this.nextMask == 0) {
                throw new IndexOutOfBoundsException("More than 32 required/prohibited clauses in query.");
            }
            mask = this.nextMask;
            this.nextMask <<= 1;
        } else {
            mask = 0;
        }
        if (!prohibited) {
            ++this.maxCoord;
        }
        if (prohibited) {
            this.prohibitedMask |= mask;
        } else if (required) {
            this.requiredMask |= mask;
        }
        this.scorers = new SubScorer(scorer, required, prohibited, this.bucketTable.newCollector(mask), this.scorers);
    }

    private final void computeCoordFactors() {
        this.coordFactors = new float[this.maxCoord];
        for (int i = 0; i < this.maxCoord; ++i) {
            this.coordFactors[i] = this.getSimilarity().coord(i, this.maxCoord - 1);
        }
    }

    public void score(HitCollector hc) throws IOException {
        this.next();
        this.score(hc, Integer.MAX_VALUE);
    }

    protected boolean score(HitCollector hc, int max) throws IOException {
        boolean more;
        if (this.coordFactors == null) {
            this.computeCoordFactors();
        }
        do {
            this.bucketTable.first = null;
            while (this.current != null) {
                if ((this.current.bits & this.prohibitedMask) == 0 && (this.current.bits & this.requiredMask) == this.requiredMask) {
                    if (this.current.doc >= max) {
                        Bucket tmp = this.current;
                        this.current = this.current.next;
                        tmp.next = this.bucketTable.first;
                        this.bucketTable.first = tmp;
                        continue;
                    }
                    hc.collect(this.current.doc, this.current.score * this.coordFactors[this.current.coord]);
                }
                this.current = this.current.next;
            }
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                return true;
            }
            more = false;
            this.end += 2048;
            SubScorer sub = this.scorers;
            while (sub != null) {
                if (!sub.done) {
                    boolean bl = sub.done = !sub.scorer.score(sub.collector, this.end);
                    if (!sub.done) {
                        more = true;
                    }
                }
                sub = sub.next;
            }
            this.current = this.bucketTable.first;
        } while (this.current != null || more);
        return false;
    }

    public int doc() {
        return this.current.doc;
    }

    public boolean next() throws IOException {
        while (true) {
            if (this.bucketTable.first != null) {
                this.current = this.bucketTable.first;
                this.bucketTable.first = this.current.next;
                if ((this.current.bits & this.prohibitedMask) != 0 || (this.current.bits & this.requiredMask) != this.requiredMask) continue;
                return true;
            }
            boolean more = false;
            this.end += 2048;
            SubScorer sub = this.scorers;
            while (sub != null) {
                Scorer scorer = sub.scorer;
                while (!sub.done && scorer.doc() < this.end) {
                    sub.collector.collect(scorer.doc(), scorer.score());
                    sub.done = !scorer.next();
                }
                if (!sub.done) {
                    more = true;
                }
                sub = sub.next;
            }
            if (this.bucketTable.first == null && !more) break;
        }
        return false;
    }

    public float score() {
        if (this.coordFactors == null) {
            this.computeCoordFactors();
        }
        return this.current.score * this.coordFactors[this.current.coord];
    }

    public boolean skipTo(int target) {
        throw new UnsupportedOperationException();
    }

    public Explanation explain(int doc) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("boolean(");
        SubScorer sub = this.scorers;
        while (sub != null) {
            buffer.append(sub.scorer.toString());
            buffer.append(" ");
            sub = sub.next;
        }
        buffer.append(")");
        return buffer.toString();
    }

    static final class Bucket {
        int doc = -1;
        float score;
        int bits;
        int coord;
        Bucket next;

        Bucket() {
        }
    }

    static final class BucketTable {
        public static final int SIZE = 2048;
        public static final int MASK = 2047;
        final Bucket[] buckets = new Bucket[2048];
        Bucket first = null;
        private BooleanScorer scorer;

        public BucketTable(BooleanScorer scorer) {
            this.scorer = scorer;
        }

        public final int size() {
            return 2048;
        }

        public HitCollector newCollector(int mask) {
            return new Collector(mask, this);
        }
    }

    static final class Collector
    extends HitCollector {
        private BucketTable bucketTable;
        private int mask;

        public Collector(int mask, BucketTable bucketTable) {
            this.mask = mask;
            this.bucketTable = bucketTable;
        }

        public final void collect(int doc, float score) {
            BucketTable table = this.bucketTable;
            int i = doc & 0x7FF;
            Bucket bucket = table.buckets[i];
            if (bucket == null) {
                table.buckets[i] = bucket = new Bucket();
            }
            if (bucket.doc != doc) {
                bucket.doc = doc;
                bucket.score = score;
                bucket.bits = this.mask;
                bucket.coord = 1;
                bucket.next = table.first;
                table.first = bucket;
            } else {
                bucket.score += score;
                bucket.bits |= this.mask;
                ++bucket.coord;
            }
        }
    }

    static final class SubScorer {
        public Scorer scorer;
        public boolean done;
        public boolean required = false;
        public boolean prohibited = false;
        public HitCollector collector;
        public SubScorer next;

        public SubScorer(Scorer scorer, boolean required, boolean prohibited, HitCollector collector, SubScorer next) throws IOException {
            this.scorer = scorer;
            this.done = !scorer.next();
            this.required = required;
            this.prohibited = prohibited;
            this.collector = collector;
            this.next = next;
        }
    }
}

