/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;

public final class RAMDirectory
extends Directory {
    Hashtable files = new Hashtable();

    public RAMDirectory() {
    }

    public RAMDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private RAMDirectory(Directory dir, boolean closeDir) throws IOException {
        String[] files = dir.list();
        byte[] buf = new byte[1024];
        for (int i = 0; i < files.length; ++i) {
            int toRead;
            IndexOutput os = this.createOutput(files[i]);
            IndexInput is = dir.openInput(files[i]);
            int len = (int)is.length();
            for (int readCount = 0; readCount < len; readCount += toRead) {
                toRead = readCount + 1024 > len ? len - readCount : 1024;
                is.readBytes(buf, 0, toRead);
                os.writeBytes(buf, toRead);
            }
            is.close();
            os.close();
        }
        if (closeDir) {
            dir.close();
        }
    }

    public RAMDirectory(File dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false), true);
    }

    public RAMDirectory(String dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false), true);
    }

    public final String[] list() {
        String[] result = new String[this.files.size()];
        int i = 0;
        Enumeration names = this.files.keys();
        while (names.hasMoreElements()) {
            result[i++] = (String)names.nextElement();
        }
        return result;
    }

    public final boolean fileExists(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return file != null;
    }

    public final long fileModified(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return file.lastModified;
    }

    public void touchFile(String name) {
        long ts2;
        RAMFile file = (RAMFile)this.files.get(name);
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.lastModified = ts2;
    }

    public final long fileLength(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return file.length;
    }

    public final void deleteFile(String name) {
        this.files.remove(name);
    }

    public final void renameFile(String from, String to) {
        RAMFile file = (RAMFile)this.files.get(from);
        this.files.remove(from);
        this.files.put(to, file);
    }

    public final IndexOutput createOutput(String name) {
        RAMFile file = new RAMFile();
        this.files.put(name, file);
        return new RAMOutputStream(file);
    }

    public final IndexInput openInput(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return new RAMInputStream(file);
    }

    public final Lock makeLock(final String name) {
        return new Lock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean obtain() throws IOException {
                Hashtable hashtable = RAMDirectory.this.files;
                synchronized (hashtable) {
                    if (!RAMDirectory.this.fileExists(name)) {
                        RAMDirectory.this.createOutput(name).close();
                        return true;
                    }
                    return false;
                }
            }

            public void release() {
                RAMDirectory.this.deleteFile(name);
            }

            public boolean isLocked() {
                return RAMDirectory.this.fileExists(name);
            }
        };
    }

    public final void close() {
    }
}

