/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class JavadocLocationManager {
    public static final String JAVADOC_ID = "org.eclipse.pde.core.javadoc";
    private HashMap fLocations;

    public String getJavadocLocation(IPluginModelBase model) {
        File file = new File(model.getInstallLocation());
        if (file.isDirectory()) {
            File doc = new File(file, "doc");
            if (new File(doc, "package-list").exists()) {
                return doc.getAbsolutePath();
            }
        } else if (CoreUtility.jarContainsResource(file, "doc/package-list", false)) {
            return String.valueOf(file.getAbsolutePath()) + "!/doc";
        }
        return this.getEntry(model);
    }

    private String getEntry(IPluginModelBase model) {
        this.initialize();
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            String id;
            HostSpecification host = desc.getHost();
            String string = id = host == null ? desc.getSymbolicName() : host.getName();
            if (id != null) {
                Iterator iter = this.fLocations.keySet().iterator();
                while (iter.hasNext()) {
                    String location = iter.next().toString();
                    Set set = (Set)this.fLocations.get(location);
                    if (!set.contains(id)) continue;
                    return location;
                }
            }
        }
        return null;
    }

    private synchronized void initialize() {
        if (this.fLocations != null) {
            return;
        }
        this.fLocations = new HashMap();
        IPluginModelBase[] models = PluginRegistry.getExternalModels();
        int i = 0;
        while (i < models.length) {
            IPluginExtension[] extensions = models[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                if (JAVADOC_ID.equals(extensions[j].getPoint())) {
                    this.processExtension(extensions[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private void processExtension(IPluginExtension extension) {
        IPluginObject[] children = extension.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().equals("javadoc")) {
                String path;
                IPluginElement javadoc = (IPluginElement)children[i];
                IPluginAttribute attr = javadoc.getAttribute("path");
                String string = path = attr == null ? null : attr.getValue();
                if (path != null) {
                    try {
                        new URL(path);
                        this.processPlugins(path, javadoc.getChildren());
                    }
                    catch (MalformedURLException malformedURLException) {
                        attr = javadoc.getAttribute("archive");
                        boolean archive = attr == null ? false : "true".equals(attr.getValue());
                        Path modelPath = new Path(extension.getModel().getInstallLocation());
                        StringBuffer buffer = new StringBuffer();
                        File file = modelPath.toFile();
                        if (file.exists()) {
                            try {
                                buffer.append(file.toURI().toURL());
                            }
                            catch (MalformedURLException malformedURLException2) {
                                buffer.append("file:/");
                                buffer.append(modelPath.toPortableString());
                            }
                            if (file.isFile()) {
                                buffer.append("!/");
                                archive = true;
                            }
                        }
                        buffer.append(path);
                        if (archive) {
                            buffer.insert(0, "jar:");
                        }
                        this.processPlugins(buffer.toString(), javadoc.getChildren());
                    }
                }
            }
            ++i;
        }
    }

    private void processPlugins(String path, IPluginObject[] plugins) {
        int i = 0;
        while (i < plugins.length) {
            if (plugins[i].getName().equals("plugin")) {
                String id;
                IPluginElement plugin = (IPluginElement)plugins[i];
                IPluginAttribute attr = plugin.getAttribute("id");
                String string = id = attr == null ? null : attr.getValue();
                if (id != null) {
                    HashSet<String> set = (HashSet<String>)this.fLocations.get(path);
                    if (set == null) {
                        set = new HashSet<String>();
                        this.fLocations.put(path, set);
                    }
                    set.add(id);
                }
            }
            ++i;
        }
    }

    public void reset() {
        this.fLocations = null;
    }
}

