/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSIntro;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleCS
extends SimpleCSObject
implements ISimpleCS {
    private ISimpleCSIntro fIntro;
    private String fTitle;
    private ArrayList fItems;
    private static final long serialVersionUID = 1L;

    public SimpleCS(ISimpleCSModel model) {
        super(model, null);
        this.reset();
    }

    public ISimpleCSIntro getIntro() {
        return this.fIntro;
    }

    public ISimpleCSItem[] getItems() {
        return this.fItems.toArray(new ISimpleCSItem[this.fItems.size()]);
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void reset() {
        this.fIntro = null;
        this.fTitle = null;
        this.fItems = new ArrayList();
    }

    public void setIntro(ISimpleCSIntro intro) {
        ISimpleCSIntro old = this.fIntro;
        this.fIntro = intro;
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)intro, old);
        }
    }

    public void setTitle(String title) {
        String old = this.fTitle;
        this.fTitle = title;
        if (this.isEditable()) {
            this.firePropertyChanged("title", old, this.fTitle);
        }
    }

    public void parse(Element element) {
        if (element.getNodeName().equals("cheatsheet")) {
            this.fTitle = element.getAttribute("title").trim();
            NodeList children = element.getChildNodes();
            ISimpleCSModelFactory factory = this.getModel().getFactory();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    String name = child.getNodeName();
                    Element childElement = (Element)child;
                    if (name.equals("intro")) {
                        this.fIntro = factory.createSimpleCSIntro(this);
                        this.fIntro.parse(childElement);
                    } else if (name.equals("item")) {
                        ISimpleCSItem item = factory.createSimpleCSItem(this);
                        this.fItems.add(item);
                        item.parse(childElement);
                    }
                }
                ++i;
            }
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = String.valueOf(indent) + "   ";
        try {
            XMLPrintHandler.printHead(writer, "UTF-8");
            buffer.append("cheatsheet");
            if (this.fTitle != null && this.fTitle.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("title", PDETextHelper.translateWriteText(this.fTitle.trim(), SUBSTITUTE_CHARS)));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            if (this.fIntro != null) {
                this.fIntro.write(newIndent, writer);
            }
            Iterator iterator = this.fItems.iterator();
            while (iterator.hasNext()) {
                ISimpleCSItem item = (ISimpleCSItem)iterator.next();
                item.write(newIndent, writer);
            }
            XMLPrintHandler.printEndElement(writer, "cheatsheet", indent);
        }
        catch (IOException iOException) {}
    }

    public void addItem(ISimpleCSItem item) {
        this.fItems.add(item);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)item, 1);
        }
    }

    public void removeItem(ISimpleCSItem item) {
        this.fItems.remove(item);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)item, 2);
        }
    }

    public int getType() {
        return 0;
    }

    public String getName() {
        return this.fTitle;
    }

    public List getChildren() {
        ArrayList<ISimpleCSIntro> list = new ArrayList<ISimpleCSIntro>();
        if (this.fIntro != null) {
            list.add(this.fIntro);
        }
        if (this.fItems.size() > 0) {
            list.addAll(this.fItems);
        }
        return list;
    }

    public boolean isFirstItem(ISimpleCSItem item) {
        int position = this.fItems.indexOf(item);
        return position == 0;
    }

    public boolean isLastItem(ISimpleCSItem item) {
        int lastPosition;
        int position = this.fItems.indexOf(item);
        return position == (lastPosition = this.fItems.size() - 1);
    }

    public void addItem(int index, ISimpleCSItem item) {
        if (index < 0) {
            return;
        }
        if (index >= this.fItems.size()) {
            this.fItems.add(item);
        } else {
            this.fItems.add(index, item);
        }
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)item, 1);
        }
    }

    public int indexOfItem(ISimpleCSItem item) {
        return this.fItems.indexOf(item);
    }

    public void removeItem(int index) {
        if (index < 0 || index > this.fItems.size() - 1) {
            return;
        }
        ISimpleCSItem item = (ISimpleCSItem)this.fItems.remove(index);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)item, 2);
        }
    }

    public int getItemCount() {
        return this.fItems.size();
    }

    public boolean hasItems() {
        return !this.fItems.isEmpty();
    }

    public ISimpleCSItem getNextSibling(ISimpleCSItem item) {
        int position = this.fItems.indexOf(item);
        int lastIndex = this.fItems.size() - 1;
        if (position == -1 || position == lastIndex) {
            return null;
        }
        return (ISimpleCSItem)this.fItems.get(position + 1);
    }

    public ISimpleCSItem getPreviousSibling(ISimpleCSItem item) {
        int position = this.fItems.indexOf(item);
        if (position == -1 || position == 0) {
            return null;
        }
        return (ISimpleCSItem)this.fItems.get(position - 1);
    }

    public void moveItem(ISimpleCSItem item, int newRelativeIndex) {
        int currentIndex = this.fItems.indexOf(item);
        if (currentIndex == -1) {
            return;
        }
        int newIndex = newRelativeIndex + currentIndex;
        if (newIndex < 0 || newIndex >= this.fItems.size()) {
            return;
        }
        this.fItems.remove(item);
        this.fItems.add(newIndex, item);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)item, 1);
        }
    }
}

