/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSAction;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SimpleCSAction
extends SimpleCSObject
implements ISimpleCSAction {
    private String fClazz;
    private String fPluginId;
    private boolean fConfirm;
    private String fWhen;
    private String fTranslate;
    private ArrayList fParams;
    private static final int F_MAX_PARAMS = 9;
    private static final long serialVersionUID = 1L;

    public SimpleCSAction(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public String getClazz() {
        return this.fClazz;
    }

    public boolean getConfirm() {
        return this.fConfirm;
    }

    public String[] getParams() {
        return this.fParams.toArray(new String[this.fParams.size()]);
    }

    public String getPluginId() {
        return this.fPluginId;
    }

    public void setClazz(String clazz) {
        String old = this.fClazz;
        this.fClazz = clazz;
        if (this.isEditable()) {
            this.firePropertyChanged("class", old, this.fClazz);
        }
    }

    public void setConfirm(boolean confirm) {
        Boolean old = this.fConfirm;
        this.fConfirm = confirm;
        if (this.isEditable()) {
            this.firePropertyChanged("confirm", old, this.fConfirm);
        }
    }

    public void setPluginId(String pluginId) {
        String old = this.fPluginId;
        this.fPluginId = pluginId;
        if (this.isEditable()) {
            this.firePropertyChanged("pluginId", old, this.fPluginId);
        }
    }

    public void parse(Element element) {
        this.fClazz = element.getAttribute("class");
        this.fPluginId = element.getAttribute("pluginId");
        if (element.getAttribute("confirm").compareTo("true") == 0) {
            this.fConfirm = true;
        }
        this.fWhen = element.getAttribute("when");
        Attr translateAttribute = element.getAttributeNode("translate");
        this.fTranslate = translateAttribute == null ? null : translateAttribute.getValue();
        int i = 0;
        while (i < 9) {
            int adjustedIndex = i + 1;
            String parameter = "param" + adjustedIndex;
            String value = element.getAttribute(parameter);
            this.fParams.add(i, value);
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("action");
            if (this.fClazz != null && this.fClazz.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("class", this.fClazz));
            }
            if (this.fPluginId != null && this.fPluginId.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("pluginId", this.fPluginId));
            }
            buffer.append(XMLPrintHandler.wrapAttribute("confirm", new Boolean(this.fConfirm).toString()));
            if (this.fWhen != null && this.fWhen.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("when", this.fWhen));
            }
            if (this.fTranslate != null) {
                buffer.append(XMLPrintHandler.wrapAttribute("translate", this.fTranslate));
            }
            int i = 0;
            while (i < 9) {
                int adjustedIndex = i + 1;
                String parameter = "param" + adjustedIndex;
                String value = (String)this.fParams.get(i);
                if (PDETextHelper.isDefined(value)) {
                    buffer.append(XMLPrintHandler.wrapAttribute(parameter, value));
                }
                ++i;
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            XMLPrintHandler.printEndElement(writer, "action", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fClazz = null;
        this.fPluginId = null;
        this.fConfirm = false;
        this.fWhen = null;
        this.fParams = new ArrayList(9);
        this.fTranslate = null;
    }

    public int getType() {
        return 1;
    }

    public String getWhen() {
        return this.fWhen;
    }

    public String getTranslate() {
        return this.fTranslate;
    }

    public void setWhen(String when) {
        String old = this.fWhen;
        this.fWhen = when;
        if (this.isEditable()) {
            this.firePropertyChanged("when", old, this.fWhen);
        }
    }

    public void setTranslate(String translate) {
        String old = this.fTranslate;
        this.fTranslate = translate;
        if (this.isEditable()) {
            this.firePropertyChanged("translate", old, this.fTranslate);
        }
    }

    public String getName() {
        return "action";
    }

    public List getChildren() {
        return new ArrayList();
    }

    public String getParam(int index) {
        if (index < 1 || index > 9) {
            return null;
        }
        int actualIndex = index - 1;
        return (String)this.fParams.get(actualIndex);
    }

    public void setParam(String param, int index) {
        if (index < 1 || index > 9) {
            return;
        }
        int actualIndex = index - 1;
        String old = (String)this.fParams.get(actualIndex);
        this.fParams.set(actualIndex, param);
        if (this.isEditable()) {
            this.firePropertyChanged("param", old, param);
        }
    }
}

