/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSCommand;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class SimpleCSCommand
extends SimpleCSObject
implements ISimpleCSCommand {
    private String fSerialization;
    private String fReturns;
    private boolean fConfirm;
    private String fWhen;
    private String fTranslate;
    private static final long serialVersionUID = 1L;

    public SimpleCSCommand(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public boolean getConfirm() {
        return this.fConfirm;
    }

    public String getReturns() {
        return this.fReturns;
    }

    public String getSerialization() {
        return this.fSerialization;
    }

    public String getWhen() {
        return this.fWhen;
    }

    public String getTranslate() {
        return this.fTranslate;
    }

    public void setConfirm(boolean confirm) {
        Boolean old = this.fConfirm;
        this.fConfirm = confirm;
        if (this.isEditable()) {
            this.firePropertyChanged("confirm", old, this.fConfirm);
        }
    }

    public void setReturns(String returns) {
        String old = this.fReturns;
        this.fReturns = returns;
        if (this.isEditable()) {
            this.firePropertyChanged("returns", old, this.fReturns);
        }
    }

    public void setSerialization(String serialization) {
        String old = this.fSerialization;
        this.fSerialization = serialization;
        if (this.isEditable()) {
            this.firePropertyChanged("serialization", old, this.fSerialization);
        }
    }

    public void setWhen(String when) {
        String old = this.fWhen;
        this.fWhen = when;
        if (this.isEditable()) {
            this.firePropertyChanged("when", old, this.fWhen);
        }
    }

    public void setTranslate(String translate) {
        String old = this.fTranslate;
        this.fTranslate = translate;
        if (this.isEditable()) {
            this.firePropertyChanged("translate", old, this.fTranslate);
        }
    }

    public void parse(Element element) {
        this.fSerialization = element.getAttribute("serialization");
        this.fReturns = element.getAttribute("returns");
        if (element.getAttribute("confirm").compareTo("true") == 0) {
            this.fConfirm = true;
        }
        this.fWhen = element.getAttribute("when");
        Attr translateAttribute = element.getAttributeNode("translate");
        this.fTranslate = translateAttribute == null ? null : translateAttribute.getValue();
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append("command");
            if (this.fSerialization != null && this.fSerialization.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("serialization", this.fSerialization));
            }
            if (this.fReturns != null && this.fReturns.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("returns", this.fReturns));
            }
            buffer.append(XMLPrintHandler.wrapAttribute("confirm", new Boolean(this.fConfirm).toString()));
            if (this.fWhen != null && this.fWhen.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("when", this.fWhen));
            }
            if (this.fTranslate != null) {
                buffer.append(XMLPrintHandler.wrapAttribute("translate", this.fTranslate));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            XMLPrintHandler.printEndElement(writer, "command", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fSerialization = null;
        this.fReturns = null;
        this.fConfirm = false;
        this.fWhen = null;
        this.fTranslate = null;
    }

    public int getType() {
        return 2;
    }

    public String getName() {
        return "command";
    }

    public List getChildren() {
        return new ArrayList();
    }
}

