/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSDescription;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.util.CheatSheetUtil;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.w3c.dom.Element;

public class SimpleCSDescription
extends SimpleCSObject
implements ISimpleCSDescription {
    private String fContent;
    private static final long serialVersionUID = 1L;

    public SimpleCSDescription(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public String getContent() {
        return this.fContent;
    }

    public void setContent(String content) {
        String old = this.fContent;
        this.fContent = content;
        if (this.isEditable()) {
            this.firePropertyChanged("description", old, this.fContent);
        }
    }

    public void parse(Element element) {
        this.fContent = CheatSheetUtil.parseElementText(element).trim();
    }

    public void reset() {
        this.fContent = null;
    }

    public void write(String indent, PrintWriter writer) {
        String newIndent = String.valueOf(indent) + "   ";
        try {
            XMLPrintHandler.printBeginElement(writer, "description", indent, false);
            if (this.fContent != null && this.fContent.length() > 0) {
                writer.write(String.valueOf(newIndent) + PDETextHelper.translateWriteText(this.fContent.trim(), TAG_EXCEPTIONS, SUBSTITUTE_CHARS) + "\n");
            }
            XMLPrintHandler.printEndElement(writer, "description", indent);
        }
        catch (IOException iOException) {}
    }

    public int getType() {
        return 4;
    }

    public String getName() {
        return this.fContent;
    }

    public List getChildren() {
        return new ArrayList();
    }
}

