/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;

public abstract class SimpleCSObject
extends PlatformObject
implements ISimpleCSObject {
    private transient ISimpleCSModel fModel;
    private transient ISimpleCSObject fParent;
    protected static final HashSet TAG_EXCEPTIONS = new HashSet(3);
    protected static final HashMap SUBSTITUTE_CHARS = new HashMap(5);

    static {
        TAG_EXCEPTIONS.add("b");
        TAG_EXCEPTIONS.add("/b");
        TAG_EXCEPTIONS.add("br/");
        SUBSTITUTE_CHARS.put(new Character('&'), "&amp;");
        SUBSTITUTE_CHARS.put(new Character('<'), "&lt;");
        SUBSTITUTE_CHARS.put(new Character('>'), "&gt;");
        SUBSTITUTE_CHARS.put(new Character('\''), "&apos;");
        SUBSTITUTE_CHARS.put(new Character('\"'), "&quot;");
    }

    public SimpleCSObject(ISimpleCSModel model, ISimpleCSObject parent) {
        this.fModel = model;
        this.fParent = parent;
    }

    public ISimpleCSModel getModel() {
        return this.fModel;
    }

    public ISimpleCS getSimpleCS() {
        return this.fModel.getSimpleCS();
    }

    public void setModel(ISimpleCSModel model) {
        this.fModel = model;
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this.firePropertyChanged(this, property, oldValue, newValue);
    }

    private void firePropertyChanged(ISimpleCSObject object, String property, Object oldValue, Object newValue) {
        if (this.fModel.isEditable()) {
            ISimpleCSModel provider = this.fModel;
            provider.fireModelObjectChanged(object, property, oldValue, newValue);
        }
    }

    protected void fireStructureChanged(ISimpleCSObject child, int changeType) {
        this.fireStructureChanged(new ISimpleCSObject[]{child}, changeType);
    }

    protected void fireStructureChanged(ISimpleCSObject newValue, ISimpleCSObject oldValue) {
        int changeType = -1;
        ISimpleCSObject object = null;
        if (newValue == null) {
            changeType = 2;
            object = oldValue;
        } else {
            changeType = 1;
            object = newValue;
        }
        this.fireStructureChanged(object, changeType);
    }

    private void fireStructureChanged(ISimpleCSObject[] children, int changeType) {
        if (this.fModel.isEditable()) {
            ISimpleCSModel provider = this.fModel;
            provider.fireModelChanged(new ModelChangedEvent(provider, changeType, children, null));
        }
    }

    protected boolean isEditable() {
        return this.fModel.isEditable();
    }

    public ISimpleCSObject getParent() {
        return this.fParent;
    }

    public abstract int getType();

    public abstract String getName();

    public abstract List getChildren();
}

