/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.build.BuildScriptGenerator;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.iproduct.IArgumentsInfo;
import org.eclipse.pde.internal.core.iproduct.IConfigurationFileInfo;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.ILauncherInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.ISplashInfo;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.w3c.dom.Element;

public class ProductExportOperation
extends FeatureExportOperation {
    private String fFeatureLocation;
    private String fRoot;
    private IProduct fProduct;

    public ProductExportOperation(FeatureExportInfo info, IProduct product, String root) {
        super(info);
        this.fProduct = product;
        this.fRoot = root;
    }

    /*
     * Exception decompiling
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getCustomIniFile() {
        File file;
        String path;
        IConfigurationFileInfo info = this.fProduct.getConfigurationFileInfo();
        if (info != null && info.getUse().equals("custom") && (path = this.getExpandedPath(info.getPath())) != null && (file = new File(path)).exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    protected String[] getPaths() {
        String[] paths = super.getPaths();
        String[] all = new String[paths.length + 1];
        all[0] = String.valueOf(this.fFeatureLocation) + File.separator + "feature.xml";
        System.arraycopy(paths, 0, all, 1, paths.length);
        return all;
    }

    private void createBuildPropertiesFile(String featureLocation, String[] config) {
        IJREInfo jreInfo;
        String vm;
        File file = new File(featureLocation);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        boolean hasLaunchers = PDECore.getDefault().getFeatureModelManager().getDeltaPackFeature() != null;
        Properties properties = new Properties();
        properties.put("root", this.getRootFileLocations(hasLaunchers));
        if (!hasLaunchers) {
            properties.put("root.permissions.755", this.getLauncherName());
            if (TargetPlatform.getWS().equals("motif") && TargetPlatform.getOS().equals("linux")) {
                properties.put("root.linux.motif.x86.permissions.755", "libXm.so.2");
            } else if (TargetPlatform.getOS().equals("macosx")) {
                properties.put("root.macosx.carbon.ppc.permissions.755", "${launcherName}.app/Contents/MacOS/${launcherName}");
            }
        }
        String string = vm = (jreInfo = this.fProduct.getJREInfo()) != null ? jreInfo.getJVMLocation(config[0]) : null;
        if (vm != null) {
            properties.put("root." + config[0] + "." + config[1] + "." + config[2] + ".folder.jre", "absolute:" + vm);
            String perms = (String)properties.get("root.permissions.755");
            if (perms != null) {
                StringBuffer buffer = new StringBuffer(perms);
                buffer.append(",");
                buffer.append("jre/bin/java");
                properties.put("root.permissions.755", buffer.toString());
            }
        }
        this.save(new File(file, "build.properties"), properties, "Build Configuration");
    }

    private String getRootFileLocations(boolean hasLaunchers) {
        StringBuffer buffer = new StringBuffer();
        File homeDir = new File(TargetPlatform.getLocation());
        if (!hasLaunchers && homeDir.exists() && homeDir.isDirectory()) {
            buffer.append("absolute:file:");
            buffer.append(new File(homeDir, "startup.jar").getAbsolutePath());
            if (!TargetPlatform.getOS().equals("macosx")) {
                File file = new File(homeDir, "eclipse");
                if (file.exists()) {
                    buffer.append(",absolute:file:");
                    buffer.append(file.getAbsolutePath());
                }
                if ((file = new File(homeDir, "eclipse.exe")).exists()) {
                    buffer.append(",absolute:file:");
                    buffer.append(file.getAbsolutePath());
                }
                if ((file = new File(homeDir, "libXm.so.2")).exists()) {
                    buffer.append(",absolute:file:");
                    buffer.append(file.getAbsolutePath());
                }
            }
        }
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append("/temp/");
        return buffer.toString();
    }

    private void createEclipseProductFile() {
        File dir = new File(this.fFeatureLocation, "temp");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        Properties properties = new Properties();
        IPluginModelBase model = PluginRegistry.findModel(this.getBrandingPlugin());
        if (model != null) {
            properties.put("name", model.getResourceString(this.fProduct.getName()));
        } else {
            properties.put("name", this.fProduct.getName());
        }
        properties.put("id", this.fProduct.getId());
        if (model != null) {
            properties.put("version", model.getPluginBase().getVersion());
        }
        this.save(new File(dir, ".eclipseproduct"), properties, "Eclipse Product File");
    }

    private void createLauncherIniFile(String os) {
        String programArgs = this.getProgramArguments(os);
        String vmArgs = this.getVMArguments(os);
        if (programArgs.length() == 0 && vmArgs.length() == 0) {
            return;
        }
        File dir = new File(this.fFeatureLocation, "temp");
        if ("macosx".equals(os)) {
            dir = new File(dir, "Eclipse.app/Contents/MacOS");
        }
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        String lineDelimiter = "win32".equals(os) ? "\r\n" : "\n";
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(new FileWriter(new File(dir, String.valueOf(this.getLauncherName()) + ".ini")));
                ExecutionArguments args = new ExecutionArguments(vmArgs, programArgs);
                String[] array = args.getProgramArgumentsArray();
                int i = 0;
                while (i < array.length) {
                    writer.print(array[i]);
                    writer.print(lineDelimiter);
                    ++i;
                }
                array = args.getVMArgumentsArray();
                if (array.length > 0) {
                    writer.print("-vmargs");
                    writer.print(lineDelimiter);
                    i = 0;
                    while (i < array.length) {
                        writer.print(array[i]);
                        writer.print(lineDelimiter);
                        ++i;
                    }
                }
            }
            catch (IOException iOException) {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getProgramArguments(String os) {
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        return info != null ? CoreUtility.normalize(info.getCompleteProgramArguments(os)) : "";
    }

    private String getVMArguments(String os) {
        IArgumentsInfo info = this.fProduct.getLauncherArguments();
        return info != null ? CoreUtility.normalize(info.getCompleteVMArguments(os)) : "";
    }

    private void createConfigIniFile(String[] config) {
        File dir = new File(this.fFeatureLocation, "temp/configuration");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        File custom = this.getCustomIniFile();
        if (custom != null) {
            block28: {
                String path = this.getExpandedPath(this.fProduct.getConfigurationFileInfo().getPath());
                BufferedReader in = null;
                try {
                    try {
                        String line;
                        in = new BufferedReader(new FileReader(path));
                        writer = new PrintWriter(new FileWriter(new File(dir, "config.ini")));
                        while ((line = in.readLine()) != null) {
                            writer.println(line);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (writer != null) {
                                writer.close();
                            }
                            break block28;
                        }
                        catch (IOException iOException2) {}
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return;
        }
        try {
            try {
                writer = new PrintWriter(new FileWriter(new File(dir, "config.ini")));
                String location = this.getSplashLocation(config[0], config[1], config[2]);
                writer.println("#Product Runtime Configuration File");
                writer.println();
                if (location != null) {
                    writer.println("osgi.splashPath=" + location);
                }
                writer.println("eclipse.product=" + this.fProduct.getId());
                writer.println("osgi.bundles=" + this.getPluginList(config, TargetPlatform.getBundleList()));
                writer.println("osgi.bundles.defaultStartLevel=4");
            }
            catch (IOException iOException) {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String getSplashLocation(String os, String ws, String arch) {
        ISplashInfo info = this.fProduct.getSplashInfo();
        String plugin = null;
        if (info != null) {
            plugin = info.getLocation();
        }
        if (plugin == null || plugin.trim().length() == 0) {
            plugin = this.getBrandingPlugin();
        }
        if (plugin == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("platform:/base/plugins/");
        buffer.append(plugin.trim());
        State state = this.getState(os, ws, arch);
        BundleDescription bundle = state.getBundle(plugin, null);
        if (bundle != null) {
            BundleDescription[] fragments = bundle.getFragments();
            int i = 0;
            while (i < fragments.length) {
                String id = fragments[i].getSymbolicName();
                if (this.fProduct.containsPlugin(id)) {
                    buffer.append(",platform:/base/plugins/");
                    buffer.append(id);
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    private String getBrandingPlugin() {
        int dot = this.fProduct.getId().lastIndexOf(46);
        return dot != -1 ? this.fProduct.getId().substring(0, dot) : null;
    }

    private String getPluginList(String[] config, String bundleList) {
        if (this.fProduct.useFeatures()) {
            return bundleList;
        }
        StringBuffer buffer = new StringBuffer();
        HashSet<String> initialBundleSet = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(bundleList, ",");
        while (tokenizer.hasMoreTokens()) {
            String id;
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String string = id = index != -1 ? token.substring(0, index) : token;
            if (!this.fProduct.containsPlugin(id)) continue;
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(id);
            if (index != -1 && index < token.length() - 1) {
                buffer.append(token.substring(index));
            }
            initialBundleSet.add(id);
        }
        if (!this.fProduct.containsPlugin("org.eclipse.update.configurator")) {
            initialBundleSet.add("org.eclipse.osgi");
            Hashtable<String, String> environment = new Hashtable<String, String>(4);
            ((Dictionary)environment).put("osgi.os", config[0]);
            ((Dictionary)environment).put("osgi.ws", config[1]);
            ((Dictionary)environment).put("osgi.arch", config[2]);
            ((Dictionary)environment).put("osgi.nl", config[3]);
            BundleContext context = PDECore.getDefault().getBundleContext();
            int i = 0;
            while (i < this.fInfo.items.length) {
                BundleDescription bundle = (BundleDescription)this.fInfo.items[i];
                String filterSpec = bundle.getPlatformFilter();
                try {
                    String id;
                    if ((filterSpec == null || context.createFilter(filterSpec).match(environment)) && !initialBundleSet.contains(id = ((BundleDescription)this.fInfo.items[i]).getSymbolicName())) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                        }
                        buffer.append(id);
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
                ++i;
            }
        }
        return buffer.toString();
    }

    protected HashMap createAntBuildProperties(String os, String ws, String arch) {
        HashMap properties = super.createAntBuildProperties(os, ws, arch);
        properties.put("launcherName", this.getLauncherName());
        ILauncherInfo info = this.fProduct.getLauncherInfo();
        if (info != null) {
            String images = null;
            if (os.equals("win32")) {
                images = this.getWin32Images(info);
            } else if (os.equals("solaris")) {
                images = this.getSolarisImages(info);
            } else if (os.equals("linux")) {
                images = this.getExpandedPath(info.getIconPath("linuxIcon"));
            } else if (os.equals("macosx")) {
                images = this.getExpandedPath(info.getIconPath("macosxIcon"));
            }
            if (images != null && images.length() > 0) {
                properties.put("launcherIcons", images);
            }
        }
        this.fAntBuildProperties.put("collectingFolder", this.fRoot);
        this.fAntBuildProperties.put("archivePrefix", this.fRoot);
        return properties;
    }

    private String getLauncherName() {
        String name;
        ILauncherInfo info = this.fProduct.getLauncherInfo();
        if (info != null && (name = info.getLauncherName()) != null && name.length() > 0) {
            if ((name = name.trim()).endsWith(".exe")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
        return "eclipse";
    }

    private String getWin32Images(ILauncherInfo info) {
        StringBuffer buffer = new StringBuffer();
        if (info.usesWinIcoFile()) {
            this.append(buffer, info.getIconPath("icoFile"));
        } else {
            this.append(buffer, info.getIconPath("winSmallLow"));
            this.append(buffer, info.getIconPath("winSmallHigh"));
            this.append(buffer, info.getIconPath("winMediumHigh"));
            this.append(buffer, info.getIconPath("winMediumLow"));
            this.append(buffer, info.getIconPath("winLargeHigh"));
            this.append(buffer, info.getIconPath("winLargeLow"));
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private String getSolarisImages(ILauncherInfo info) {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer, info.getIconPath("solarisLarge"));
        this.append(buffer, info.getIconPath("solarisMedium"));
        this.append(buffer, info.getIconPath("solarisSmall"));
        this.append(buffer, info.getIconPath("solarisTiny"));
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private void append(StringBuffer buffer, String path) {
        if ((path = this.getExpandedPath(path)) != null) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(path);
        }
    }

    private String getExpandedPath(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        IResource resource = PDECore.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (resource != null) {
            IPath fullPath = resource.getLocation();
            return fullPath == null ? null : fullPath.toOSString();
        }
        return null;
    }

    private void save(File file, Properties properties, String header) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            properties.store(stream, header);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    protected void setupGenerator(BuildScriptGenerator generator, String featureID, String versionId, String os, String ws, String arch, String featureLocation) throws CoreException {
        super.setupGenerator(generator, featureID, versionId, os, ws, arch, featureLocation);
        if (this.fProduct != null) {
            generator.setProduct(this.fProduct.getModel().getInstallLocation());
        }
    }

    /*
     * Exception decompiling
     */
    private void createMacScript(String[] config, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setAdditionalAttributes(Element plugin, BundleDescription bundle) {
        HostSpecification host = bundle.getHost();
        boolean unpack = host != null && host.getName().equals("org.eclipse.equinox.launcher") ? true : CoreUtility.guessUnpack(bundle);
        plugin.setAttribute("unpack", Boolean.toString(unpack));
    }
}

