/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.plugin;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.IDocumentNode;
import org.eclipse.pde.internal.core.text.plugin.PluginObjectNode;

public class PluginAttribute
extends PluginObjectNode
implements IPluginAttribute,
IDocumentAttribute {
    private static final long serialVersionUID = 1L;
    private transient IDocumentNode fEnclosingElement;
    private transient int fNameOffset = -1;
    private transient int fNameLength = -1;
    private transient int fValueOffset = -1;
    private transient int fValueLength = -1;
    private String fValue;

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) throws CoreException {
        this.fValue = value;
    }

    public void setEnclosingElement(IDocumentNode node) {
        this.fEnclosingElement = node;
    }

    public IDocumentNode getEnclosingElement() {
        return this.fEnclosingElement;
    }

    public void setNameOffset(int offset) {
        this.fNameOffset = offset;
    }

    public int getNameOffset() {
        return this.fNameOffset;
    }

    public void setNameLength(int length) {
        this.fNameLength = length;
    }

    public int getNameLength() {
        return this.fNameLength;
    }

    public void setValueOffset(int offset) {
        this.fValueOffset = offset;
    }

    public int getValueOffset() {
        return this.fValueOffset;
    }

    public void setValueLength(int length) {
        this.fValueLength = length;
    }

    public int getValueLength() {
        return this.fValueLength;
    }

    public String getAttributeName() {
        return this.getName();
    }

    public String getAttributeValue() {
        return this.getValue();
    }

    public String write() {
        return String.valueOf(this.getName()) + "=\"" + this.getWritableString(this.getValue()) + "\"";
    }

    public String getWritableString(String source) {
        return super.getWritableString(source).replaceAll("\\r", "&#x0D;").replaceAll("\\n", "&#x0A;");
    }

    public void setAttributeName(String name) throws CoreException {
        this.setName(name);
    }

    public void setAttributeValue(String value) throws CoreException {
        this.setValue(value);
    }

    public void reconnect(ISharedPluginModel model, ISchema schema, IDocumentNode parent) {
        super.reconnect(model, schema, parent);
        this.fEnclosingElement = parent;
        this.fNameLength = -1;
        this.fNameOffset = -1;
        this.fValueLength = -1;
        this.fValueOffset = -1;
    }

    public void write(String indent, PrintWriter writer) {
        writer.write(this.write());
    }
}

