/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.brickblaster.beep;

import java.nio.ByteOrder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class BeepSoundSystem {
    public static final byte TYPE_SQUARE = 0;
    public static final byte TYPE_SINE = 1;
    public static final byte TYPE_NOISE = 2;
    public static final byte TYPE_GRATE = 4;
    public static final float SAMPLE_RATE = 14000.0f;
    public static final int SAMPLE_COUNT = (int)Math.ceil(14.0);
    private static BeepSoundSystem instance = null;
    private boolean running = true;
    private final Channel[] channels;

    public BeepSoundSystem(int channels) {
        this.channels = new Channel[channels];
        int i = 0;
        while (i < channels) {
            this.channels[i] = new Channel();
            this.channels[i].init();
            ++i;
        }
        instance = this;
    }

    public static BeepSoundSystem getLastInstance() {
        return instance;
    }

    public void destroy() {
        this.running = false;
        int i = 0;
        while (i < this.channels.length) {
            this.channels[i].destroy();
            ++i;
        }
    }

    public void note(int hz, int msecs, double vol, int channel) {
        this.channels[channel].note(hz, msecs, (float)vol, (byte)1);
    }

    public void note(int hz, int msecs, double vol, int channel, byte type) {
        this.channels[channel].note(hz, msecs, (float)vol, type);
    }

    private class Channel
    implements Runnable {
        private BlockingQueue<Note> noteQueue = null;
        private SourceDataLine sdl = null;
        private Thread parentThread;

        private Channel() {
        }

        public void init() {
            if (this.sdl == null) {
                try {
                    this.noteQueue = new LinkedBlockingQueue<Note>();
                    AudioFormat af = new AudioFormat(14000.0f, 8, 1, true, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
                    this.sdl = AudioSystem.getSourceDataLine(af);
                    this.sdl.open(af);
                    this.sdl.start();
                    this.parentThread = new Thread(this);
                    this.parentThread.start();
                }
                catch (LineUnavailableException ex) {
                    this.noteQueue = null;
                    ex.printStackTrace();
                }
            }
        }

        public void destroy() {
            if (this.parentThread != null) {
                this.parentThread.interrupt();
            }
            this.noteQueue = null;
            if (this.sdl != null) {
                this.sdl.drain();
                this.sdl.stop();
                this.sdl.close();
            }
        }

        public void note(int hz, int msecs, float vol, byte type) {
            if (this.noteQueue != null) {
                this.noteQueue.add(new Note(hz, msecs, vol, type));
            }
        }

        private void sine(int hz, int msecs, float vol) throws LineUnavailableException {
            if (this.sdl != null) {
                byte[] buf = new byte[1];
                int i = 0;
                while (i < msecs * SAMPLE_COUNT) {
                    float angle = (float)i / (14000.0f / (float)hz) * 2.0f * 3.14159f;
                    buf[0] = (byte)(Math.sin(angle) * 127.0 * (double)vol);
                    this.sdl.write(buf, 0, 1);
                    ++i;
                }
            }
        }

        private void square(int hz, int msecs, float vol) throws LineUnavailableException {
            if (this.sdl != null) {
                byte[] buf = new byte[1];
                int i = 0;
                while (i < msecs * SAMPLE_COUNT) {
                    float angle = (float)i / (14000.0f / (float)hz) * 2.0f * 3.14159f;
                    buf[0] = (byte)(Math.signum(Math.sin(angle)) * 127.0 * (double)vol);
                    this.sdl.write(buf, 0, 1);
                    ++i;
                }
            }
        }

        byte reverse(int b) {
            b = (b & 0xF0) >> 4 | (b & 0xF) << 4;
            b = (b & 0xCC) >> 2 | (b & 0x33) << 2;
            b = (b & 0xAA) >> 1 | (b & 0x55) << 1;
            return (byte)b;
        }

        private void grate(int hz, int msecs, float vol) throws LineUnavailableException {
            if (this.sdl != null) {
                byte[] buf = new byte[1];
                int i = 0;
                while (i < msecs * SAMPLE_COUNT) {
                    float angle = (float)i / (14000.0f / (float)hz) * 2.0f * 3.14159f;
                    buf[0] = this.reverse((byte)(Math.sin(angle) * 127.0 * (double)vol));
                    this.sdl.write(buf, 0, 1);
                    ++i;
                }
            }
        }

        private void noise(int hz, int msecs, float vol) throws LineUnavailableException {
            try {
                Thread.sleep(msecs);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void run() {
            while (BeepSoundSystem.this.running) {
                try {
                    Note note = this.noteQueue.take();
                    if (note == null) continue;
                    try {
                        switch (note.type) {
                            case 0: {
                                this.square(note.hz, note.msecs, note.vol);
                                break;
                            }
                            case 1: {
                                this.sine(note.hz, note.msecs, note.vol);
                                break;
                            }
                            case 2: {
                                this.noise(note.hz, note.msecs, note.vol);
                                break;
                            }
                            case 4: {
                                this.grate(note.hz, note.msecs, note.vol);
                            }
                        }
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public class Note {
        public final int hz;
        public final int msecs;
        public final float vol;
        public final byte type;

        public Note(int hz, int msecs, float vol, byte type) {
            this.hz = hz;
            this.msecs = msecs;
            this.vol = vol;
            this.type = type;
        }
    }
}

