/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.brickblaster.game.powerups;

import com.vulpovile.games.brickblaster.game.powerups.PowerUp;
import com.vulpovile.games.brickblaster.game.powerups.impl.ExtraBall;
import com.vulpovile.games.brickblaster.game.powerups.impl.InvertScreen;
import com.vulpovile.games.brickblaster.game.powerups.impl.MultiBall;
import com.vulpovile.games.brickblaster.game.powerups.impl.PaddleExtend;
import com.vulpovile.games.brickblaster.game.powerups.impl.PaddleShrink;
import com.vulpovile.games.brickblaster.game.powerups.impl.SuperBall;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class PowerUpProvider {
    private static final Random random = new Random();
    private static int totalProb = 0;
    private static final Map<Byte, Integer> pupTable = new HashMap<Byte, Integer>();

    static {
        PowerUpProvider.addProbability(0, 60);
        PowerUpProvider.addProbability(1, 100);
        PowerUpProvider.addProbability(2, 100);
        PowerUpProvider.addProbability(3, 110);
        PowerUpProvider.addProbability(4, 90);
        PowerUpProvider.addProbability(5, 70);
    }

    private static void addProbability(int itemID, int probability) {
        pupTable.put((byte)itemID, probability);
        totalProb += probability;
    }

    private static PowerUp fromID(byte itemID) {
        switch (itemID) {
            case 0: {
                return new ExtraBall();
            }
            case 1: {
                return new InvertScreen();
            }
            case 2: {
                return new MultiBall();
            }
            case 3: {
                return new PaddleExtend();
            }
            case 4: {
                return new PaddleShrink();
            }
            case 5: {
                return new SuperBall();
            }
        }
        return null;
    }

    public static PowerUp providePowerUp(int x, int y, byte tile) {
        if (random.nextInt(5) == 0) {
            int prob = random.nextInt(totalProb);
            int offset = 0;
            for (Map.Entry<Byte, Integer> item : pupTable.entrySet()) {
                if (prob < offset + item.getValue()) {
                    PowerUp pup = PowerUpProvider.fromID(item.getKey());
                    if (pup != null) {
                        pup.x = x;
                        pup.y = y;
                    }
                    return pup;
                }
                offset += item.getValue().intValue();
            }
        }
        return null;
    }
}

