/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.brickblaster.level;

import com.vulpovile.games.brickblaster.level.LevelLoader;
import com.vulpovile.games.brickblaster.util.Util;
import java.io.IOException;
import java.io.InputStream;

public class InternalLevelLoader
extends LevelLoader {
    private static String[] BUILTIN_LEVELS = new String[]{"intro.bbl", "sex", "stagger.bbl", "half.bbl", "challenger.bbl", "heart.bbl", "full.bbl", "hole.bbl", "trickshot.bbl", "smiley.bbl", "chekkit.bbl"};
    private int currLevel = 0;

    public int loadLevel(byte[] dest) {
        String levelResource = "/builtin_levels/" + BUILTIN_LEVELS[this.currLevel];
        InputStream stream = this.getClass().getResourceAsStream(levelResource);
        if (stream != null) {
            try {
                super.loadStandardLevelFromStream(stream, dest);
                int n = super.calculateHitables(dest);
                return n;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                Util.cleanClose(stream);
            }
        }
        return -1;
    }

    public boolean incrementLevelCounter() {
        this.currLevel = (this.currLevel + 1) % BUILTIN_LEVELS.length;
        return this.currLevel == 0;
    }

    public void reset() {
        this.currLevel = 0;
    }
}

