/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class Sound {
    public static float SAMPLE_RATE = 14000.0f;
    private static SourceDataLine sdl = null;
    private static int lastCall = 0;

    public static void init() {
        if (sdl == null) {
            try {
                AudioFormat af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
                sdl = AudioSystem.getSourceDataLine(af);
                sdl.open(af);
                sdl.start();
            }
            catch (LineUnavailableException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void destroy() {
        System.out.println("Closing soundsystem gracefully...");
        if (sdl != null) {
            sdl.drain();
            sdl.stop();
            sdl.close();
        }
        System.out.println("Closed!");
    }

    public static void tone(int hz, int msecs, double vol) throws LineUnavailableException {
        int thisCall = ++lastCall;
        if (sdl != null) {
            byte[] buf = new byte[1];
            int i = 0;
            while (i < msecs * 8 && thisCall == lastCall) {
                double angle = (double)((float)i / (SAMPLE_RATE / (float)hz)) * 2.0 * Math.PI;
                buf[0] = (byte)(Math.sin(angle) * 127.0 * vol);
                sdl.write(buf, 0, 1);
                ++i;
            }
            sdl.drain();
        }
    }

    public static void toneAsync(final int hz, final int msecs, final double vol) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    Sound.tone(hz, msecs, vol);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }).start();
    }
}

