/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet.dialog;

import com.vulpovile.games.paddlenet.PaddlePanel;
import com.vulpovile.games.paddlenet.netcode.ClientHandler;
import com.vulpovile.games.paddlenet.netcode.ServerHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class IPPortDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JTextField txtIP;
    private JTextField txtPort;
    private boolean hostServer;
    private PaddlePanel paddlePanel;
    private JButton btnCancel = new JButton("Cancel");
    private JButton btnStart = new JButton("Start");

    public IPPortDialog(JFrame jFrame, PaddlePanel paddlePanel, boolean hostServer) {
        super(jFrame);
        this.setDefaultCloseOperation(2);
        this.paddlePanel = paddlePanel;
        this.hostServer = hostServer;
        this.setSize(456, 214);
        this.setLocationRelativeTo(jFrame);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        JPanel pnlItems = new JPanel();
        this.contentPanel.add((Component)pnlItems, "North");
        pnlItems.setLayout(new GridLayout(0, 1, 0, 0));
        if (!hostServer) {
            JPanel pnlIP = new JPanel();
            pnlIP.setBorder(new EmptyBorder(5, 5, 5, 5));
            pnlItems.add(pnlIP);
            pnlIP.setLayout(new BorderLayout(0, 0));
            JLabel lblNewLabel = new JLabel("Server IP");
            pnlIP.add((Component)lblNewLabel, "North");
            this.txtIP = new JTextField();
            pnlIP.add((Component)this.txtIP, "Center");
            this.txtIP.setColumns(10);
        }
        JPanel pnlPort = new JPanel();
        pnlPort.setBorder(new EmptyBorder(5, 5, 5, 5));
        pnlItems.add(pnlPort);
        pnlPort.setLayout(new BorderLayout(0, 0));
        JLabel lblPort = new JLabel("Port");
        pnlPort.add((Component)lblPort, "North");
        this.txtPort = new JTextField("7777");
        this.txtPort.setColumns(10);
        pnlPort.add((Component)this.txtPort, "Center");
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)pnlButtons, "South");
        this.btnStart.setActionCommand("OK");
        pnlButtons.add(this.btnStart);
        this.getRootPane().setDefaultButton(this.btnStart);
        this.btnCancel.setActionCommand("Cancel");
        pnlButtons.add(this.btnCancel);
        this.btnStart.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.btnCancel) {
            this.dispose();
        } else if (arg0.getSource() == this.btnStart) {
            block10: {
                try {
                    int port = Integer.parseInt(this.txtPort.getText().trim());
                    if (port >= 0 && port <= 65525) {
                        try {
                            if (this.hostServer) {
                                ServerHandler.startServerAsync(this.paddlePanel, port);
                                break block10;
                            }
                            String ip = this.txtIP.getText().trim();
                            InetAddress inetAddress = InetAddress.getByName(ip);
                            ClientHandler.connectAsync(this.paddlePanel, inetAddress, port);
                        }
                        catch (UnknownHostException e) {
                            JOptionPane.showMessageDialog(this, "Unknown Host", "Error", 0);
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(this, "Oops! Something happened:\n" + e.getMessage(), "Error", 0);
                            e.printStackTrace();
                        }
                        break block10;
                    }
                    JOptionPane.showMessageDialog(this, "Port must be a number between 0 and 65525", "Error", 0);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, String.valueOf(this.txtPort.getText()) + " is not a valid port! (Port must be numeric)", "Error", 0);
                }
            }
            this.dispose();
        }
    }
}

