/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.paddlenet.netcode.packet;

import com.vulpovile.games.paddlenet.netcode.NetworkHandler;
import com.vulpovile.games.paddlenet.netcode.packet.Packet1Paddle1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet2Paddle2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet3Score1;
import com.vulpovile.games.paddlenet.netcode.packet.Packet4Score2;
import com.vulpovile.games.paddlenet.netcode.packet.Packet5BallVelocity;
import com.vulpovile.games.paddlenet.netcode.packet.Packet6BallPosition;
import com.vulpovile.games.paddlenet.netcode.packet.Packet7PaddleHit;
import com.vulpovile.games.paddlenet.netcode.packet.Packet8PaddleMiss;
import com.vulpovile.games.paddlenet.netcode.packet.Packet9BoardConfiguration;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Packet {
    public static final int PROTOCOL_VERSION = 5;
    public static Map<Class<?>, Byte> packetToOp = new HashMap();
    public static Map<Byte, Packet> opToPacket = new HashMap<Byte, Packet>();

    static {
        Packet.registerPacket((byte)1, new Packet1Paddle1());
        Packet.registerPacket((byte)2, new Packet2Paddle2());
        Packet.registerPacket((byte)3, new Packet3Score1());
        Packet.registerPacket((byte)4, new Packet4Score2());
        Packet.registerPacket((byte)5, new Packet5BallVelocity());
        Packet.registerPacket((byte)6, new Packet6BallPosition());
        Packet.registerPacket((byte)7, new Packet7PaddleHit());
        Packet.registerPacket((byte)8, new Packet8PaddleMiss());
        Packet.registerPacket((byte)9, new Packet9BoardConfiguration());
    }

    public abstract Packet cloneTypeOnly();

    public static void registerPacket(byte opcode, Packet packet) {
        opToPacket.put(opcode, packet);
        packetToOp.put(packet.getClass(), opcode);
    }

    public final byte getId() {
        return packetToOp.get(this.getClass());
    }

    public void onIncoming(DataInputStream in, NetworkHandler networkHandler) throws IOException {
        networkHandler.handlePacket(this);
    }

    public void sendPacket(DataOutputStream out) throws IOException {
        out.writeByte(this.getId());
    }
}

