/*
 * Decompiled with CFR 0.152.
 */
package cn.org.hentai.acodec;

import cn.org.hentai.acodec.AudioCodec;

public class G711ACodec
extends AudioCodec {
    private static final int SIGN_BIT = 128;
    private static final int QUANT_MASK = 15;
    private static final int SEG_SHIFT = 4;
    private static final int SEG_MASK = 112;
    static short[] seg_end = new short[]{255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};

    static short search(short val, short[] table, short size) {
        short i = 0;
        while (i < size) {
            if (val <= table[i]) {
                return i;
            }
            i = (short)(i + 1);
        }
        return size;
    }

    static byte linear2alaw(short pcm_val) {
        int mask;
        if (pcm_val >= 0) {
            mask = 213;
        } else {
            mask = 85;
            if ((pcm_val = (short)(-pcm_val - 1)) < 0) {
                pcm_val = Short.MAX_VALUE;
            }
        }
        short seg = G711ACodec.search(pcm_val, seg_end, (short)8);
        if (seg >= 8) {
            return (byte)(0x7F ^ mask);
        }
        char aval = (char)(seg << 4);
        aval = seg < 2 ? (char)(aval | pcm_val >> 4 & 0xF) : (char)(aval | pcm_val >> seg + 3 & 0xF);
        return (byte)(aval ^ mask);
    }

    static short alaw2linear(byte a_val) {
        a_val = (byte)(a_val ^ 0x55);
        short t = (short)((a_val & 0xF) << 4);
        short seg = (short)((a_val & 0x70) >> 4);
        switch (seg) {
            case 0: {
                t = (short)(t + 8);
                break;
            }
            case 1: {
                t = (short)(t + 264);
                break;
            }
            default: {
                t = (short)(t + 264);
                t = (short)(t << seg - 1);
            }
        }
        return (a_val & 0x80) != 0 ? t : (short)(-t);
    }

    public byte[] toPCM(byte[] g711data) {
        byte[] pcmdata = new byte[g711data.length * 2];
        int i = 0;
        int k = 0;
        while (i < g711data.length) {
            short v = G711ACodec.alaw2linear(g711data[i]);
            pcmdata[k++] = (byte)(v & 0xFF);
            pcmdata[k++] = (byte)(v >> 8 & 0xFF);
            ++i;
        }
        return pcmdata;
    }

    public byte[] fromPCM(byte[] pcmdata) {
        byte[] g711data = new byte[pcmdata.length / 2];
        int i = 0;
        int k = 0;
        while (i < pcmdata.length) {
            short v = (short)(pcmdata[i + 1] << 8 | pcmdata[i]);
            g711data[k] = G711ACodec.linear2alaw(v);
            i += 2;
            ++k;
        }
        return g711data;
    }
}

