/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

public class Vbr {
    public static final int VBR_MEMORY_SIZE = 5;
    public static final int MIN_ENERGY = 6000;
    public static final float NOISE_POW = 0.3f;
    public static final float[][] nb_thresh = new float[][]{{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f}, {3.5f, 2.5f, 2.0f, 1.2f, 0.5f, 0.0f, -0.5f, -0.7f, -0.8f, -0.9f, -1.0f}, {10.0f, 6.5f, 5.2f, 4.5f, 3.9f, 3.5f, 3.0f, 2.5f, 2.3f, 1.8f, 1.0f}, {11.0f, 8.8f, 7.5f, 6.5f, 5.0f, 3.9f, 3.9f, 3.9f, 3.5f, 3.0f, 1.0f}, {11.0f, 11.0f, 9.9f, 9.0f, 8.0f, 7.0f, 6.5f, 6.0f, 5.0f, 4.0f, 2.0f}, {11.0f, 11.0f, 11.0f, 11.0f, 9.5f, 9.0f, 8.0f, 7.0f, 6.5f, 5.0f, 3.0f}, {11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 9.5f, 8.5f, 8.0f, 6.5f, 4.0f}, {11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 9.8f, 7.5f, 5.5f}, {8.0f, 5.0f, 3.7f, 3.0f, 2.5f, 2.0f, 1.8f, 1.5f, 1.0f, 0.0f, 0.0f}};
    public static final float[][] hb_thresh = new float[][]{{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f}, {-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f}, {11.0f, 11.0f, 9.5f, 8.5f, 7.5f, 6.0f, 5.0f, 3.9f, 3.0f, 2.0f, 1.0f}, {11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 9.5f, 8.7f, 7.8f, 7.0f, 6.5f, 4.0f}, {11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 11.0f, 9.8f, 7.5f, 5.5f}};
    public static final float[][] uhb_thresh = new float[][]{{-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f}, {3.9f, 2.5f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f}};
    private float energy_alpha = 0.1f;
    private float average_energy = 0.0f;
    private float last_energy = 1.0f;
    private float[] last_log_energy;
    private float soft_pitch = 0.0f;
    private float last_quality = 0.0f;
    private float noise_level;
    private float noise_accum = (float)(0.05 * Math.pow(6000.0, 0.3f));
    private float noise_accum_count = 0.05f;
    private int consec_noise = 0;

    public Vbr() {
        this.noise_level = this.noise_accum / this.noise_accum_count;
        this.last_log_energy = new float[5];
        int i = 0;
        while (i < 5) {
            this.last_log_energy[i] = (float)Math.log(6000.0);
            ++i;
        }
    }

    public float analysis(float[] sig, int len, int pitch, float pitch_coef) {
        float ener = 0.0f;
        float ener1 = 0.0f;
        float ener2 = 0.0f;
        float qual = 7.0f;
        float non_st = 0.0f;
        int i = 0;
        while (i < len >> 1) {
            ener1 += sig[i] * sig[i];
            ++i;
        }
        i = len >> 1;
        while (i < len) {
            ener2 += sig[i] * sig[i];
            ++i;
        }
        ener = ener1 + ener2;
        float log_energy = (float)Math.log(ener + 6000.0f);
        i = 0;
        while (i < 5) {
            non_st += (log_energy - this.last_log_energy[i]) * (log_energy - this.last_log_energy[i]);
            ++i;
        }
        if ((non_st /= 150.0f) > 1.0f) {
            non_st = 1.0f;
        }
        float voicing = 3.0f * (pitch_coef - 0.4f) * Math.abs(pitch_coef - 0.4f);
        this.average_energy = (1.0f - this.energy_alpha) * this.average_energy + this.energy_alpha * ener;
        this.noise_level = this.noise_accum / this.noise_accum_count;
        float pow_ener = (float)Math.pow(ener, 0.3f);
        if (this.noise_accum_count < 0.06f && ener > 6000.0f) {
            this.noise_accum = 0.05f * pow_ener;
        }
        if (voicing < 0.3f && non_st < 0.2f && pow_ener < 1.2f * this.noise_level || voicing < 0.3f && non_st < 0.05f && pow_ener < 1.5f * this.noise_level || voicing < 0.4f && non_st < 0.05f && pow_ener < 1.2f * this.noise_level || voicing < 0.0f && non_st < 0.05f) {
            ++this.consec_noise;
            float tmp = pow_ener > 3.0f * this.noise_level ? 3.0f * this.noise_level : pow_ener;
            if (this.consec_noise >= 4) {
                this.noise_accum = 0.95f * this.noise_accum + 0.05f * tmp;
                this.noise_accum_count = 0.95f * this.noise_accum_count + 0.05f;
            }
        } else {
            this.consec_noise = 0;
        }
        if (pow_ener < this.noise_level && ener > 6000.0f) {
            this.noise_accum = 0.95f * this.noise_accum + 0.05f * pow_ener;
            this.noise_accum_count = 0.95f * this.noise_accum_count + 0.05f;
        }
        if (ener < 30000.0f) {
            qual -= 0.7f;
            if (ener < 10000.0f) {
                qual -= 0.7f;
            }
            if (ener < 3000.0f) {
                qual -= 0.7f;
            }
        } else {
            float short_diff = (float)Math.log((ener + 1.0f) / (1.0f + this.last_energy));
            float long_diff = (float)Math.log((ener + 1.0f) / (1.0f + this.average_energy));
            if (long_diff < -5.0f) {
                long_diff = -5.0f;
            }
            if (long_diff > 2.0f) {
                long_diff = 2.0f;
            }
            if (long_diff > 0.0f) {
                qual += 0.6f * long_diff;
            }
            if (long_diff < 0.0f) {
                qual += 0.5f * long_diff;
            }
            if (short_diff > 0.0f) {
                if (short_diff > 5.0f) {
                    short_diff = 5.0f;
                }
                qual += 0.5f * short_diff;
            }
            if (ener2 > 1.6f * ener1) {
                qual += 0.5f;
            }
        }
        this.last_energy = ener;
        this.soft_pitch = 0.6f * this.soft_pitch + 0.4f * pitch_coef;
        if ((qual = (float)((double)qual + (double)2.2f * ((double)pitch_coef - 0.4 + ((double)this.soft_pitch - 0.4)))) < this.last_quality) {
            qual = 0.5f * qual + 0.5f * this.last_quality;
        }
        if (qual < 4.0f) {
            qual = 4.0f;
        }
        if (qual > 10.0f) {
            qual = 10.0f;
        }
        if (this.consec_noise >= 3) {
            qual = 4.0f;
        }
        if (this.consec_noise != 0) {
            qual -= (float)(1.0 * (Math.log(3.0 + (double)this.consec_noise) - Math.log(3.0)));
        }
        if (qual < 0.0f) {
            qual = 0.0f;
        }
        if (ener < 60000.0f) {
            if (this.consec_noise > 2) {
                qual -= (float)(0.5 * (Math.log(3.0 + (double)this.consec_noise) - Math.log(3.0)));
            }
            if (ener < 10000.0f && this.consec_noise > 2) {
                qual -= (float)(0.5 * (Math.log(3.0 + (double)this.consec_noise) - Math.log(3.0)));
            }
            if (qual < 0.0f) {
                qual = 0.0f;
            }
            qual += (float)(0.3 * Math.log((double)ener / 60000.0));
        }
        if (qual < -1.0f) {
            qual = -1.0f;
        }
        this.last_quality = qual;
        i = 4;
        while (i > 0) {
            this.last_log_energy[i] = this.last_log_energy[i - 1];
            --i;
        }
        this.last_log_energy[0] = log_energy;
        return qual;
    }
}

