/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.ui;

import com.vulpovile.hyperconference.MainInterface;
import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.discovery.DiscoveryService;
import com.vulpovile.hyperconference.net.MessageService;
import com.vulpovile.hyperconference.net.packet.Packet2Ring;
import com.vulpovile.hyperconference.util.DPIUtil;
import com.vulpovile.hyperconference.util.SfxPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import javax.sound.sampled.Clip;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class CallInitializer
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    String identifier;
    UserData self;
    MainInterface main;
    MessageService messageService;
    DiscoveryService discoveryService;
    JLabel lblDialing = new JLabel();
    boolean ringing = false;
    SocketAddress isa;
    Clip ringer = null;

    public CallInitializer(MainInterface parent, MessageService messageService, DiscoveryService discoveryService, String identifier, UserData self) {
        super(parent);
        this.main = parent;
        this.identifier = identifier;
        this.self = self;
        this.messageService = messageService;
        this.discoveryService = discoveryService;
        this.setModal(false);
        this.setTitle("Dialing " + identifier + "...");
        this.setBounds(DPIUtil.sRect(100, 100, 450, 76));
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setLayout(new FlowLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.lblDialing.setText("Dialing " + identifier + "...");
        this.contentPanel.add(this.lblDialing);
        this.setLocationRelativeTo(null);
    }

    public SocketAddress getAddress() {
        return this.isa;
    }

    public void beginCalling() {
        this.main.setCallable(false);
        this.setVisible(true);
        new Thread(this).start();
    }

    public void stopCalling() {
        this.ringing = false;
        if (this.ringer != null) {
            this.ringer.stop();
        }
        this.main.setCallable(true);
        this.dispose();
    }

    public void failure(final String message, final String title, final int error) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CallInitializer.this.dispose();
                CallInitializer.this.main.setCallable(true);
                JOptionPane.showMessageDialog(CallInitializer.this.main, message, title, error);
            }
        });
    }

    public void run() {
        List<InetAddress> addresses = this.discoveryService.sendDiscoveryRequest(this.identifier);
        if (addresses == null) {
            this.failure("Failed to send discovery request", "Error", 0);
        } else if (addresses.size() <= 0) {
            this.failure("User " + this.identifier + " not found or is not accepting calls at this time.", "Failed to connect", 1);
        } else if (addresses.size() > 1) {
            this.failure("User " + this.identifier + " ambiguous.", "Failed to connect", 1);
        } else {
            this.lblDialing.setText("Ringing " + this.identifier + "...");
            try {
                this.isa = new InetSocketAddress(addresses.get(0), 4447);
                this.messageService.setCaller(this.isa, this);
                this.ringing = true;
                int i = 0;
                while (i < 5 && this.ringing) {
                    try {
                        this.ringer = SfxPlayer.play(this.getClass().getResource("/ringout.wav"));
                        this.messageService.sendPacket(this.isa, new Packet2Ring(this.self), 0);
                        Thread.sleep(1000L);
                        if (!this.ringing) break;
                        this.ringer = SfxPlayer.play(this.getClass().getResource("/ringout.wav"));
                        this.messageService.sendPacket(this.isa, new Packet2Ring(this.self), 0);
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                if (this.ringing) {
                    this.stopCalling();
                    SfxPlayer.rplay("/hup.wav");
                    this.messageService.setCaller(this.isa, null);
                    this.failure("User " + this.identifier + " did not pick up.", "Failed to connect", 1);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.failure("Exception occurred ringing user", "Failed to connect", 1);
            }
        }
    }
}

