/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.ui;

import com.vulpovile.hyperconference.MainInterface;
import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.net.MessageService;
import com.vulpovile.hyperconference.util.DPIUtil;
import com.vulpovile.hyperconference.util.SfxPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class ChatDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    JButton btnSend = new JButton("Send");
    JEditorPane editorPane = new JEditorPane();
    JTextArea textArea = new JTextArea();
    MessageService messageService;
    MainInterface parent;

    public ChatDialog(MainInterface parent, MessageService messageService) {
        super((Frame)parent, "Chat Box");
        this.messageService = messageService;
        this.parent = parent;
        this.setDefaultCloseOperation(0);
        this.setSize(DPIUtil.getScaledDimension(450, 300));
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JPanel panel = new JPanel();
        this.contentPane.add((Component)panel, "South");
        panel.setLayout(new BorderLayout(0, 0));
        this.textArea.setRows(3);
        panel.add((Component)this.textArea, "Center");
        panel.add((Component)this.btnSend, "East");
        JScrollPane scrollPane = new JScrollPane();
        this.contentPane.add((Component)scrollPane, "Center");
        scrollPane.setViewportView(this.editorPane);
        this.setLocationRelativeTo(parent);
        this.btnSend.addActionListener(this);
    }

    public void chatRecieved(UserData userData, String message) {
        final String formattedMessage = String.valueOf(userData.alias) + ":\n" + message.trim() + "\n\n";
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SfxPlayer.rplay("/msgrecv.wav");
                ChatDialog.this.editorPane.setText(String.valueOf(ChatDialog.this.editorPane.getText()) + formattedMessage);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        String text;
        if (e.getSource() == this.btnSend && (text = this.textArea.getText().trim()).length() > 0) {
            this.messageService.sendMessage(text);
            this.textArea.setText("");
            SfxPlayer.rplay("/msgsend.wav");
            String formattedMessage = String.valueOf(this.parent.getCurrentUser().alias) + ":\n" + text + "\n\n";
            this.editorPane.setText(String.valueOf(this.editorPane.getText()) + formattedMessage);
        }
    }
}

