/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.ui;

import com.vulpovile.hyperconference.PropertyManager;
import com.vulpovile.hyperconference.ui.panels.AudioPanel;
import com.vulpovile.hyperconference.ui.panels.NamePanel;
import com.vulpovile.hyperconference.ui.panels.NetworkPanel;
import com.vulpovile.hyperconference.ui.panels.ValidatablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class ConfigureDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private final PropertyManager propManager;
    private ValidatablePanel[] screens;
    private int screenIndex = 0;
    private final JButton btnPrevious = new JButton("Previous");
    private final JButton btnNext = new JButton("Next");
    private final JLabel label = new JLabel("");
    private final JSeparator separator = new JSeparator();
    private final JButton btnCancel = new JButton("Cancel");

    public ConfigureDialog(Frame parent, PropertyManager propManager) {
        super(parent, "HyperConference - Initial Setup");
        this.screens = new ValidatablePanel[]{new NamePanel(propManager), new AudioPanel(propManager), new NetworkPanel(propManager)};
        this.setResizable(false);
        this.label.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.propManager = propManager;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setBounds(100, 100, 465, 348);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(10);
        this.getContentPane().setLayout(borderLayout);
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add(this.screens[0]);
        this.getContentPane().add((Component)this.label, "West");
        this.label.setIcon(new ImageIcon(ConfigureDialog.class.getResource("/bitmap.png")));
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(new MatteBorder(1, 0, 0, 0, UIManager.getColor("ToolBar.borderColor")));
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        buttonPane.add(this.btnCancel);
        this.separator.setOrientation(1);
        this.separator.setPreferredSize(new Dimension(2, 24));
        buttonPane.add(this.separator);
        this.btnPrevious.setEnabled(false);
        buttonPane.add(this.btnPrevious);
        this.getRootPane().setDefaultButton(this.btnPrevious);
        buttonPane.add(this.btnNext);
        this.btnNext.addActionListener(this);
        this.btnPrevious.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnCancel) {
            System.exit(0);
        } else if (e.getSource() == this.btnNext) {
            if (this.screenIndex < this.screens.length - 1 && this.screens[this.screenIndex].validateSettings()) {
                ++this.screenIndex;
            } else {
                this.finish();
            }
        } else if (e.getSource() == this.btnPrevious && this.screenIndex > 0) {
            --this.screenIndex;
        }
        this.contentPanel.removeAll();
        this.contentPanel.add(this.screens[this.screenIndex]);
        this.contentPanel.revalidate();
        this.repaint();
        if (this.screenIndex >= this.screens.length - 1) {
            this.btnNext.setText("Finish");
        } else {
            this.btnNext.setText("Next");
        }
        if (this.screenIndex <= 0) {
            this.btnPrevious.setEnabled(false);
        } else {
            this.btnPrevious.setEnabled(true);
        }
    }

    private void finish() {
        ValidatablePanel[] validatablePanelArray = this.screens;
        int n = this.screens.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatablePanel panel = validatablePanelArray[n2];
            panel.updateProperties(this.propManager);
            ++n2;
        }
        this.propManager.store();
        this.dispose();
    }
}

