/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.ui.panels;

import com.vulpovile.hyperconference.PropertyManager;
import com.vulpovile.hyperconference.ui.panels.ValidatablePanel;
import com.vulpovile.hyperconference.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioPanel
extends ValidatablePanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private Mixer.Info[] inputs = new Mixer.Info[0];
    private Mixer.Info[] outputs = new Mixer.Info[0];
    JButton btnTestSpeaker = new JButton("Test");
    JButton btnTestMic = new JButton("Test");
    JComboBox cmbSpeaker;
    JComboBox cmbMicrophone;
    private Clip clip = null;
    private AudioInputStream inputStream = null;
    TestRecording tc = new TestRecording(this);
    private JLabel lblEnterSettingsFor;

    private Collection<Mixer.Info> listAudioDevices(Class<?> lineType) {
        Mixer.Info[] mixerInfos;
        ArrayList<Mixer.Info> ret = new ArrayList<Mixer.Info>();
        ret.add(null);
        Mixer.Info[] infoArray = mixerInfos = AudioSystem.getMixerInfo();
        int n = mixerInfos.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info mixerInfo = infoArray[n2];
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            Line.Info[] lineInfos = lineType.equals(TargetDataLine.class) ? mixer.getTargetLineInfo() : mixer.getSourceLineInfo();
            Line.Info[] infoArray2 = lineInfos;
            int n3 = lineInfos.length;
            int n4 = 0;
            while (n4 < n3) {
                Line.Info lineInfo = infoArray2[n4];
                if (!ret.contains(mixerInfo) && mixer.isLineSupported(lineInfo) && lineInfo.getLineClass().isAssignableFrom(lineType)) {
                    ret.add(mixerInfo);
                }
                ++n4;
            }
            ++n2;
        }
        return ret;
    }

    public String[] getFormattedNames(Mixer.Info ... info) {
        String[] ret = new String[info.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = info[i] == null ? "System Default" : String.valueOf(info[i].getName()) + "(" + info[i].getDescription() + ")";
            ++i;
        }
        return ret;
    }

    public AudioPanel(PropertyManager propManager) {
        this.setSize(337, 238);
        this.setLayout(null);
        JLabel lblMicrophone = new JLabel("Microphone:");
        lblMicrophone.setBounds(12, 142, 100, 17);
        this.add(lblMicrophone);
        JLabel lblSpeaker = new JLabel("Speaker:");
        lblSpeaker.setBounds(12, 63, 60, 17);
        this.add(lblSpeaker);
        this.outputs = this.listAudioDevices(SourceDataLine.class).toArray(this.outputs);
        this.inputs = this.listAudioDevices(TargetDataLine.class).toArray(this.inputs);
        this.cmbMicrophone = new JComboBox<String>(this.getFormattedNames(this.inputs));
        this.cmbMicrophone.setBounds(12, 161, 313, 26);
        this.add(this.cmbMicrophone);
        this.cmbSpeaker = new JComboBox<String>(this.getFormattedNames(this.outputs));
        this.cmbSpeaker.setBounds(12, 82, 313, 26);
        this.add(this.cmbSpeaker);
        this.btnTestSpeaker.addActionListener(this);
        this.btnTestSpeaker.setBounds(255, 122, 70, 27);
        this.add(this.btnTestSpeaker);
        this.btnTestMic.addActionListener(this);
        this.btnTestMic.setBounds(255, 199, 70, 27);
        this.add(this.btnTestMic);
        this.lblEnterSettingsFor = new JLabel("Enter settings for your audio devices.");
        this.lblEnterSettingsFor.setBounds(12, 12, 313, 17);
        this.add(this.lblEnterSettingsFor);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnTestSpeaker) {
            if (this.clip == null) {
                this.btnTestSpeaker.setText("Stop");
                int sel = this.cmbSpeaker.getSelectedIndex();
                try {
                    this.inputStream = AudioSystem.getAudioInputStream(this.getClass().getResource("/testsnd.wav"));
                    this.clip = AudioSystem.getClip(this.outputs[sel]);
                    this.clip.open(this.inputStream);
                    this.clip.loop(Integer.MAX_VALUE);
                    this.clip.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.btnTestSpeaker.setText("Test");
                    Util.cleanClose(this.clip);
                    Util.cleanClose(this.inputStream);
                    this.clip = null;
                }
            } else {
                this.btnTestSpeaker.setText("Test");
                this.clip.stop();
                Util.cleanClose(this.clip);
                Util.cleanClose(this.inputStream);
                this.clip = null;
            }
        } else if (e.getSource() == this.btnTestMic) {
            if (!this.tc.isTestRunning()) {
                this.tc.runTest();
            } else {
                this.tc.end();
            }
        }
    }

    @Override
    public boolean validateSettings() {
        return true;
    }

    @Override
    public void updateProperties(PropertyManager propManager) {
    }

    class TestRecording
    implements Runnable {
        private boolean cancelled = false;
        private AudioPanel soundPanel;
        private Thread self = null;

        public TestRecording(AudioPanel configureDialog) {
            this.soundPanel = configureDialog;
        }

        public void run() {
            this.recordAndPlay();
        }

        public void runTest() {
            if (this.self != null) {
                return;
            }
            this.self = new Thread(this);
            this.self.start();
        }

        public boolean isTestRunning() {
            return this.self != null;
        }

        public void end() {
            this.cancelled = true;
        }

        private void recordAndPlay() {
            try {
                int sel = AudioPanel.this.cmbMicrophone.getSelectedIndex();
                Mixer mixer = AudioSystem.getMixer(this.soundPanel.inputs[sel]);
                AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
                DataLine.Info lineInfo = new DataLine.Info(TargetDataLine.class, format);
                TargetDataLine microphone = (TargetDataLine)mixer.getLine(lineInfo);
                microphone.open(format);
                microphone.start();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                long end = System.currentTimeMillis() + 5000L;
                System.out.println("Recording...");
                while (System.currentTimeMillis() < end && !this.cancelled) {
                    int count = microphone.read(buffer, 0, buffer.length);
                    if (count > 0) {
                        out.write(buffer, 0, count);
                    }
                    this.soundPanel.btnTestMic.setText(String.valueOf((end - System.currentTimeMillis()) / 1000L));
                }
                microphone.stop();
                microphone.close();
                System.out.println("Recording stopped");
                byte[] audioData = out.toByteArray();
                this.play(format, audioData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void play(AudioFormat format, byte[] data) throws Exception {
            this.self = null;
            int sel = AudioPanel.this.cmbSpeaker.getSelectedIndex();
            Clip clip = AudioSystem.getClip(this.soundPanel.outputs[sel]);
            clip.open(format, data, 0, data.length);
            clip.start();
            this.soundPanel.btnTestMic.setText("Test");
        }
    }
}

