/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.Encoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Lpc;
import org.xiph.speex.Lsp;
import org.xiph.speex.Ltp;
import org.xiph.speex.Misc;
import org.xiph.speex.NbCodec;
import org.xiph.speex.NoiseSearch;
import org.xiph.speex.VQ;
import org.xiph.speex.Vbr;

public class NbEncoder
extends NbCodec
implements Encoder {
    public static final int[] NB_QUALITY_MAP = new int[]{1, 8, 2, 3, 3, 4, 4, 5, 5, 6, 7};
    private int bounded_pitch;
    private int[] pitch;
    private float pre_mem2;
    private float[] exc2Buf;
    private int exc2Idx;
    private float[] swBuf;
    private int swIdx;
    private float[] window;
    private float[] buf2;
    private float[] autocorr;
    private float[] lagWindow;
    private float[] lsp;
    private float[] old_lsp;
    private float[] interp_lsp;
    private float[] interp_lpc;
    private float[] bw_lpc1;
    private float[] bw_lpc2;
    private float[] rc;
    private float[] mem_sw;
    private float[] mem_sw_whole;
    private float[] mem_exc;
    private Vbr vbr;
    private int dtx_count;
    protected int complexity;
    protected int vbr_enabled;
    protected int vad_enabled;
    protected int abr_enabled;
    protected float vbr_quality;
    protected float relative_quality;
    protected float abr_drift;
    protected float abr_drift2;
    protected float abr_count;
    protected int sampling_rate;
    protected int submodeSelect;

    public void init(int frameSize, int subframeSize, int lpcSize, int bufSize) {
        super.init(frameSize, subframeSize, lpcSize, bufSize);
        this.complexity = 3;
        this.vbr_enabled = 0;
        this.vad_enabled = 0;
        this.abr_enabled = 0;
        this.vbr_quality = 8.0f;
        this.submodeSelect = 5;
        this.pre_mem2 = 0.0f;
        this.bounded_pitch = 1;
        this.exc2Buf = new float[bufSize];
        this.exc2Idx = bufSize - this.windowSize;
        this.swBuf = new float[bufSize];
        this.swIdx = bufSize - this.windowSize;
        this.window = Misc.window(this.windowSize, subframeSize);
        this.lagWindow = Misc.lagWindow(lpcSize, this.lag_factor);
        this.autocorr = new float[lpcSize + 1];
        this.buf2 = new float[this.windowSize];
        this.interp_lpc = new float[lpcSize + 1];
        this.interp_qlpc = new float[lpcSize + 1];
        this.bw_lpc1 = new float[lpcSize + 1];
        this.bw_lpc2 = new float[lpcSize + 1];
        this.lsp = new float[lpcSize];
        this.qlsp = new float[lpcSize];
        this.old_lsp = new float[lpcSize];
        this.old_qlsp = new float[lpcSize];
        this.interp_lsp = new float[lpcSize];
        this.interp_qlsp = new float[lpcSize];
        this.rc = new float[lpcSize];
        this.mem_sp = new float[lpcSize];
        this.mem_sw = new float[lpcSize];
        this.mem_sw_whole = new float[lpcSize];
        this.mem_exc = new float[lpcSize];
        this.vbr = new Vbr();
        this.dtx_count = 0;
        this.abr_count = 0.0f;
        this.sampling_rate = 8000;
        this.awk1 = new float[lpcSize + 1];
        this.awk2 = new float[lpcSize + 1];
        this.awk3 = new float[lpcSize + 1];
        this.filters.init();
        this.pitch = new int[this.nbSubframes];
    }

    public int encode(Bits bits, float[] in) {
        int qe;
        float ol_pitch_coef;
        int ol_pitch;
        System.arraycopy(this.frmBuf, this.frameSize, this.frmBuf, 0, this.bufSize - this.frameSize);
        this.frmBuf[this.bufSize - this.frameSize] = in[0] - this.preemph * this.pre_mem;
        int i = 1;
        while (i < this.frameSize) {
            this.frmBuf[this.bufSize - this.frameSize + i] = in[i] - this.preemph * in[i - 1];
            ++i;
        }
        this.pre_mem = in[this.frameSize - 1];
        System.arraycopy(this.exc2Buf, this.frameSize, this.exc2Buf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.swBuf, this.frameSize, this.swBuf, 0, this.bufSize - this.frameSize);
        i = 0;
        while (i < this.windowSize) {
            this.buf2[i] = this.frmBuf[i + this.frmIdx] * this.window[i];
            ++i;
        }
        Lpc.autocorr(this.buf2, this.autocorr, this.lpcSize + 1, this.windowSize);
        this.autocorr[0] = this.autocorr[0] + 10.0f;
        this.autocorr[0] = this.autocorr[0] * this.lpc_floor;
        i = 0;
        while (i < this.lpcSize + 1) {
            int n = i;
            this.autocorr[n] = this.autocorr[n] * this.lagWindow[i];
            ++i;
        }
        Lpc.wld(this.lpc, this.autocorr, this.rc, this.lpcSize);
        System.arraycopy(this.lpc, 0, this.lpc, 1, this.lpcSize);
        this.lpc[0] = 1.0f;
        int roots = Lsp.lpc2lsp(this.lpc, this.lpcSize, this.lsp, 15, 0.2f);
        if (roots == this.lpcSize) {
            i = 0;
            while (i < this.lpcSize) {
                this.lsp[i] = (float)Math.acos(this.lsp[i]);
                ++i;
            }
        } else {
            if (this.complexity > 1) {
                roots = Lsp.lpc2lsp(this.lpc, this.lpcSize, this.lsp, 11, 0.05f);
            }
            if (roots == this.lpcSize) {
                i = 0;
                while (i < this.lpcSize) {
                    this.lsp[i] = (float)Math.acos(this.lsp[i]);
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.lpcSize) {
                    this.lsp[i] = this.old_lsp[i];
                    ++i;
                }
            }
        }
        float lsp_dist = 0.0f;
        i = 0;
        while (i < this.lpcSize) {
            lsp_dist += (this.old_lsp[i] - this.lsp[i]) * (this.old_lsp[i] - this.lsp[i]);
            ++i;
        }
        if (this.first != 0) {
            i = 0;
            while (i < this.lpcSize) {
                this.interp_lsp[i] = this.lsp[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < this.lpcSize) {
                this.interp_lsp[i] = 0.375f * this.old_lsp[i] + 0.625f * this.lsp[i];
                ++i;
            }
        }
        Lsp.enforce_margin(this.interp_lsp, this.lpcSize, 0.002f);
        i = 0;
        while (i < this.lpcSize) {
            this.interp_lsp[i] = (float)Math.cos(this.interp_lsp[i]);
            ++i;
        }
        this.m_lsp.lsp2lpc(this.interp_lsp, this.interp_lpc, this.lpcSize);
        if (this.submodes[this.submodeID] == null || this.vbr_enabled != 0 || this.vad_enabled != 0 || this.submodes[this.submodeID].forced_pitch_gain != 0 || this.submodes[this.submodeID].lbr_pitch != -1) {
            int[] nol_pitch = new int[6];
            float[] nol_pitch_coef = new float[6];
            Filters.bw_lpc(this.gamma1, this.interp_lpc, this.bw_lpc1, this.lpcSize);
            Filters.bw_lpc(this.gamma2, this.interp_lpc, this.bw_lpc2, this.lpcSize);
            Filters.filter_mem2(this.frmBuf, this.frmIdx, this.bw_lpc1, this.bw_lpc2, this.swBuf, this.swIdx, this.frameSize, this.lpcSize, this.mem_sw_whole, 0);
            Ltp.open_loop_nbest_pitch(this.swBuf, this.swIdx, this.min_pitch, this.max_pitch, this.frameSize, nol_pitch, nol_pitch_coef, 6);
            ol_pitch = nol_pitch[0];
            ol_pitch_coef = nol_pitch_coef[0];
            i = 1;
            while (i < 6) {
                if ((double)nol_pitch_coef[i] > 0.85 * (double)ol_pitch_coef && (Math.abs((double)nol_pitch[i] - (double)ol_pitch / 2.0) <= 1.0 || Math.abs((double)nol_pitch[i] - (double)ol_pitch / 3.0) <= 1.0 || Math.abs((double)nol_pitch[i] - (double)ol_pitch / 4.0) <= 1.0 || Math.abs((double)nol_pitch[i] - (double)ol_pitch / 5.0) <= 1.0)) {
                    ol_pitch = nol_pitch[i];
                }
                ++i;
            }
        } else {
            ol_pitch = 0;
            ol_pitch_coef = 0.0f;
        }
        Filters.fir_mem2(this.frmBuf, this.frmIdx, this.interp_lpc, this.excBuf, this.excIdx, this.frameSize, this.lpcSize, this.mem_exc);
        float ol_gain = 0.0f;
        i = 0;
        while (i < this.frameSize) {
            ol_gain += this.excBuf[this.excIdx + i] * this.excBuf[this.excIdx + i];
            ++i;
        }
        ol_gain = (float)Math.sqrt(1.0f + ol_gain / (float)this.frameSize);
        if (this.vbr != null && (this.vbr_enabled != 0 || this.vad_enabled != 0)) {
            if (this.abr_enabled != 0) {
                float qual_change = 0.0f;
                if (this.abr_drift2 * this.abr_drift > 0.0f) {
                    qual_change = -1.0E-5f * this.abr_drift / (1.0f + this.abr_count);
                    if (qual_change > 0.05f) {
                        qual_change = 0.05f;
                    }
                    if (qual_change < -0.05f) {
                        qual_change = -0.05f;
                    }
                }
                this.vbr_quality += qual_change;
                if (this.vbr_quality > 10.0f) {
                    this.vbr_quality = 10.0f;
                }
                if (this.vbr_quality < 0.0f) {
                    this.vbr_quality = 0.0f;
                }
            }
            this.relative_quality = this.vbr.analysis(in, this.frameSize, ol_pitch, ol_pitch_coef);
            if (this.vbr_enabled != 0) {
                int choice = 0;
                float min_diff = 100.0f;
                int mode = 8;
                while (mode > 0) {
                    int v1 = (int)Math.floor(this.vbr_quality);
                    float thresh = v1 == 10 ? Vbr.nb_thresh[mode][v1] : (this.vbr_quality - (float)v1) * Vbr.nb_thresh[mode][v1 + 1] + ((float)(1 + v1) - this.vbr_quality) * Vbr.nb_thresh[mode][v1];
                    if (this.relative_quality > thresh && this.relative_quality - thresh < min_diff) {
                        choice = mode;
                        min_diff = this.relative_quality - thresh;
                    }
                    --mode;
                }
                mode = choice;
                if (mode == 0) {
                    if (this.dtx_count == 0 || (double)lsp_dist > 0.05 || this.dtx_enabled == 0 || this.dtx_count > 20) {
                        mode = 1;
                        this.dtx_count = 1;
                    } else {
                        mode = 0;
                        ++this.dtx_count;
                    }
                } else {
                    this.dtx_count = 0;
                }
                this.setMode(mode);
                if (this.abr_enabled != 0) {
                    int bitrate = this.getBitRate();
                    this.abr_drift += (float)(bitrate - this.abr_enabled);
                    this.abr_drift2 = 0.95f * this.abr_drift2 + 0.05f * (float)(bitrate - this.abr_enabled);
                    this.abr_count = (float)((double)this.abr_count + 1.0);
                }
            } else {
                int mode;
                if (this.relative_quality < 2.0f) {
                    if (this.dtx_count == 0 || (double)lsp_dist > 0.05 || this.dtx_enabled == 0 || this.dtx_count > 20) {
                        this.dtx_count = 1;
                        mode = 1;
                    } else {
                        mode = 0;
                        ++this.dtx_count;
                    }
                } else {
                    this.dtx_count = 0;
                    mode = this.submodeSelect;
                }
                this.submodeID = mode;
            }
        } else {
            this.relative_quality = -1.0f;
        }
        bits.pack(0, 1);
        bits.pack(this.submodeID, 4);
        if (this.submodes[this.submodeID] == null) {
            i = 0;
            while (i < this.frameSize) {
                this.swBuf[this.swIdx + i] = 0.0f;
                this.exc2Buf[this.exc2Idx + i] = 0.0f;
                this.excBuf[this.excIdx + i] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                this.mem_sw[i] = 0.0f;
                ++i;
            }
            this.first = 1;
            this.bounded_pitch = 1;
            Filters.iir_mem2(this.excBuf, this.excIdx, this.interp_qlpc, this.frmBuf, this.frmIdx, this.frameSize, this.lpcSize, this.mem_sp);
            in[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem2;
            i = 1;
            while (i < this.frameSize) {
                this.frmIdx = i;
                in[i] = this.frmBuf[this.frmIdx] + this.preemph * in[i - 1];
                ++i;
            }
            this.pre_mem2 = in[this.frameSize - 1];
            return 0;
        }
        if (this.first != 0) {
            i = 0;
            while (i < this.lpcSize) {
                this.old_lsp[i] = this.lsp[i];
                ++i;
            }
        }
        this.submodes[this.submodeID].lsqQuant.quant(this.lsp, this.qlsp, this.lpcSize, bits);
        if (this.submodes[this.submodeID].lbr_pitch != -1) {
            bits.pack(ol_pitch - this.min_pitch, 7);
        }
        if (this.submodes[this.submodeID].forced_pitch_gain != 0) {
            int quant = (int)Math.floor(0.5 + (double)(15.0f * ol_pitch_coef));
            if (quant > 15) {
                quant = 15;
            }
            if (quant < 0) {
                quant = 0;
            }
            bits.pack(quant, 4);
            ol_pitch_coef = 0.066667f * (float)quant;
        }
        if ((qe = (int)Math.floor(0.5 + 3.5 * Math.log(ol_gain))) < 0) {
            qe = 0;
        }
        if (qe > 31) {
            qe = 31;
        }
        ol_gain = (float)Math.exp((double)qe / 3.5);
        bits.pack(qe, 5);
        if (this.first != 0) {
            i = 0;
            while (i < this.lpcSize) {
                this.old_qlsp[i] = this.qlsp[i];
                ++i;
            }
        }
        float[] res = new float[this.subframeSize];
        float[] target = new float[this.subframeSize];
        float[] syn_resp = new float[this.subframeSize];
        float[] mem = new float[this.lpcSize];
        float[] orig = new float[this.frameSize];
        i = 0;
        while (i < this.frameSize) {
            orig[i] = this.frmBuf[this.frmIdx + i];
            ++i;
        }
        int sub = 0;
        while (sub < this.nbSubframes) {
            int pitchval;
            int pit_max;
            int pit_min;
            int offset = this.subframeSize * sub;
            int sp = this.frmIdx + offset;
            int exc = this.excIdx + offset;
            int sw = this.swIdx + offset;
            int exc2 = this.exc2Idx + offset;
            float tmp = (float)(1.0 + (double)sub) / (float)this.nbSubframes;
            i = 0;
            while (i < this.lpcSize) {
                this.interp_lsp[i] = (1.0f - tmp) * this.old_lsp[i] + tmp * this.lsp[i];
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                this.interp_qlsp[i] = (1.0f - tmp) * this.old_qlsp[i] + tmp * this.qlsp[i];
                ++i;
            }
            Lsp.enforce_margin(this.interp_lsp, this.lpcSize, 0.002f);
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.002f);
            i = 0;
            while (i < this.lpcSize) {
                this.interp_lsp[i] = (float)Math.cos(this.interp_lsp[i]);
                ++i;
            }
            this.m_lsp.lsp2lpc(this.interp_lsp, this.interp_lpc, this.lpcSize);
            i = 0;
            while (i < this.lpcSize) {
                this.interp_qlsp[i] = (float)Math.cos(this.interp_qlsp[i]);
                ++i;
            }
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            tmp = 1.0f;
            this.pi_gain[sub] = 0.0f;
            i = 0;
            while (i <= this.lpcSize) {
                int n = sub;
                this.pi_gain[n] = this.pi_gain[n] + tmp * this.interp_qlpc[i];
                tmp = -tmp;
                ++i;
            }
            Filters.bw_lpc(this.gamma1, this.interp_lpc, this.bw_lpc1, this.lpcSize);
            if (this.gamma2 >= 0.0f) {
                Filters.bw_lpc(this.gamma2, this.interp_lpc, this.bw_lpc2, this.lpcSize);
            } else {
                this.bw_lpc2[0] = 1.0f;
                this.bw_lpc2[1] = -this.preemph;
                i = 2;
                while (i <= this.lpcSize) {
                    this.bw_lpc2[i] = 0.0f;
                    ++i;
                }
            }
            i = 0;
            while (i < this.subframeSize) {
                this.excBuf[exc + i] = 0.0f;
                ++i;
            }
            this.excBuf[exc] = 1.0f;
            Filters.syn_percep_zero(this.excBuf, exc, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, syn_resp, this.subframeSize, this.lpcSize);
            i = 0;
            while (i < this.subframeSize) {
                this.excBuf[exc + i] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < this.subframeSize) {
                this.exc2Buf[exc2 + i] = 0.0f;
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                mem[i] = this.mem_sp[i];
                ++i;
            }
            Filters.iir_mem2(this.excBuf, exc, this.interp_qlpc, this.excBuf, exc, this.subframeSize, this.lpcSize, mem);
            i = 0;
            while (i < this.lpcSize) {
                mem[i] = this.mem_sw[i];
                ++i;
            }
            Filters.filter_mem2(this.excBuf, exc, this.bw_lpc1, this.bw_lpc2, res, 0, this.subframeSize, this.lpcSize, mem, 0);
            i = 0;
            while (i < this.lpcSize) {
                mem[i] = this.mem_sw[i];
                ++i;
            }
            Filters.filter_mem2(this.frmBuf, sp, this.bw_lpc1, this.bw_lpc2, this.swBuf, sw, this.subframeSize, this.lpcSize, mem, 0);
            i = 0;
            while (i < this.subframeSize) {
                target[i] = this.swBuf[sw + i] - res[i];
                ++i;
            }
            i = 0;
            while (i < this.subframeSize) {
                this.exc2Buf[exc2 + i] = 0.0f;
                this.excBuf[exc + i] = 0.0f;
                ++i;
            }
            if (this.submodes[this.submodeID].lbr_pitch != -1) {
                int margin = this.submodes[this.submodeID].lbr_pitch;
                if (margin != 0) {
                    if (ol_pitch < this.min_pitch + margin - 1) {
                        ol_pitch = this.min_pitch + margin - 1;
                    }
                    if (ol_pitch > this.max_pitch - margin) {
                        ol_pitch = this.max_pitch - margin;
                    }
                    pit_min = ol_pitch - margin + 1;
                    pit_max = ol_pitch + margin;
                } else {
                    pit_min = pit_max = ol_pitch;
                }
            } else {
                pit_min = this.min_pitch;
                pit_max = this.max_pitch;
            }
            if (this.bounded_pitch != 0 && pit_max > offset) {
                pit_max = offset;
            }
            this.pitch[sub] = pitchval = this.submodes[this.submodeID].ltp.quant(target, this.swBuf, sw, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.excBuf, exc, pit_min, pit_max, ol_pitch_coef, this.lpcSize, this.subframeSize, bits, this.exc2Buf, exc2, syn_resp, this.complexity);
            Filters.syn_percep_zero(this.excBuf, exc, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, res, this.subframeSize, this.lpcSize);
            i = 0;
            while (i < this.subframeSize) {
                int n = i;
                target[n] = target[n] - res[i];
                ++i;
            }
            float ener = 0.0f;
            int innovptr = sub * this.subframeSize;
            i = 0;
            while (i < this.subframeSize) {
                this.innov[innovptr + i] = 0.0f;
                ++i;
            }
            Filters.residue_percep_zero(target, 0, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.buf2, this.subframeSize, this.lpcSize);
            i = 0;
            while (i < this.subframeSize) {
                ener += this.buf2[i] * this.buf2[i];
                ++i;
            }
            ener = (float)Math.sqrt(0.1f + ener / (float)this.subframeSize);
            ener /= ol_gain;
            if (this.submodes[this.submodeID].have_subframe_gain != 0) {
                int qe2;
                ener = (float)Math.log(ener);
                if (this.submodes[this.submodeID].have_subframe_gain == 3) {
                    qe2 = VQ.index(ener, exc_gain_quant_scal3, 8);
                    bits.pack(qe2, 3);
                    ener = exc_gain_quant_scal3[qe2];
                } else {
                    qe2 = VQ.index(ener, exc_gain_quant_scal1, 2);
                    bits.pack(qe2, 1);
                    ener = exc_gain_quant_scal1[qe2];
                }
                ener = (float)Math.exp(ener);
            } else {
                ener = 1.0f;
            }
            float ener_1 = 1.0f / (ener *= ol_gain);
            i = 0;
            while (i < this.subframeSize) {
                int n = i++;
                target[n] = target[n] * ener_1;
            }
            this.submodes[this.submodeID].innovation.quant(target, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.lpcSize, this.subframeSize, this.innov, innovptr, syn_resp, bits, this.complexity);
            i = 0;
            while (i < this.subframeSize) {
                int n = innovptr + i;
                this.innov[n] = this.innov[n] * ener;
                ++i;
            }
            i = 0;
            while (i < this.subframeSize) {
                int n = exc + i;
                this.excBuf[n] = this.excBuf[n] + this.innov[innovptr + i];
                ++i;
            }
            if (this.submodes[this.submodeID].double_codebook != 0) {
                float[] innov2 = new float[this.subframeSize];
                i = 0;
                while (i < this.subframeSize) {
                    int n = i++;
                    target[n] = (float)((double)target[n] * 2.2);
                }
                this.submodes[this.submodeID].innovation.quant(target, this.interp_qlpc, this.bw_lpc1, this.bw_lpc2, this.lpcSize, this.subframeSize, innov2, 0, syn_resp, bits, this.complexity);
                i = 0;
                while (i < this.subframeSize) {
                    int n = i++;
                    innov2[n] = (float)((double)innov2[n] * ((double)ener * 0.45454545454545453));
                }
                i = 0;
                while (i < this.subframeSize) {
                    int n = exc + i;
                    this.excBuf[n] = this.excBuf[n] + innov2[i];
                    ++i;
                }
            }
            i = 0;
            while (i < this.subframeSize) {
                int n = i++;
                target[n] = target[n] * ener;
            }
            i = 0;
            while (i < this.lpcSize) {
                mem[i] = this.mem_sp[i];
                ++i;
            }
            Filters.iir_mem2(this.excBuf, exc, this.interp_qlpc, this.frmBuf, sp, this.subframeSize, this.lpcSize, this.mem_sp);
            Filters.filter_mem2(this.frmBuf, sp, this.bw_lpc1, this.bw_lpc2, this.swBuf, sw, this.subframeSize, this.lpcSize, this.mem_sw, 0);
            i = 0;
            while (i < this.subframeSize) {
                this.exc2Buf[exc2 + i] = this.excBuf[exc + i];
                ++i;
            }
            ++sub;
        }
        if (this.submodeID >= 1) {
            i = 0;
            while (i < this.lpcSize) {
                this.old_lsp[i] = this.lsp[i];
                ++i;
            }
            i = 0;
            while (i < this.lpcSize) {
                this.old_qlsp[i] = this.qlsp[i];
                ++i;
            }
        }
        if (this.submodeID == 1) {
            if (this.dtx_count != 0) {
                bits.pack(15, 4);
            } else {
                bits.pack(0, 4);
            }
        }
        this.first = 0;
        in[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem2;
        i = 1;
        while (i < this.frameSize) {
            in[i] = this.frmBuf[this.frmIdx + i] + this.preemph * in[i - 1];
            ++i;
        }
        this.pre_mem2 = in[this.frameSize - 1];
        this.bounded_pitch = this.submodes[this.submodeID].innovation instanceof NoiseSearch || this.submodeID == 0 ? 1 : 0;
        return 1;
    }

    public int getEncodedFrameSize() {
        return NB_FRAME_SIZE[this.submodeID];
    }

    public void setQuality(int quality) {
        if (quality < 0) {
            quality = 0;
        }
        if (quality > 10) {
            quality = 10;
        }
        this.submodeID = this.submodeSelect = NB_QUALITY_MAP[quality];
    }

    public int getBitRate() {
        if (this.submodes[this.submodeID] != null) {
            return this.sampling_rate * this.submodes[this.submodeID].bits_per_frame / this.frameSize;
        }
        return this.sampling_rate * 5 / this.frameSize;
    }

    public void setMode(int mode) {
        if (mode < 0) {
            mode = 0;
        }
        this.submodeID = this.submodeSelect = mode;
    }

    public int getMode() {
        return this.submodeID;
    }

    public void setBitRate(int bitrate) {
        int i = 10;
        while (i >= 0) {
            this.setQuality(i);
            if (this.getBitRate() <= bitrate) {
                return;
            }
            --i;
        }
    }

    public void setVbr(boolean vbr) {
        this.vbr_enabled = vbr ? 1 : 0;
    }

    public boolean getVbr() {
        return this.vbr_enabled != 0;
    }

    public void setVad(boolean vad) {
        this.vad_enabled = vad ? 1 : 0;
    }

    public boolean getVad() {
        return this.vad_enabled != 0;
    }

    public void setDtx(boolean dtx) {
        this.dtx_enabled = dtx ? 1 : 0;
    }

    public int getAbr() {
        return this.abr_enabled;
    }

    public void setAbr(int abr) {
        this.abr_enabled = abr != 0 ? 1 : 0;
        this.vbr_enabled = 1;
        int i = 10;
        int target = abr;
        while (i >= 0) {
            this.setQuality(i);
            int rate = this.getBitRate();
            if (rate <= target) break;
            --i;
        }
        float vbr_qual = i;
        if (vbr_qual < 0.0f) {
            vbr_qual = 0.0f;
        }
        this.setVbrQuality(vbr_qual);
        this.abr_count = 0.0f;
        this.abr_drift = 0.0f;
        this.abr_drift2 = 0.0f;
    }

    public void setVbrQuality(float quality) {
        if (quality < 0.0f) {
            quality = 0.0f;
        }
        if (quality > 10.0f) {
            quality = 10.0f;
        }
        this.vbr_quality = quality;
    }

    public float getVbrQuality() {
        return this.vbr_quality;
    }

    public void setComplexity(int complexity) {
        if (complexity < 0) {
            complexity = 0;
        }
        if (complexity > 10) {
            complexity = 10;
        }
        this.complexity = complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public void setSamplingRate(int rate) {
        this.sampling_rate = rate;
    }

    public int getSamplingRate() {
        return this.sampling_rate;
    }

    public int getLookAhead() {
        return this.windowSize - this.frameSize;
    }

    public float getRelativeQuality() {
        return this.relative_quality;
    }
}

