/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.net.packet;

import com.vulpovile.hyperconference.net.MessageService;
import com.vulpovile.hyperconference.net.packet.Packet2Ring;
import com.vulpovile.hyperconference.net.packet.Packet3HangUp;
import com.vulpovile.hyperconference.net.packet.Packet4VoiceData;
import com.vulpovile.hyperconference.net.packet.Packet5Reject;
import com.vulpovile.hyperconference.net.packet.Packet6Answer;
import com.vulpovile.hyperconference.net.packet.Packet7Message;
import com.vulpovile.hyperconference.net.packet.Packet8EndCall;
import com.vulpovile.hyperconference.net.packet.Packet9AddCaller;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.util.HashMap;

public abstract class DataPacket {
    private static final HashMap<Class<? extends DataPacket>, Short> packetToId = new HashMap();
    private static final HashMap<Short, DataPacket> idToPacket = new HashMap();

    static {
        DataPacket.registerPacket((short)2, new Packet2Ring());
        DataPacket.registerPacket((short)3, new Packet3HangUp());
        DataPacket.registerPacket((short)4, new Packet4VoiceData());
        DataPacket.registerPacket((short)5, new Packet5Reject());
        DataPacket.registerPacket((short)6, new Packet6Answer());
        DataPacket.registerPacket((short)7, new Packet7Message());
        DataPacket.registerPacket((short)8, new Packet8EndCall());
        DataPacket.registerPacket((short)9, new Packet9AddCaller());
    }

    private static void registerPacket(short id, DataPacket packet) {
        Class<?> packetClass = packet.getClass();
        if (id == 1) {
            throw new IllegalArgumentException("Cannot use reserved ACKNOWLEDGE PacketID 1");
        }
        if (idToPacket.containsKey(id)) {
            throw new IllegalStateException("Duplicate packet id: " + id);
        }
        if (packetToId.containsKey(packetClass)) {
            throw new IllegalStateException("Duplicate registration for: " + packetClass.getName());
        }
        packetToId.put(packetClass, id);
        idToPacket.put(id, packet);
    }

    public static DataPacket getPacket(short id) {
        DataPacket packet = idToPacket.get(id);
        if (packet == null) {
            return null;
        }
        return idToPacket.get(id).newInstance();
    }

    public short getID() {
        return packetToId.get(this.getClass());
    }

    public abstract DataPacket newInstance();

    public abstract void readIn(DatagramPacket var1, DataInputStream var2, int var3) throws IOException;

    public abstract void writeOut(DataOutputStream var1) throws IOException;

    public abstract void processPacket(MessageService var1, DatagramPacket var2, short var3) throws IOException;

    public static String readString(DataInputStream in) throws IOException {
        int length = in.readUnsignedShort();
        byte[] string = new byte[length];
        in.readFully(string);
        return new String(string, "UTF-8");
    }

    public static void writeString(String string, DataOutputStream out) throws IOException {
        if (string == null) {
            throw new IOException("String cannot be null");
        }
        byte[] stringBytes = string.getBytes("UTF-8");
        if (stringBytes.length > 65535) {
            throw new IOException("String too long: " + stringBytes.length);
        }
        out.writeShort(stringBytes.length);
        out.write(stringBytes);
    }

    public byte[] toBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        this.writeOut(out);
        out.close();
        return baos.toByteArray();
    }
}

