/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.util;

import com.vulpovile.hyperconference.util.Util;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class SfxPlayer {
    public static Clip play(URL resource) {
        return SfxPlayer.play(resource, 0);
    }

    public static Clip play(URL resource, int loop) {
        AudioInputStream audioIn = null;
        try {
            final AudioInputStream finalIn = audioIn = AudioSystem.getAudioInputStream(resource);
            final Clip clip = AudioSystem.getClip();
            clip.open(audioIn);
            clip.loop(loop);
            clip.addLineListener(new LineListener(){

                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        clip.close();
                        Util.cleanClose(finalIn);
                    }
                }
            });
            clip.start();
            return clip;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Util.cleanClose(audioIn);
            return null;
        }
    }

    public static Clip rplay(String resourceString, int loop) {
        return SfxPlayer.play(SfxPlayer.class.getResource(resourceString), loop);
    }

    public static Clip rplay(String resourceString) {
        return SfxPlayer.play(SfxPlayer.class.getResource(resourceString));
    }
}

