/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import java.io.StreamCorruptedException;
import java.util.Random;
import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.Filters;
import org.xiph.speex.Inband;
import org.xiph.speex.Lsp;
import org.xiph.speex.NbCodec;
import org.xiph.speex.SbCodec;
import org.xiph.speex.Stereo;

public class NbDecoder
extends NbCodec
implements Decoder {
    private float[] innov2;
    private int count_lost;
    private int last_pitch;
    private float last_pitch_gain;
    private float[] pitch_gain_buf;
    private int pitch_gain_buf_idx;
    private float last_ol_gain;
    protected Random random = new Random();
    protected Stereo stereo = new Stereo();
    protected Inband inband = new Inband(this.stereo);
    protected boolean enhanced = true;

    public void init(int frameSize, int subframeSize, int lpcSize, int bufSize) {
        super.init(frameSize, subframeSize, lpcSize, bufSize);
        this.filters.init();
        this.innov2 = new float[40];
        this.count_lost = 0;
        this.last_pitch = 40;
        this.last_pitch_gain = 0.0f;
        this.pitch_gain_buf = new float[3];
        this.pitch_gain_buf_idx = 0;
        this.last_ol_gain = 0.0f;
    }

    public int decode(Bits bits, float[] out) throws StreamCorruptedException {
        int i;
        int ol_pitch = 0;
        float[] pitch_gain = new float[3];
        float ol_gain = 0.0f;
        float ol_pitch_coef = 0.0f;
        int best_pitch = 40;
        float best_pitch_gain = 0.0f;
        float pitch_average = 0.0f;
        if (bits == null && this.dtx_enabled != 0) {
            this.submodeID = 0;
        } else {
            int m;
            if (bits == null) {
                this.decodeLost(out);
                return 0;
            }
            do {
                if (bits.unpack(1) != 0) {
                    m = bits.unpack(3);
                    int advance = SbCodec.SB_FRAME_SIZE[m];
                    if (advance < 0) {
                        throw new StreamCorruptedException("Invalid sideband mode encountered (1st sideband): " + m);
                    }
                    bits.advance(advance -= 4);
                    if (bits.unpack(1) != 0) {
                        m = bits.unpack(3);
                        advance = SbCodec.SB_FRAME_SIZE[m];
                        if (advance < 0) {
                            throw new StreamCorruptedException("Invalid sideband mode encountered. (2nd sideband): " + m);
                        }
                        bits.advance(advance -= 4);
                        if (bits.unpack(1) != 0) {
                            throw new StreamCorruptedException("More than two sideband layers found");
                        }
                    }
                }
                if ((m = bits.unpack(4)) == 15) {
                    return 1;
                }
                if (m == 14) {
                    this.inband.speexInbandRequest(bits);
                    continue;
                }
                if (m == 13) {
                    this.inband.userInbandRequest(bits);
                    continue;
                }
                if (m <= 8) continue;
                throw new StreamCorruptedException("Invalid mode encountered: " + m);
            } while (m > 8);
            this.submodeID = m;
        }
        System.arraycopy(this.frmBuf, this.frameSize, this.frmBuf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        if (this.submodes[this.submodeID] == null) {
            Filters.bw_lpc(0.93f, this.interp_qlpc, this.lpc, 10);
            float innov_gain = 0.0f;
            int i2 = 0;
            while (i2 < this.frameSize) {
                innov_gain += this.innov[i2] * this.innov[i2];
                ++i2;
            }
            innov_gain = (float)Math.sqrt(innov_gain / (float)this.frameSize);
            i2 = this.excIdx;
            while (i2 < this.excIdx + this.frameSize) {
                this.excBuf[i2] = 3.0f * innov_gain * (this.random.nextFloat() - 0.5f);
                ++i2;
            }
            this.first = 1;
            Filters.iir_mem2(this.excBuf, this.excIdx, this.lpc, this.frmBuf, this.frmIdx, this.frameSize, this.lpcSize, this.mem_sp);
            out[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem;
            i2 = 1;
            while (i2 < this.frameSize) {
                out[i2] = this.frmBuf[this.frmIdx + i2] + this.preemph * out[i2 - 1];
                ++i2;
            }
            this.pre_mem = out[this.frameSize - 1];
            this.count_lost = 0;
            return 0;
        }
        this.submodes[this.submodeID].lsqQuant.unquant(this.qlsp, this.lpcSize, bits);
        if (this.count_lost != 0) {
            float lsp_dist = 0.0f;
            i = 0;
            while (i < this.lpcSize) {
                lsp_dist += Math.abs(this.old_qlsp[i] - this.qlsp[i]);
                ++i;
            }
            float fact = (float)(0.6 * Math.exp(-0.2 * (double)lsp_dist));
            i = 0;
            while (i < 2 * this.lpcSize) {
                int n = i++;
                this.mem_sp[n] = this.mem_sp[n] * fact;
            }
        }
        if (this.first != 0 || this.count_lost != 0) {
            i = 0;
            while (i < this.lpcSize) {
                this.old_qlsp[i] = this.qlsp[i];
                ++i;
            }
        }
        if (this.submodes[this.submodeID].lbr_pitch != -1) {
            ol_pitch = this.min_pitch + bits.unpack(7);
        }
        if (this.submodes[this.submodeID].forced_pitch_gain != 0) {
            int quant = bits.unpack(4);
            ol_pitch_coef = 0.066667f * (float)quant;
        }
        int qe = bits.unpack(5);
        ol_gain = (float)Math.exp((double)qe / 3.5);
        if (this.submodeID == 1) {
            int extra = bits.unpack(4);
            this.dtx_enabled = extra == 15 ? 1 : 0;
        }
        if (this.submodeID > 1) {
            this.dtx_enabled = 0;
        }
        int sub = 0;
        while (sub < this.nbSubframes) {
            float ener;
            int ivi;
            int pit_max;
            int pit_min;
            int offset = this.subframeSize * sub;
            int spIdx = this.frmIdx + offset;
            int extIdx = this.excIdx + offset;
            float tmp = (1.0f + (float)sub) / (float)this.nbSubframes;
            i = 0;
            while (i < this.lpcSize) {
                this.interp_qlsp[i] = (1.0f - tmp) * this.old_qlsp[i] + tmp * this.qlsp[i];
                ++i;
            }
            Lsp.enforce_margin(this.interp_qlsp, this.lpcSize, 0.002f);
            i = 0;
            while (i < this.lpcSize) {
                this.interp_qlsp[i] = (float)Math.cos(this.interp_qlsp[i]);
                ++i;
            }
            this.m_lsp.lsp2lpc(this.interp_qlsp, this.interp_qlpc, this.lpcSize);
            if (this.enhanced) {
                float r = 0.9f;
                float k1 = this.submodes[this.submodeID].lpc_enh_k1;
                float k2 = this.submodes[this.submodeID].lpc_enh_k2;
                float k3 = (1.0f - (1.0f - r * k1) / (1.0f - r * k2)) / r;
                Filters.bw_lpc(k1, this.interp_qlpc, this.awk1, this.lpcSize);
                Filters.bw_lpc(k2, this.interp_qlpc, this.awk2, this.lpcSize);
                Filters.bw_lpc(k3, this.interp_qlpc, this.awk3, this.lpcSize);
            }
            tmp = 1.0f;
            this.pi_gain[sub] = 0.0f;
            i = 0;
            while (i <= this.lpcSize) {
                int n = sub;
                this.pi_gain[n] = this.pi_gain[n] + tmp * this.interp_qlpc[i];
                tmp = -tmp;
                ++i;
            }
            i = 0;
            while (i < this.subframeSize) {
                this.excBuf[extIdx + i] = 0.0f;
                ++i;
            }
            if (this.submodes[this.submodeID].lbr_pitch != -1) {
                int margin = this.submodes[this.submodeID].lbr_pitch;
                if (margin != 0) {
                    pit_min = ol_pitch - margin + 1;
                    if (pit_min < this.min_pitch) {
                        pit_min = this.min_pitch;
                    }
                    if ((pit_max = ol_pitch + margin) > this.max_pitch) {
                        pit_max = this.max_pitch;
                    }
                } else {
                    pit_min = pit_max = ol_pitch;
                }
            } else {
                pit_min = this.min_pitch;
                pit_max = this.max_pitch;
            }
            int pitch = this.submodes[this.submodeID].ltp.unquant(this.excBuf, extIdx, pit_min, ol_pitch_coef, this.subframeSize, pitch_gain, bits, this.count_lost, offset, this.last_pitch_gain);
            if (this.count_lost != 0 && ol_gain < this.last_ol_gain) {
                float fact = ol_gain / (this.last_ol_gain + 1.0f);
                i = 0;
                while (i < this.subframeSize) {
                    int n = this.excIdx + i;
                    this.excBuf[n] = this.excBuf[n] * fact;
                    ++i;
                }
            }
            tmp = Math.abs(pitch_gain[0] + pitch_gain[1] + pitch_gain[2]);
            tmp = Math.abs(pitch_gain[1]);
            tmp = pitch_gain[0] > 0.0f ? (tmp += pitch_gain[0]) : (float)((double)tmp - 0.5 * (double)pitch_gain[0]);
            tmp = pitch_gain[2] > 0.0f ? (tmp += pitch_gain[2]) : (float)((double)tmp - 0.5 * (double)pitch_gain[0]);
            pitch_average += tmp;
            if (tmp > best_pitch_gain) {
                best_pitch = pitch;
                best_pitch_gain = tmp;
            }
            i = ivi = sub * this.subframeSize;
            while (i < ivi + this.subframeSize) {
                this.innov[i] = 0.0f;
                ++i;
            }
            if (this.submodes[this.submodeID].have_subframe_gain == 3) {
                int q_energy = bits.unpack(3);
                ener = (float)((double)ol_gain * Math.exp(exc_gain_quant_scal3[q_energy]));
            } else if (this.submodes[this.submodeID].have_subframe_gain == 1) {
                int q_energy = bits.unpack(1);
                ener = (float)((double)ol_gain * Math.exp(exc_gain_quant_scal1[q_energy]));
            } else {
                ener = ol_gain;
            }
            if (this.submodes[this.submodeID].innovation != null) {
                this.submodes[this.submodeID].innovation.unquant(this.innov, ivi, this.subframeSize, bits);
            }
            i = ivi;
            while (i < ivi + this.subframeSize) {
                int n = i++;
                this.innov[n] = this.innov[n] * ener;
            }
            if (this.submodeID == 1) {
                float g = ol_pitch_coef;
                i = 0;
                while (i < this.subframeSize) {
                    this.excBuf[extIdx + i] = 0.0f;
                    ++i;
                }
                while (this.voc_offset < this.subframeSize) {
                    if (this.voc_offset >= 0) {
                        this.excBuf[extIdx + this.voc_offset] = (float)Math.sqrt(1.0f * (float)ol_pitch);
                    }
                    this.voc_offset += ol_pitch;
                }
                this.voc_offset -= this.subframeSize;
                if ((g = 0.5f + 2.0f * (g - 0.6f)) < 0.0f) {
                    g = 0.0f;
                }
                if (g > 1.0f) {
                    g = 1.0f;
                }
                i = 0;
                while (i < this.subframeSize) {
                    float itmp = this.excBuf[extIdx + i];
                    this.excBuf[extIdx + i] = 0.8f * g * this.excBuf[extIdx + i] * ol_gain + 0.6f * g * this.voc_m1 * ol_gain + 0.5f * g * this.innov[ivi + i] - 0.5f * g * this.voc_m2 + (1.0f - g) * this.innov[ivi + i];
                    this.voc_m1 = itmp;
                    this.voc_m2 = this.innov[ivi + i];
                    this.voc_mean = 0.95f * this.voc_mean + 0.05f * this.excBuf[extIdx + i];
                    int n = extIdx + i;
                    this.excBuf[n] = this.excBuf[n] - this.voc_mean;
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.subframeSize) {
                    int n = extIdx + i;
                    this.excBuf[n] = this.excBuf[n] + this.innov[ivi + i];
                    ++i;
                }
            }
            if (this.submodes[this.submodeID].double_codebook != 0) {
                i = 0;
                while (i < this.subframeSize) {
                    this.innov2[i] = 0.0f;
                    ++i;
                }
                this.submodes[this.submodeID].innovation.unquant(this.innov2, 0, this.subframeSize, bits);
                i = 0;
                while (i < this.subframeSize) {
                    int n = i++;
                    this.innov2[n] = (float)((double)this.innov2[n] * ((double)ener * 0.45454545454545453));
                }
                i = 0;
                while (i < this.subframeSize) {
                    int n = extIdx + i;
                    this.excBuf[n] = this.excBuf[n] + this.innov2[i];
                    ++i;
                }
            }
            i = 0;
            while (i < this.subframeSize) {
                this.frmBuf[spIdx + i] = this.excBuf[extIdx + i];
                ++i;
            }
            if (this.enhanced && this.submodes[this.submodeID].comb_gain > 0.0f) {
                this.filters.comb_filter(this.excBuf, extIdx, this.frmBuf, spIdx, this.subframeSize, pitch, pitch_gain, this.submodes[this.submodeID].comb_gain);
            }
            if (this.enhanced) {
                Filters.filter_mem2(this.frmBuf, spIdx, this.awk2, this.awk1, this.subframeSize, this.lpcSize, this.mem_sp, this.lpcSize);
                Filters.filter_mem2(this.frmBuf, spIdx, this.awk3, this.interp_qlpc, this.subframeSize, this.lpcSize, this.mem_sp, 0);
            } else {
                i = 0;
                while (i < this.lpcSize) {
                    this.mem_sp[this.lpcSize + i] = 0.0f;
                    ++i;
                }
                Filters.iir_mem2(this.frmBuf, spIdx, this.interp_qlpc, this.frmBuf, spIdx, this.subframeSize, this.lpcSize, this.mem_sp);
            }
            ++sub;
        }
        out[0] = this.frmBuf[this.frmIdx] + this.preemph * this.pre_mem;
        i = 1;
        while (i < this.frameSize) {
            out[i] = this.frmBuf[this.frmIdx + i] + this.preemph * out[i - 1];
            ++i;
        }
        this.pre_mem = out[this.frameSize - 1];
        i = 0;
        while (i < this.lpcSize) {
            this.old_qlsp[i] = this.qlsp[i];
            ++i;
        }
        this.first = 0;
        this.count_lost = 0;
        this.last_pitch = best_pitch;
        this.last_pitch_gain = 0.25f * pitch_average;
        this.pitch_gain_buf[this.pitch_gain_buf_idx++] = this.last_pitch_gain;
        if (this.pitch_gain_buf_idx > 2) {
            this.pitch_gain_buf_idx = 0;
        }
        this.last_ol_gain = ol_gain;
        return 0;
    }

    public int decodeLost(float[] out) {
        int i;
        float pitch_gain;
        float gain_med;
        float fact = (float)Math.exp(-0.04 * (double)this.count_lost * (double)this.count_lost);
        float f = this.pitch_gain_buf[0] < this.pitch_gain_buf[1] ? (this.pitch_gain_buf[1] < this.pitch_gain_buf[2] ? this.pitch_gain_buf[1] : (this.pitch_gain_buf[0] < this.pitch_gain_buf[2] ? this.pitch_gain_buf[2] : this.pitch_gain_buf[0])) : (this.pitch_gain_buf[2] < this.pitch_gain_buf[1] ? this.pitch_gain_buf[1] : (gain_med = this.pitch_gain_buf[2] < this.pitch_gain_buf[0] ? this.pitch_gain_buf[2] : this.pitch_gain_buf[0]));
        if (gain_med < this.last_pitch_gain) {
            this.last_pitch_gain = gain_med;
        }
        if ((pitch_gain = this.last_pitch_gain) > 0.95f) {
            pitch_gain = 0.95f;
        }
        pitch_gain *= fact;
        System.arraycopy(this.frmBuf, this.frameSize, this.frmBuf, 0, this.bufSize - this.frameSize);
        System.arraycopy(this.excBuf, this.frameSize, this.excBuf, 0, this.bufSize - this.frameSize);
        int sub = 0;
        while (sub < this.nbSubframes) {
            int offset = this.subframeSize * sub;
            int spIdx = this.frmIdx + offset;
            int extIdx = this.excIdx + offset;
            if (this.enhanced) {
                float k2;
                float k1;
                float r = 0.9f;
                if (this.submodes[this.submodeID] != null) {
                    k1 = this.submodes[this.submodeID].lpc_enh_k1;
                    k2 = this.submodes[this.submodeID].lpc_enh_k2;
                } else {
                    k2 = 0.7f;
                    k1 = 0.7f;
                }
                float k3 = (1.0f - (1.0f - r * k1) / (1.0f - r * k2)) / r;
                Filters.bw_lpc(k1, this.interp_qlpc, this.awk1, this.lpcSize);
                Filters.bw_lpc(k2, this.interp_qlpc, this.awk2, this.lpcSize);
                Filters.bw_lpc(k3, this.interp_qlpc, this.awk3, this.lpcSize);
            }
            float innov_gain = 0.0f;
            i = 0;
            while (i < this.frameSize) {
                innov_gain += this.innov[i] * this.innov[i];
                ++i;
            }
            innov_gain = (float)Math.sqrt(innov_gain / (float)this.frameSize);
            i = 0;
            while (i < this.subframeSize) {
                this.excBuf[extIdx + i] = pitch_gain * this.excBuf[extIdx + i - this.last_pitch] + fact * (float)Math.sqrt(1.0f - pitch_gain) * 3.0f * innov_gain * (this.random.nextFloat() - 0.5f);
                ++i;
            }
            i = 0;
            while (i < this.subframeSize) {
                this.frmBuf[spIdx + i] = this.excBuf[extIdx + i];
                ++i;
            }
            if (this.enhanced) {
                Filters.filter_mem2(this.frmBuf, spIdx, this.awk2, this.awk1, this.subframeSize, this.lpcSize, this.mem_sp, this.lpcSize);
                Filters.filter_mem2(this.frmBuf, spIdx, this.awk3, this.interp_qlpc, this.subframeSize, this.lpcSize, this.mem_sp, 0);
            } else {
                i = 0;
                while (i < this.lpcSize) {
                    this.mem_sp[this.lpcSize + i] = 0.0f;
                    ++i;
                }
                Filters.iir_mem2(this.frmBuf, spIdx, this.interp_qlpc, this.frmBuf, spIdx, this.subframeSize, this.lpcSize, this.mem_sp);
            }
            ++sub;
        }
        out[0] = this.frmBuf[0] + this.preemph * this.pre_mem;
        i = 1;
        while (i < this.frameSize) {
            out[i] = this.frmBuf[i] + this.preemph * out[i - 1];
            ++i;
        }
        this.pre_mem = out[this.frameSize - 1];
        this.first = 0;
        ++this.count_lost;
        this.pitch_gain_buf[this.pitch_gain_buf_idx++] = pitch_gain;
        if (this.pitch_gain_buf_idx > 2) {
            this.pitch_gain_buf_idx = 0;
        }
        return 0;
    }

    public void decodeStereo(float[] data, int frameSize) {
        this.stereo.decode(data, frameSize);
    }

    public void setPerceptualEnhancement(boolean enhanced) {
        this.enhanced = enhanced;
    }

    public boolean getPerceptualEnhancement() {
        return this.enhanced;
    }
}

