/*
 * Decompiled with CFR 0.152.
 */
package cn.org.hentai.utils;

public final class ByteUtils {
    public static byte[] parse(String hexString) {
        String[] hexes = hexString.split(" ");
        byte[] data = new byte[hexes.length];
        int i = 0;
        while (i < hexes.length) {
            data[i] = (byte)(Integer.parseInt(hexes[i], 16) & 0xFF);
            ++i;
        }
        return data;
    }

    public static synchronized void dump(byte[] data) {
        ByteUtils.dump(data, data.length);
    }

    public static synchronized void dump(byte[] data, int len) {
        int i = 0;
        int l = len;
        while (i < l && i < data.length) {
            String ascii = "";
            int k = 0;
            int f = 0;
            while (k < 16 && k < data.length) {
                if (k + i < l) {
                    ++f;
                    byte d = data[i + k];
                    String hex = Integer.toHexString(d & 0xFF).toUpperCase();
                    if (hex.length() == 1) {
                        hex = "0" + hex;
                    }
                    ascii = d >= 32 && d < 127 ? String.valueOf(ascii) + (char)d : String.valueOf(ascii) + '.';
                    System.out.print(hex);
                } else {
                    System.out.print(' ');
                    System.out.print(' ');
                }
                if (k % 4 == 3) {
                    System.out.print("   ");
                } else {
                    System.out.print(' ');
                }
                ++k;
            }
            i += f;
            System.out.println(ascii);
        }
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return "";
        }
        return ByteUtils.toString(data, data.length);
    }

    public static String toString(byte[] buff, int length) {
        StringBuffer sb = new StringBuffer(length * 2);
        int i = 0;
        while (i < length) {
            if ((buff[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(buff[i] & 0xFF).toUpperCase());
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    public static boolean getBit(int val, int pos) {
        return ByteUtils.getBit(new byte[]{(byte)(val >> 0 & 0xFF), (byte)(val >> 8 & 0xFF), (byte)(val >> 16 & 0xFF), (byte)(val >> 24 & 0xFF)}, pos);
    }

    public static int reverse(int val) {
        byte[] bytes = ByteUtils.toBytes(val);
        byte[] ret = new byte[4];
        int i = 0;
        while (i < 4) {
            ret[i] = bytes[3 - i];
            ++i;
        }
        return ByteUtils.toInt(ret);
    }

    public static byte[] toLEBytes(int val) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[3 - i] = (byte)(val >> (3 - i) * 8 & 0xFF);
            ++i;
        }
        return bytes;
    }

    public static byte[] toLEBytes(short s) {
        byte[] bytes = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
        return bytes;
    }

    public static int toInt(byte[] bytes) {
        int val = 0;
        int i = 0;
        while (i < 4) {
            val |= (bytes[i] & 0xFF) << (3 - i) * 8;
            ++i;
        }
        return val;
    }

    public static byte[] toBytes(int val) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = (byte)(val >> (3 - i) * 8 & 0xFF);
            ++i;
        }
        return bytes;
    }

    public static byte[] toBytes(long val) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            bytes[i] = (byte)(val >> (7 - i) * 8 & 0xFFL);
            ++i;
        }
        return bytes;
    }

    public static int getInt(byte[] data, int offset, int length) {
        int val = 0;
        int i = 0;
        while (i < length) {
            val |= (data[offset + i] & 0xFF) << (length - i - 1) * 8;
            ++i;
        }
        return val;
    }

    public static long getLong(byte[] data, int offset, int length) {
        long val = 0L;
        int i = 0;
        while (i < length) {
            val |= ((long)data[offset + i] & 0xFFL) << (length - i - 1) * 8;
            ++i;
        }
        return val;
    }

    public static boolean getBit(byte[] data, int pos) {
        return (data[pos / 8] >> pos % 8 & 1) == 1;
    }

    public static byte[] concat(byte[] ... byteArrays) {
        int len = 0;
        int index = 0;
        int i = 0;
        while (i < byteArrays.length) {
            len += byteArrays[i].length;
            ++i;
        }
        byte[] buff = new byte[len];
        int i2 = 0;
        while (i2 < byteArrays.length) {
            System.arraycopy(byteArrays[i2], 0, buff, index, byteArrays[i2].length);
            index += byteArrays[i2].length;
            ++i2;
        }
        return buff;
    }

    public static boolean compare(byte[] data1, byte[] data2) {
        if (data1.length != data2.length) {
            return false;
        }
        int i = 0;
        while (i < data1.length) {
            if ((data1[i] & 0xFF) != (data2[i] & 0xFF)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static short[] toShortArray(byte[] src) {
        short[] dst = new short[src.length / 2];
        int i = 0;
        int k = 0;
        while (i < src.length) {
            dst[k++] = (short)(src[i++] & 0xFF | (src[i++] & 0xFF) << 8);
        }
        return dst;
    }

    public static byte[] toByteArray(short[] src) {
        byte[] dst = new byte[src.length * 2];
        int i = 0;
        int k = 0;
        while (i < src.length) {
            dst[k++] = (byte)(src[i] & 0xFF);
            dst[k++] = (byte)(src[i] >> 8 & 0xFF);
            ++i;
        }
        return dst;
    }
}

