/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference;

import com.vulpovile.hyperconference.Microphone;
import com.vulpovile.hyperconference.PropertyManager;
import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.discovery.DiscoveryService;
import com.vulpovile.hyperconference.net.MessageService;
import com.vulpovile.hyperconference.ui.CallInitializer;
import com.vulpovile.hyperconference.ui.ChatDialog;
import com.vulpovile.hyperconference.util.DPIUtil;
import com.vulpovile.hyperconference.util.SfxPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class MainInterface
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private PropertyManager propManager;
    private MessageService messageService;
    private DiscoveryService discoveryService;
    private JButton btnCall = new JButton("CALL");
    private JButton btnHup = new JButton("END");
    private JComboBox comboBox = new JComboBox();
    private Microphone mic;
    private UserData currentUser;
    private JList list = new JList();
    private ChatDialog chatDialog;

    public MainInterface(PropertyManager propManager) {
        super("HyperConference - 0 Connected");
        this.setDefaultCloseOperation(3);
        this.setBounds(DPIUtil.sRect(100, 100, 279, 370));
        this.propManager = propManager;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmSettings = new JMenuItem("Settings...");
        mnFile.add(mntmSettings);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        JPanel pnlControls = new JPanel();
        pnlControls.setBorder(new EmptyBorder(5, 0, 5, 5));
        this.contentPane.add((Component)pnlControls, "East");
        pnlControls.setLayout(new BorderLayout(0, 0));
        JPanel pnlCallButtons = new JPanel();
        pnlControls.add((Component)pnlCallButtons, "North");
        pnlCallButtons.setLayout(new GridLayout(0, 1, 5, 5));
        pnlCallButtons.add(this.btnCall);
        pnlCallButtons.add(this.btnHup);
        JPanel pnlUsers = new JPanel();
        pnlUsers.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.add((Component)pnlUsers, "Center");
        pnlUsers.setLayout(new BorderLayout(5, 5));
        this.comboBox.setEditable(true);
        pnlUsers.add((Component)this.comboBox, "North");
        JScrollPane scrollPane = new JScrollPane();
        pnlUsers.add((Component)scrollPane, "Center");
        scrollPane.setViewportView(this.list);
        this.btnCall.addActionListener(this);
        this.btnHup.addActionListener(this);
    }

    public void updateProperties() {
        this.currentUser = UserData.readProperties(this.propManager);
    }

    public void init() {
        this.updateProperties();
        try {
            this.messageService = new MessageService(this);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to start message service! Exiting.", "Error", 0);
            System.exit(1);
        }
        this.mic = new Microphone(this.messageService);
        this.chatDialog = new ChatDialog(this, this.messageService);
        this.discoveryService = new DiscoveryService(this.currentUser);
        this.discoveryService.startDiscovery();
        this.messageService.startRecv();
        SfxPlayer.play(this.getClass().getResource("/startup.wav"));
        this.setVisible(true);
        this.chatDialog.setVisible(true);
    }

    public void setCallable(boolean canCall) {
        this.btnCall.setEnabled(canCall);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.btnCall) {
            String contact = this.comboBox.getSelectedItem().toString();
            CallInitializer ci = new CallInitializer(this, this.messageService, this.discoveryService, contact, this.currentUser);
            ci.beginCalling();
        } else if (arg0.getSource() == this.btnHup) {
            this.messageService.endAllCalls();
        }
    }

    public UserData getCurrentUser() {
        return this.currentUser;
    }

    public void notifyCallersChanged() {
        Object[] callers = this.messageService.getConnected().toArray();
        this.list.setListData(callers);
        if (callers.length > 0) {
            this.mic.startMic();
        } else {
            this.mic.stopMic();
        }
        this.setTitle("HyperConference - " + callers.length + " Connected");
    }

    public void messageRecieved(UserData userData, String message) {
        this.chatDialog.chatRecieved(userData, message);
    }
}

