/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference;

import com.vulpovile.hyperconference.codec.base.uLaw;
import com.vulpovile.hyperconference.net.MessageService;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.TargetDataLine;

public class Microphone
implements Runnable {
    Thread parentThread;
    boolean connected;
    MessageService messageService;

    public Microphone(MessageService messageService) {
        this.messageService = messageService;
    }

    public void run() {
        block9: {
            AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
            TargetDataLine microphone = null;
            try {
                try {
                    microphone = AudioSystem.getTargetDataLine(format);
                    microphone.open(format);
                    microphone.start();
                    byte[] buffer = new byte[1024];
                    System.out.println("Recording...");
                    while (this.connected) {
                        int count = microphone.read(buffer, 0, buffer.length);
                        if (count <= 0) continue;
                        byte[] compressed = uLaw.encode(buffer, count);
                        this.messageService.sendVoicePacket(compressed);
                    }
                }
                catch (Exception exception) {
                    if (microphone != null) {
                        microphone.stop();
                        microphone.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (microphone != null) {
                    microphone.stop();
                    microphone.close();
                }
                throw throwable;
            }
            if (microphone != null) {
                microphone.stop();
                microphone.close();
            }
        }
        this.stopMic();
        this.parentThread = null;
        System.out.println("Recording stopped");
    }

    public void stopMic() {
        this.connected = false;
        if (this.parentThread != null) {
            this.parentThread.interrupt();
        }
    }

    public void startMic() {
        if (!this.connected && this.parentThread == null) {
            this.connected = true;
            this.parentThread = new Thread(this);
            this.parentThread.start();
        }
    }
}

