/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference;

import com.vulpovile.hyperconference.MainInterface;
import com.vulpovile.hyperconference.PropertyManager;
import com.vulpovile.hyperconference.ui.ConfigureDialog;
import com.vulpovile.hyperconference.util.DPIUtil;
import com.vulpovile.hyperconference.util.Util;
import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.util.Map;
import javax.swing.UIManager;

public class StartupClass {
    public static void main(String[] args) {
        final Map<String, String> parsedArgs = Util.parseArgs(args, true);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (parsedArgs.containsKey("scale")) {
                    try {
                        System.out.println("Scale: " + (String)parsedArgs.get("scale"));
                        DPIUtil.setNewScale(Float.parseFloat((String)parsedArgs.get("scale")));
                        DPIUtil.setDefaultUIFontsToScale();
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                PropertyManager propManager = new PropertyManager(new File("hypercon.prp"));
                MainInterface mainInterface = new MainInterface(propManager);
                propManager.load();
                if (propManager.getProperty("username", "").trim().length() <= 0) {
                    new ConfigureDialog((Frame)mainInterface, propManager).setVisible(true);
                    if (propManager.getProperty("username", "").trim().length() <= 0) {
                        System.out.println(":(");
                        System.exit(1);
                    }
                }
                mainInterface.init();
                DPIUtil.scaleComponentTree(mainInterface);
            }
        });
    }
}

