/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.ui;

import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.net.MessageService;
import com.vulpovile.hyperconference.util.DPIUtil;
import com.vulpovile.hyperconference.util.SfxPlayer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.SocketAddress;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class RingDialog
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    long timeout = 6L;
    MessageService messageServer;
    UserData userData;
    Timer timer = null;
    JButton btnAccept = new JButton("Accept");
    JButton btnDecline = new JButton("Cancel");
    long lastRingTime = 0L;

    public RingDialog(MessageService messageServer, UserData userData) {
        this.messageServer = messageServer;
        this.userData = userData;
        this.setBounds(DPIUtil.sRect(100, 100, 450, 73));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "Center");
        this.btnAccept.setActionCommand("OK");
        buttonPane.add(this.btnAccept);
        this.getRootPane().setDefaultButton(this.btnAccept);
        this.btnDecline.setActionCommand("Cancel");
        buttonPane.add(this.btnDecline);
        JLabel lblIncomingCallFrom = new JLabel("Incoming call from " + userData.alias);
        this.getContentPane().add((Component)lblIncomingCallFrom, "West");
        this.setDefaultCloseOperation(0);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        Insets toolHeight = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        int x = scrSize.width - this.getWidth() - toolHeight.right;
        int y = scrSize.height - this.getHeight() - toolHeight.bottom;
        this.setLocation(x, y);
        this.setAlwaysOnTop(true);
        this.btnDecline.addActionListener(this);
        this.btnAccept.addActionListener(this);
    }

    public void startDialog() {
        this.setVisible(true);
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RingDialog.this.repaint();
                --RingDialog.this.timeout;
                if (RingDialog.this.timeout <= 0L) {
                    RingDialog.this.stopDialog();
                }
            }
        });
        this.timer.start();
    }

    public void stopDialog() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
            this.messageServer.ringStopped(this.userData.address);
        }
        this.dispose();
    }

    public void ring() {
        if (this.lastRingTime < System.currentTimeMillis() + 100L) {
            this.lastRingTime = System.currentTimeMillis();
            SfxPlayer.play(this.getClass().getResource("/ringin.wav"));
        }
        this.timeout = 6L;
    }

    public SocketAddress getInetAddress() {
        return this.userData.address;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnDecline) {
            this.messageServer.removeCaller(this.userData.address, true);
        } else if (e.getSource() == this.btnAccept) {
            this.messageServer.acceptCall(this.userData);
        }
    }
}

