/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;

public abstract class Ltp {
    public abstract int quant(float[] var1, float[] var2, int var3, float[] var4, float[] var5, float[] var6, float[] var7, int var8, int var9, int var10, float var11, int var12, int var13, Bits var14, float[] var15, int var16, float[] var17, int var18);

    public abstract int unquant(float[] var1, int var2, int var3, float var4, int var5, float[] var6, Bits var7, int var8, int var9, float var10);

    protected static float inner_prod(float[] x, int xs, float[] y, int ys, int len) {
        float sum1 = 0.0f;
        float sum2 = 0.0f;
        float sum3 = 0.0f;
        float sum4 = 0.0f;
        int i = 0;
        while (i < len) {
            sum1 += x[xs + i] * y[ys + i];
            sum2 += x[xs + i + 1] * y[ys + i + 1];
            sum3 += x[xs + i + 2] * y[ys + i + 2];
            sum4 += x[xs + i + 3] * y[ys + i + 3];
            i += 4;
        }
        return sum1 + sum2 + sum3 + sum4;
    }

    protected static void open_loop_nbest_pitch(float[] sw, int swIdx, int start, int end, int len, int[] pitch, float[] gain, int N) {
        float[] best_score = new float[N];
        float[] corr = new float[end - start + 1];
        float[] energy = new float[end - start + 2];
        float[] score = new float[end - start + 1];
        int i = 0;
        while (i < N) {
            best_score[i] = -1.0f;
            gain[i] = 0.0f;
            pitch[i] = start;
            ++i;
        }
        energy[0] = Ltp.inner_prod(sw, swIdx - start, sw, swIdx - start, len);
        float e0 = Ltp.inner_prod(sw, swIdx, sw, swIdx, len);
        i = start;
        while (i <= end) {
            energy[i - start + 1] = energy[i - start] + sw[swIdx - i - 1] * sw[swIdx - i - 1] - sw[swIdx - i + len - 1] * sw[swIdx - i + len - 1];
            if (energy[i - start + 1] < 1.0f) {
                energy[i - start + 1] = 1.0f;
            }
            ++i;
        }
        i = start;
        while (i <= end) {
            corr[i - start] = 0.0f;
            score[i - start] = 0.0f;
            ++i;
        }
        i = start;
        while (i <= end) {
            corr[i - start] = Ltp.inner_prod(sw, swIdx, sw, swIdx - i, len);
            score[i - start] = corr[i - start] * corr[i - start] / (energy[i - start] + 1.0f);
            ++i;
        }
        i = start;
        while (i <= end) {
            if (score[i - start] > best_score[N - 1]) {
                float g1 = corr[i - start] / (energy[i - start] + 10.0f);
                float g = (float)Math.sqrt(g1 * corr[i - start] / (e0 + 10.0f));
                if (g > g1) {
                    g = g1;
                }
                if (g < 0.0f) {
                    g = 0.0f;
                }
                int j = 0;
                while (j < N) {
                    if (score[i - start] > best_score[j]) {
                        int k = N - 1;
                        while (k > j) {
                            best_score[k] = best_score[k - 1];
                            pitch[k] = pitch[k - 1];
                            gain[k] = gain[k - 1];
                            --k;
                        }
                        best_score[j] = score[i - start];
                        pitch[j] = i;
                        gain[j] = g;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

