/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk;

import com.vulpovile.hypertalk.DiscoveryServer;
import com.vulpovile.hypertalk.MessageServer;
import com.vulpovile.hypertalk.PropertyManager;
import com.vulpovile.hypertalk.ui.CallInitializer;
import com.vulpovile.hypertalk.ui.ConfigureDialog;
import com.vulpovile.hypertalk.util.SfxPlayer;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class MainInterface
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    PropertyManager propertyManager;
    JButton btnPlaceCall = new JButton("Place Call");
    private JButton btnReconfigure;
    DiscoveryServer discoveryServer;
    MessageServer messageServer;

    public MainInterface(PropertyManager propertyManager) {
        super("HyperTalk");
        this.setResizable(false);
        this.setSize(344, 125);
        this.propertyManager = propertyManager;
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(null);
        JLabel lblUserQuery = new JLabel("User Query:");
        lblUserQuery.setBounds(12, 12, 98, 17);
        this.getContentPane().add(lblUserQuery);
        this.textField = new JTextField();
        this.textField.setBounds(92, 10, 231, 21);
        this.getContentPane().add(this.textField);
        this.textField.setColumns(10);
        this.btnPlaceCall.setBounds(218, 49, 105, 27);
        this.getContentPane().add(this.btnPlaceCall);
        this.btnReconfigure = new JButton("Reconfigure");
        this.btnReconfigure.addActionListener(this);
        this.btnReconfigure.setBounds(92, 49, 115, 27);
        this.getContentPane().add(this.btnReconfigure);
        this.btnPlaceCall.addActionListener(this);
        this.setLocationRelativeTo(null);
    }

    public void init() {
        this.discoveryServer = new DiscoveryServer(this.propertyManager.getProperty("username"));
        this.messageServer = new MessageServer();
        this.discoveryServer.startDiscovery();
        this.messageServer.startRinger();
        this.setVisible(true);
        SfxPlayer.play(this.getClass().getResource("/blip.wav"));
    }

    public void setCallable(boolean canCall) {
        this.btnPlaceCall.setEnabled(canCall);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnPlaceCall) {
            String identifier = this.textField.getText().trim();
            CallInitializer ci = new CallInitializer(this, identifier, this.propertyManager.getProperty("username"));
            ci.beginCalling();
        } else if (e.getSource() == this.btnReconfigure) {
            this.setVisible(false);
            ConfigureDialog dialog = new ConfigureDialog((Frame)this, this.propertyManager);
            dialog.setVisible(true);
            this.setVisible(true);
            this.discoveryServer.updateIdentifier(this.propertyManager.getProperty("username"));
        }
    }
}

